/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.gson.spi.JsonLogHelper;

public class ElasticsearchResponseFormatter {
    private final String stringRepresentation;

    public ElasticsearchResponseFormatter(ElasticsearchResponse response) {
        this.stringRepresentation = ElasticsearchResponseFormatter.formatResponse(response);
    }

    public static String formatResponse(ElasticsearchResponse response) {
        if (response == null) {
            return "(no response)";
        }
        JsonLogHelper helper = JsonLogHelper.get();
        StringBuilder sb = new StringBuilder(180);
        sb.append(response.getStatusCode()).append(" '").append(response.getStatusMessage()).append("' with body ").append(helper.toString(response.getBody()));
        return sb.toString();
    }

    public String toString() {
        return this.stringRepresentation;
    }
}

