/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import com.google.gson.Gson;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexAdministrationClient;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.link.impl.ElasticsearchLink;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestratorImplementor;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestratorProvider;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopeModel;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DocumentReferenceExtractionHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionBackendContext;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryBuilder;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.ElasticsearchIndexIndexer;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.ElasticsearchIndexIndexingPlan;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.ElasticsearchIndexWorkspace;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionBackendContext;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.util.common.reporting.EventContext;

public class IndexManagerBackendContext
implements SearchBackendContext,
WorkExecutionBackendContext {
    private final EventContext eventContext;
    private final ElasticsearchLink link;
    private final Gson userFacingGson;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchWorkOrchestratorProvider orchestratorProvider;
    private final ElasticsearchWorkOrchestrator queryOrchestrator;
    private final DocumentReferenceExtractionHelper documentReferenceExtractionHelper;
    private final SearchProjectionBackendContext searchProjectionBackendContext;

    public IndexManagerBackendContext(EventContext eventContext, ElasticsearchLink link, Gson userFacingGson, DocumentReferenceExtractionHelper documentReferenceExtractionHelper, MultiTenancyStrategy multiTenancyStrategy, ElasticsearchWorkOrchestratorProvider orchestratorProvider, ElasticsearchWorkOrchestrator queryOrchestrator) {
        this.eventContext = eventContext;
        this.link = link;
        this.userFacingGson = userFacingGson;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.orchestratorProvider = orchestratorProvider;
        this.queryOrchestrator = queryOrchestrator;
        this.documentReferenceExtractionHelper = documentReferenceExtractionHelper;
        this.searchProjectionBackendContext = new SearchProjectionBackendContext(documentReferenceExtractionHelper);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.eventContext + "]";
    }

    @Override
    public IndexIndexingPlan<ElasticsearchDocumentObjectBuilder> createIndexingPlan(ElasticsearchWorkOrchestrator orchestrator, WorkExecutionIndexManagerContext indexManagerContext, DocumentRefreshStrategy refreshStrategy, BackendSessionContext sessionContext) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new ElasticsearchIndexIndexingPlan(this.link.getWorkBuilderFactory(), orchestrator, indexManagerContext, refreshStrategy, sessionContext);
    }

    @Override
    public IndexIndexer<ElasticsearchDocumentObjectBuilder> createIndexer(ElasticsearchWorkOrchestrator orchestrator, WorkExecutionIndexManagerContext indexManagerContext, BackendSessionContext sessionContext) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new ElasticsearchIndexIndexer(this.link.getWorkBuilderFactory(), orchestrator, indexManagerContext, sessionContext);
    }

    @Override
    public IndexWorkspace createWorkspace(ElasticsearchWorkOrchestrator orchestrator, WorkExecutionIndexManagerContext indexManagerContext, DetachedBackendSessionContext sessionContext) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new ElasticsearchIndexWorkspace(this.link.getWorkBuilderFactory(), this.multiTenancyStrategy, orchestrator, indexManagerContext, sessionContext);
    }

    @Override
    public DocumentReferenceExtractionHelper getDocumentReferenceExtractionHelper() {
        return this.documentReferenceExtractionHelper;
    }

    @Override
    public SearchProjectionBackendContext getSearchProjectionBackendContext() {
        return this.searchProjectionBackendContext;
    }

    @Override
    public ElasticsearchSearchContext createSearchContext(BackendMappingContext mappingContext, ElasticsearchScopeModel scopeModel) {
        return new ElasticsearchSearchContext(mappingContext, this.userFacingGson, this.link.getJsonSyntaxHelper(), this.multiTenancyStrategy, scopeModel);
    }

    @Override
    public <H> ElasticsearchSearchQueryBuilder<H> createSearchQueryBuilder(ElasticsearchSearchContext searchContext, BackendSessionContext sessionContext, LoadingContextBuilder<?, ?> loadingContextBuilder, ElasticsearchSearchProjection<?, H> rootProjection) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new ElasticsearchSearchQueryBuilder<H>(this.link.getWorkBuilderFactory(), this.link.getSearchResultExtractorFactory(), this.queryOrchestrator, this.multiTenancyStrategy, searchContext, sessionContext, loadingContextBuilder, rootProjection);
    }

    EventContext getEventContext() {
        return this.eventContext;
    }

    ElasticsearchIndexAdministrationClient createAdministrationClient(URLEncodedString indexName, ElasticsearchIndexModel model) {
        IndexMetadata metadata = new IndexMetadata();
        metadata.setName(model.getElasticsearchIndexName());
        metadata.setSettings(model.getSettings());
        metadata.setMapping(model.getMapping());
        return new ElasticsearchIndexAdministrationClient(this.link, this.orchestratorProvider.getRootParallelOrchestrator(), indexName, metadata);
    }

    ElasticsearchWorkOrchestratorImplementor createSerialOrchestrator(String indexName) {
        return this.orchestratorProvider.createSerialOrchestrator("Elasticsearch serial work orchestrator for index " + indexName);
    }

    ElasticsearchWorkOrchestratorImplementor createParallelOrchestrator(String indexName) {
        return this.orchestratorProvider.createParallelOrchestrator("Elasticsearch parallel work orchestrator for index " + indexName);
    }

    String toElasticsearchId(String tenantId, String id) {
        return this.multiTenancyStrategy.toElasticsearchId(tenantId, id);
    }
}

