/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import java.util.List;
import org.hibernate.search.backend.elasticsearch.document.impl.DocumentMetadataContributor;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexManagerImpl;
import org.hibernate.search.backend.elasticsearch.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.ElasticsearchIndexSettingsBuilder;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaRootNodeBuilder;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;

public class ElasticsearchIndexManagerBuilder
implements IndexManagerBuilder<ElasticsearchDocumentObjectBuilder> {
    private final IndexManagerBackendContext backendContext;
    private final String hibernateSearchIndexName;
    private final String elasticsearchIndexName;
    private final ElasticsearchIndexSchemaRootNodeBuilder schemaRootNodeBuilder;
    private final ElasticsearchIndexSettingsBuilder settingsBuilder;
    private final List<DocumentMetadataContributor> documentMetadataContributors;

    public ElasticsearchIndexManagerBuilder(IndexManagerBackendContext backendContext, String hibernateSearchIndexName, String elasticsearchIndexName, ElasticsearchIndexSchemaRootNodeBuilder schemaRootNodeBuilder, ElasticsearchIndexSettingsBuilder settingsBuilder, List<DocumentMetadataContributor> documentMetadataContributors) {
        this.backendContext = backendContext;
        this.hibernateSearchIndexName = hibernateSearchIndexName;
        this.elasticsearchIndexName = elasticsearchIndexName;
        this.schemaRootNodeBuilder = schemaRootNodeBuilder;
        this.settingsBuilder = settingsBuilder;
        this.documentMetadataContributors = documentMetadataContributors;
    }

    public void closeOnFailure() {
    }

    public IndexSchemaRootNodeBuilder getSchemaRootNodeBuilder() {
        return this.schemaRootNodeBuilder;
    }

    public ElasticsearchIndexManagerImpl build() {
        URLEncodedString encodedElasticsearchIndexName = URLEncodedString.fromString(this.elasticsearchIndexName);
        ElasticsearchIndexModel model = this.schemaRootNodeBuilder.build(this.hibernateSearchIndexName, encodedElasticsearchIndexName, this.settingsBuilder);
        return new ElasticsearchIndexManagerImpl(this.backendContext, this.hibernateSearchIndexName, encodedElasticsearchIndexName, model, this.documentMetadataContributors);
    }
}

