/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.admin.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ValidationContextElement;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ValidationContextType;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.AssertionFailure;

final class ValidationErrorCollector {
    private final Deque<ValidationContextElement> currentContext = new ArrayDeque<ValidationContextElement>();
    private final ContextualFailureCollector failureCollector;
    private boolean hasError = false;

    ValidationErrorCollector() {
        this.failureCollector = null;
    }

    ValidationErrorCollector(ContextualFailureCollector failureCollector) {
        this.failureCollector = failureCollector;
    }

    void push(ValidationContextType contextType, String name) {
        this.currentContext.addLast(new ValidationContextElement(contextType, name));
    }

    void pop() {
        this.currentContext.removeLast();
    }

    void addError(String errorMessage) {
        if (this.failureCollector != null) {
            this.appendContext(this.failureCollector, this.currentContext).add(errorMessage);
        }
        this.hasError = true;
    }

    boolean hasError() {
        return this.hasError;
    }

    private ContextualFailureCollector appendContext(ContextualFailureCollector failureCollector, Iterable<ValidationContextElement> contextElements) {
        Iterator<ValidationContextElement> iterator = contextElements.iterator();
        if (!iterator.hasNext()) {
            return failureCollector;
        }
        ContextualFailureCollector result = failureCollector;
        StringBuilder pathBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            result = this.appendContext(result, iterator.next(), pathBuilder, iterator.hasNext());
        }
        return result;
    }

    private ContextualFailureCollector appendContext(ContextualFailureCollector currentResult, ValidationContextElement element, StringBuilder pathBuilder, boolean hasNext) {
        ValidationContextType type = element.getType();
        String name = element.getName();
        if (ValidationContextType.MAPPING_PROPERTY.equals((Object)type) || ValidationContextType.MAPPING_PROPERTY_FIELD.equals((Object)type)) {
            if (pathBuilder.length() > 0) {
                pathBuilder.append(".");
            }
            pathBuilder.append(name);
            if (!hasNext) {
                return currentResult.withContext(EventContexts.fromIndexFieldAbsolutePath((String)pathBuilder.toString()));
            }
            return currentResult;
        }
        if (pathBuilder.length() > 0) {
            currentResult = currentResult.withContext(EventContexts.fromIndexFieldAbsolutePath((String)pathBuilder.toString()));
            pathBuilder.setLength(0);
        }
        switch (type) {
            case ANALYZER: {
                return currentResult.withContext(EventContexts.fromAnalyzer((String)name));
            }
            case NORMALIZER: {
                return currentResult.withContext(EventContexts.fromNormalizer((String)name));
            }
            case CHAR_FILTER: {
                return currentResult.withContext(EventContexts.fromCharFilter((String)name));
            }
            case TOKENIZER: {
                return currentResult.withContext(EventContexts.fromTokenizer((String)name));
            }
            case TOKEN_FILTER: {
                return currentResult.withContext(EventContexts.fromTokenFilter((String)name));
            }
        }
        throw new AssertionFailure("Unexpected validation context element type: " + (Object)((Object)type));
    }
}

