/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.admin.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaCreator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchSchemaCreatorImpl
implements ElasticsearchSchemaCreator {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchSchemaAccessor schemaAccessor;

    public ElasticsearchSchemaCreatorImpl(ElasticsearchSchemaAccessor schemaAccessor) {
        this.schemaAccessor = schemaAccessor;
    }

    @Override
    public CompletableFuture<?> createIndex(IndexMetadata indexMetadata, ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        URLEncodedString indexName = indexMetadata.getName();
        return this.schemaAccessor.createIndex(indexName, indexMetadata.getSettings(), indexMetadata.getMapping()).thenCompose(ignored -> this.schemaAccessor.waitForIndexStatus(indexName, executionOptions));
    }

    @Override
    public CompletableFuture<Boolean> createIndexIfAbsent(IndexMetadata indexMetadata, ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        URLEncodedString indexName = indexMetadata.getName();
        return ((CompletableFuture)this.schemaAccessor.indexExists(indexName).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return CompletableFuture.completedFuture(false);
            }
            return this.schemaAccessor.createIndexIfAbsent(indexName, indexMetadata.getSettings(), indexMetadata.getMapping());
        })).thenCompose(created -> this.schemaAccessor.waitForIndexStatus(indexName, executionOptions).thenApply(ignored -> created));
    }

    @Override
    public CompletableFuture<?> checkIndexExists(URLEncodedString indexName, ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        return this.schemaAccessor.indexExists(indexName).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return this.schemaAccessor.waitForIndexStatus(indexName, executionOptions);
            }
            throw log.indexMissing(indexName);
        });
    }
}

