/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.admin.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.index.IndexStatus;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.index.settings.esnative.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.link.impl.ElasticsearchLink;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.result.impl.CreateIndexResult;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchSchemaAccessor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchLink link;
    private final ElasticsearchWorkOrchestrator orchestrator;

    public ElasticsearchSchemaAccessor(ElasticsearchLink link, ElasticsearchWorkOrchestrator orchestrator) {
        this.link = link;
        this.orchestrator = orchestrator;
    }

    public CompletableFuture<?> createIndex(URLEncodedString indexName, IndexSettings settings, RootTypeMapping mapping) {
        Object work = this.getWorkFactory().createIndex(indexName).settings(settings).mapping(mapping).build();
        return this.execute((ElasticsearchWork)work);
    }

    public CompletableFuture<Boolean> createIndexIfAbsent(URLEncodedString indexName, IndexSettings settings, RootTypeMapping mapping) {
        Object work = this.getWorkFactory().createIndex(indexName).settings(settings).mapping(mapping).ignoreExisting().build();
        return this.execute((ElasticsearchWork)work).thenApply(CreateIndexResult.CREATED::equals);
    }

    public CompletableFuture<Boolean> indexExists(URLEncodedString indexName) {
        Object work = this.getWorkFactory().indexExists(indexName).build();
        return this.execute((ElasticsearchWork)work);
    }

    public CompletableFuture<IndexMetadata> getCurrentIndexMetadata(URLEncodedString indexName) {
        Object work = this.getWorkFactory().getIndexMetadata(indexName).build();
        return this.execute((ElasticsearchWork)work).exceptionally(Futures.handler(e -> {
            throw log.elasticsearchIndexMetadataRetrievalForValidationFailed(Throwables.expectException((Throwable)e));
        }));
    }

    public CompletableFuture<?> updateSettings(URLEncodedString indexName, IndexSettings settings) {
        Object work = this.getWorkFactory().putIndexSettings(indexName, settings).build();
        return this.execute((ElasticsearchWork)work).exceptionally(Futures.handler(e -> {
            throw log.elasticsearchSettingsUpdateFailed(indexName.original, Throwables.expectException((Throwable)e));
        }));
    }

    public CompletableFuture<?> putMapping(URLEncodedString indexName, RootTypeMapping mapping) {
        Object work = this.getWorkFactory().putIndexTypeMapping(indexName, mapping).build();
        return this.execute((ElasticsearchWork)work).exceptionally(Futures.handler(e -> {
            throw log.elasticsearchMappingCreationFailed(indexName.original, e.getMessage(), Throwables.expectException((Throwable)e));
        }));
    }

    public CompletableFuture<?> waitForIndexStatus(URLEncodedString indexName, ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        IndexStatus requiredIndexStatus = executionOptions.getRequiredStatus();
        String timeoutAndUnit = executionOptions.getRequiredStatusTimeoutInMs() + "ms";
        Object work = this.getWorkFactory().waitForIndexStatusWork(indexName, requiredIndexStatus, timeoutAndUnit).build();
        return this.execute((ElasticsearchWork)work).exceptionally(Futures.handler(e -> {
            throw log.unexpectedIndexStatus(indexName.original, requiredIndexStatus.getElasticsearchString(), timeoutAndUnit, Throwables.expectException((Throwable)e));
        }));
    }

    public CompletableFuture<?> dropIndexIfExisting(URLEncodedString indexName) {
        Object work = this.getWorkFactory().dropIndex(indexName).ignoreIndexNotFound().build();
        return this.execute((ElasticsearchWork)work);
    }

    public CompletableFuture<?> closeIndex(URLEncodedString indexName) {
        Object work = this.getWorkFactory().closeIndex(indexName).build();
        return this.execute((ElasticsearchWork)work).thenRun(() -> log.closedIndex(indexName));
    }

    public CompletableFuture<?> openIndex(URLEncodedString indexName) {
        Object work = this.getWorkFactory().openIndex(indexName).build();
        return this.execute((ElasticsearchWork)work).thenRun(() -> log.openedIndex(indexName));
    }

    private ElasticsearchWorkBuilderFactory getWorkFactory() {
        return this.link.getWorkBuilderFactory();
    }

    private <T> CompletableFuture<T> execute(ElasticsearchWork<T> work) {
        return this.orchestrator.submit(work);
    }
}

