/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.admin.gson.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.index.admin.gson.impl.AnalysisJsonElementEquivalence;
import org.hibernate.search.backend.elasticsearch.index.admin.gson.impl.AnalysisJsonElementUnorderedArrayEquivalence;

public class AnalysisParameterEquivalenceRegistry {
    private static final AnalysisJsonElementEquivalence DEFAULT_ELEMENT_EQUIVALENCE = new AnalysisJsonElementEquivalence();
    private static final AnalysisJsonElementEquivalence UNORDERED_ARRAY_EQUIVALENCE = new AnalysisJsonElementUnorderedArrayEquivalence(DEFAULT_ELEMENT_EQUIVALENCE);
    private final Map<String, Map<String, AnalysisJsonElementEquivalence>> equivalences;

    private AnalysisParameterEquivalenceRegistry(Map<String, Map<String, AnalysisJsonElementEquivalence>> equivalences) {
        this.equivalences = equivalences;
    }

    public AnalysisJsonElementEquivalence get(String type, String parameter) {
        Map<String, AnalysisJsonElementEquivalence> mapForType = this.equivalences.get(type);
        AnalysisJsonElementEquivalence result = mapForType == null ? null : mapForType.get(parameter);
        return result == null ? DEFAULT_ELEMENT_EQUIVALENCE : result;
    }

    public static class ParameterBuilder {
        private final TypeBuilder parent;
        private final String parameterName;

        private ParameterBuilder(TypeBuilder parent, String parameterName) {
            this.parent = parent;
            this.parameterName = parameterName;
        }

        public TypeBuilder unorderedArray() {
            this.parent.add(this.parameterName, UNORDERED_ARRAY_EQUIVALENCE);
            return this.parent;
        }
    }

    public static class TypeBuilder {
        private final Builder parent;
        private final Map<String, AnalysisJsonElementEquivalence> equivalences;

        private TypeBuilder(Builder parent, Map<String, AnalysisJsonElementEquivalence> equivalences) {
            this.parent = parent;
            this.equivalences = equivalences;
        }

        public ParameterBuilder param(String name) {
            return new ParameterBuilder(this, name);
        }

        private void add(String parameterName, AnalysisJsonElementEquivalence equivalence) {
            this.equivalences.put(parameterName, equivalence);
        }

        public Builder end() {
            return this.parent;
        }
    }

    public static class Builder {
        private final Map<String, Map<String, AnalysisJsonElementEquivalence>> equivalences = new HashMap<String, Map<String, AnalysisJsonElementEquivalence>>();

        public TypeBuilder type(String name) {
            Map<String, AnalysisJsonElementEquivalence> mapForType = this.equivalences.get(name);
            if (mapForType == null) {
                mapForType = new HashMap<String, AnalysisJsonElementEquivalence>();
                this.equivalences.put(name, mapForType);
            }
            return new TypeBuilder(this, mapForType);
        }

        public AnalysisParameterEquivalenceRegistry build() {
            return new AnalysisParameterEquivalenceRegistry(this.equivalences);
        }
    }
}

