/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.gson.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.function.Supplier;
import org.hibernate.search.backend.elasticsearch.gson.impl.AbstractNonRootJsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonArrayAccessorImpl;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonBooleanAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonCompositeAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonDoubleAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonFloatAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonIntegerAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonLongAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessorImpl;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonStringAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnexpectedJsonElementTypeException;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnknownTypeJsonAccessor;

abstract class AbstractCrawlingJsonAccessor<P extends JsonElement>
extends AbstractNonRootJsonAccessor<P, JsonElement>
implements UnknownTypeJsonAccessor {
    public AbstractCrawlingJsonAccessor(JsonCompositeAccessor<P> parentAccessor) {
        super(parentAccessor);
    }

    @Override
    protected JsonCompositeAccessor<P> getParentAccessor() {
        return (JsonCompositeAccessor)super.getParentAccessor();
    }

    @Override
    public Optional<JsonElement> get(JsonObject root) throws UnexpectedJsonElementTypeException {
        return this.getParentAccessor().get(root).map(this::doGet);
    }

    protected abstract JsonElement doGet(P var1);

    @Override
    public boolean hasExplicitValue(JsonObject root) {
        return this.getParentAccessor().get(root).map(this::doGet).isPresent();
    }

    @Override
    public void set(JsonObject root, JsonElement newValue) throws UnexpectedJsonElementTypeException {
        Object parent = this.getParentAccessor().getOrCreate(root);
        this.doSet(parent, newValue);
    }

    protected abstract void doSet(P var1, JsonElement var2);

    @Override
    public JsonElement getOrCreate(JsonObject root, Supplier<? extends JsonElement> newValueSupplier) throws UnexpectedJsonElementTypeException {
        Object parent = this.getParentAccessor().getOrCreate(root);
        JsonElement currentValue = this.doGet(parent);
        if (currentValue == null || currentValue.isJsonNull()) {
            JsonElement result = newValueSupplier.get();
            this.doSet(parent, result);
            return result;
        }
        return currentValue;
    }

    @Override
    public void add(JsonObject root, JsonElement newValue) throws UnexpectedJsonElementTypeException {
        Object parent = this.getParentAccessor().getOrCreate(root);
        JsonElement currentValue = this.doGet(parent);
        if (currentValue == null) {
            this.doSet(parent, newValue);
        } else if (JsonElementTypes.ARRAY.isInstance(currentValue)) {
            JsonElementTypes.ARRAY.fromElement(currentValue).add(newValue);
        } else {
            JsonArray array = new JsonArray();
            array.add(currentValue);
            array.add(newValue);
            this.doSet(parent, (JsonElement)array);
        }
    }

    @Override
    public JsonObjectAccessor asObject() {
        return new JsonObjectAccessorImpl(this);
    }

    @Override
    public JsonArrayAccessor asArray() {
        return new JsonArrayAccessorImpl(this);
    }

    @Override
    public JsonAccessor<String> asString() {
        return new JsonStringAccessor(this);
    }

    @Override
    public JsonAccessor<Boolean> asBoolean() {
        return new JsonBooleanAccessor(this);
    }

    @Override
    public JsonAccessor<Integer> asInteger() {
        return new JsonIntegerAccessor(this);
    }

    @Override
    public JsonAccessor<Long> asLong() {
        return new JsonLongAccessor(this);
    }

    @Override
    public JsonAccessor<Float> asFloat() {
        return new JsonFloatAccessor(this);
    }

    @Override
    public JsonAccessor<Double> asDouble() {
        return new JsonDoubleAccessor(this);
    }

    @Override
    public UnknownTypeJsonAccessor element(int index) {
        return this.asArray().element(index);
    }

    @Override
    public UnknownTypeJsonAccessor property(String propertyName) {
        return this.asObject().property(propertyName);
    }
}

