/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.impl;

import java.util.List;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.types.aggregation.impl.ElasticsearchFieldAggregationBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchFieldSortBuilderFactory;

public class ElasticsearchIndexSchemaFieldNode<F> {
    private final ElasticsearchIndexSchemaObjectNode parent;
    private final String absolutePath;
    private final List<String> nestedPathHierarchy;
    private final boolean multiValued;
    private final ElasticsearchFieldCodec<F> codec;
    private final ElasticsearchFieldPredicateBuilderFactory predicateBuilderFactory;
    private final ElasticsearchFieldSortBuilderFactory sortBuilderFactory;
    private final ElasticsearchFieldProjectionBuilderFactory projectionBuilderFactory;
    private final ElasticsearchFieldAggregationBuilderFactory aggregationBuilderFactory;

    public ElasticsearchIndexSchemaFieldNode(ElasticsearchIndexSchemaObjectNode parent, String relativeFieldName, boolean multiValued, ElasticsearchFieldCodec<F> codec, ElasticsearchFieldPredicateBuilderFactory predicateBuilderFactory, ElasticsearchFieldSortBuilderFactory sortBuilderFactory, ElasticsearchFieldProjectionBuilderFactory projectionBuilderFactory, ElasticsearchFieldAggregationBuilderFactory aggregationBuilderFactory) {
        this.parent = parent;
        this.absolutePath = parent.getAbsolutePath(relativeFieldName);
        this.nestedPathHierarchy = parent.getNestedPathHierarchy();
        this.codec = codec;
        this.predicateBuilderFactory = predicateBuilderFactory;
        this.sortBuilderFactory = sortBuilderFactory;
        this.projectionBuilderFactory = projectionBuilderFactory;
        this.aggregationBuilderFactory = aggregationBuilderFactory;
        this.multiValued = multiValued;
    }

    public ElasticsearchIndexSchemaObjectNode getParent() {
        return this.parent;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getNestedPath() {
        return this.nestedPathHierarchy.isEmpty() ? null : this.nestedPathHierarchy.get(this.nestedPathHierarchy.size() - 1);
    }

    public List<String> getNestedPathHierarchy() {
        return this.nestedPathHierarchy;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public ElasticsearchFieldCodec<F> getCodec() {
        return this.codec;
    }

    public ElasticsearchFieldPredicateBuilderFactory getPredicateBuilderFactory() {
        return this.predicateBuilderFactory;
    }

    public ElasticsearchFieldSortBuilderFactory getSortBuilderFactory() {
        return this.sortBuilderFactory;
    }

    public ElasticsearchFieldProjectionBuilderFactory getProjectionBuilderFactory() {
        return this.projectionBuilderFactory;
    }

    public ElasticsearchFieldAggregationBuilderFactory getAggregationBuilderFactory() {
        return this.aggregationBuilderFactory;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("parent=").append(this.parent).append(", predicateBuilderFactory=").append(this.predicateBuilderFactory).append(", sortBuilderFactory=").append(this.sortBuilderFactory).append(", projectionBuilderFactory=").append(this.projectionBuilderFactory).append("]");
        return sb.toString();
    }
}

