/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.esnative.impl;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.DynamicType;
import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.gson.impl.SerializeExtraProperties;

public abstract class AbstractTypeMapping {
    private DynamicType dynamic;
    protected Map<String, PropertyMapping> properties;
    @SerializeExtraProperties
    private Map<String, JsonElement> extraAttributes;

    public DynamicType getDynamic() {
        return this.dynamic;
    }

    public void setDynamic(DynamicType dynamic) {
        this.dynamic = dynamic;
    }

    public Map<String, PropertyMapping> getProperties() {
        return this.properties == null ? null : Collections.unmodifiableMap(this.properties);
    }

    private Map<String, PropertyMapping> getInitializedProperties() {
        if (this.properties == null) {
            this.properties = new TreeMap<String, PropertyMapping>();
        }
        return this.properties;
    }

    public void addProperty(String name, PropertyMapping mapping) {
        this.getInitializedProperties().put(name, mapping);
    }

    public void removeProperty(String name) {
        this.getInitializedProperties().remove(name);
    }

    public Map<String, JsonElement> getExtraAttributes() {
        return this.extraAttributes;
    }

    public void setExtraAttributes(Map<String, JsonElement> extraAttributes) {
        this.extraAttributes = extraAttributes;
    }

    public String toString() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((Object)this);
    }
}

