/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.client.impl;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.apache.http.nio.ContentEncoder;

class ProgressiveCharBufferWriter
extends Writer {
    private final CharsetEncoder charsetEncoder;
    private final int pageSize;
    private final CharBuffer charBuffer;
    private final Deque<ByteBuffer> needWritingPages = new ArrayDeque<ByteBuffer>(5);
    private ByteBuffer currentPage;
    private ContentEncoder output;
    private boolean flowControlPushingBack = false;

    public ProgressiveCharBufferWriter(Charset charset, int charBufferSize, int pageSize) {
        this.charsetEncoder = charset.newEncoder();
        this.pageSize = pageSize;
        this.charBuffer = CharBuffer.allocate(charBufferSize);
    }

    public void setOutput(ContentEncoder output) {
        this.output = output;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len > this.charBuffer.capacity()) {
            this.flush();
            this.writeToByteBuffer(CharBuffer.wrap(cbuf, off, len));
        } else if (len > this.charBuffer.remaining()) {
            this.flush();
            this.charBuffer.put(cbuf, off, len);
        } else {
            this.charBuffer.put(cbuf, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.charBuffer.position() == 0) {
            return;
        }
        this.charBuffer.flip();
        this.writeToByteBuffer(this.charBuffer);
        this.charBuffer.clear();
    }

    @Override
    public void close() {
    }

    public void resumePendingWrites() throws IOException {
        this.flush();
        this.flowControlPushingBack = false;
        this.attemptFlushPendingBuffers(false);
    }

    public boolean isFlowControlPushingBack() {
        return this.flowControlPushingBack;
    }

    public void flushToOutput() throws IOException {
        this.flush();
        this.flowControlPushingBack = false;
        this.attemptFlushPendingBuffers(true);
    }

    public int byteBufferContentSize() {
        int contentSize = 0;
        for (ByteBuffer page : this.needWritingPages) {
            contentSize += page.remaining();
        }
        if (this.currentPage != null) {
            contentSize += this.currentPage.position();
        }
        return contentSize;
    }

    private void writeToByteBuffer(CharBuffer input) throws IOException {
        CoderResult coderResult;
        while (true) {
            if (this.currentPage == null) {
                this.currentPage = ByteBuffer.allocate(this.pageSize);
            }
            if ((coderResult = this.charsetEncoder.encode(input, this.currentPage, false)).equals(CoderResult.UNDERFLOW)) {
                return;
            }
            if (!coderResult.equals(CoderResult.OVERFLOW)) break;
            this.attemptFlushPendingBuffers(true);
            if (this.currentPage == null) continue;
            this.currentPage.flip();
            this.needWritingPages.add(this.currentPage);
            this.currentPage = null;
        }
        coderResult.throwException();
    }

    private boolean hasRemaining() {
        return !this.needWritingPages.isEmpty() || this.currentPage != null && this.currentPage.position() > 0;
    }

    private void attemptFlushPendingBuffers(boolean flushCurrentPage) throws IOException {
        if (this.output == null) {
            this.flowControlPushingBack = true;
        }
        if (this.flowControlPushingBack || !this.hasRemaining()) {
            return;
        }
        Iterator<ByteBuffer> iterator = this.needWritingPages.iterator();
        while (iterator.hasNext() && !this.flowControlPushingBack) {
            ByteBuffer buffer = iterator.next();
            boolean written = this.write(buffer);
            if (written) {
                iterator.remove();
                continue;
            }
            this.flowControlPushingBack = true;
        }
        if (flushCurrentPage && !this.flowControlPushingBack && this.currentPage != null && this.currentPage.position() > 0) {
            this.currentPage.flip();
            boolean written = this.write(this.currentPage);
            if (!written) {
                this.flowControlPushingBack = true;
                this.needWritingPages.add(this.currentPage);
            }
            this.currentPage = null;
        }
    }

    private boolean write(ByteBuffer buffer) throws IOException {
        int toWrite = buffer.remaining();
        if (toWrite == 0) {
            return true;
        }
        int actuallyWritten = this.output.write(buffer);
        return toWrite == actuallyWritten;
    }
}

