/*
 * Hibernate Search, full-text search for your domain model
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.search.backend.elasticsearch.index.admin.impl;

import java.util.concurrent.CompletableFuture;

import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;

/**
 * An object responsible for validating type mappings retrieved from an existing Elasticsearch instance
 * against Hibernate Search-generated type mappings.
 *
 */
public interface ElasticsearchSchemaValidator {

	/**
	 * Retrieves and validate actual index metadata, throwing an exception if validation fails.
	 * <p>
	 * The metadata mainly contain the type mappings and the index settings.
	 *
	 * @param expectedIndexMetadata The expected metadata, generated by Hibernate Search.
	 * @param failureCollector A collector for validation failures occurring during validation.
	 * @return A future.
	 */
	CompletableFuture<?> validate(IndexMetadata expectedIndexMetadata, ContextualFailureCollector failureCollector);

	/**
	 * Retrieves and validate actual index settings, returning a boolean indicating
	 * whether the actual settings are valid or not.
	 *
	 * @param expectedIndexMetadata The expected metadata, generated by Hibernate Search.
	 * @return A future holding {@code true} if the actual settings are valid, {@code false} otherwise.
	 */
	CompletableFuture<Boolean> isSettingsValid(IndexMetadata expectedIndexMetadata);

}
