package org.hibernate.search.backend.elasticsearch.aws.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String missingPropertyForSigning$str() {
        return "HSEARCH409000: AWS request signing is enabled, but mandatory property '%1$s' is not set.";
    }
    @Override
    public final SearchException missingPropertyForSigning(final String propertyKey) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingPropertyForSigning$str(), propertyKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String missingPropertyForSigningWithCredentialsType$str() {
        return "HSEARCH409001: AWS request signing is enabled with credentials of type '%1$s', but mandatory property '%2$s' is not set.";
    }
    @Override
    public final SearchException missingPropertyForSigningWithCredentialsType(final String credentialsType, final String propertyKey) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingPropertyForSigningWithCredentialsType$str(), credentialsType, propertyKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String obsoleteAccessKeyIdOrSecretAccessKeyForSigning$str() {
        return "HSEARCH409002: Invalid credentials configuration for AWS request signing. The configuration properties '%1$s' and ' '%2$s' are now obsolete. In order to specify static credentials, set property '%3$s' to '%4$s', then set the access key ID using property '%5$s' and the secret access key using property '%6$s'.";
    }
    @Override
    public final SearchException obsoleteAccessKeyIdOrSecretAccessKeyForSigning(final String legacyAccessKeyIdPropertyKey, final String legacySecretAccessKeyPropertyKey, final String credentialsTypePropertyKey, final String credentialsTypePropertyValueStatic, final String accessKeyIdPropertyKey, final String secretAccessKeyPropertyKey) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), obsoleteAccessKeyIdOrSecretAccessKeyForSigning$str(), legacyAccessKeyIdPropertyKey, legacySecretAccessKeyPropertyKey, credentialsTypePropertyKey, credentialsTypePropertyValueStatic, accessKeyIdPropertyKey, secretAccessKeyPropertyKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
