/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.util.async.impl;

import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.hibernate.reactive.util.async.impl.AsyncIterator;
import org.hibernate.reactive.util.async.impl.Either;
import org.hibernate.reactive.util.impl.CompletionStages;

class AsyncIterators {
    static final EmptyAsyncIterator<?> EMPTY_ITERATOR = new EmptyAsyncIterator();

    private AsyncIterators() {
    }

    static <A, R> R finishContainer(A accumulator, Collector<?, A, R> collector) {
        return (R)(collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH) ? accumulator : collector.finisher().apply(accumulator));
    }

    static <T> CompletionStage<T> convertSynchronousException(Supplier<? extends CompletionStage<T>> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable e) {
            return CompletionStages.failedFuture(e);
        }
    }

    static <T, U> AsyncIterator<U> thenApplyImpl(final AsyncIterator<T> it, final Function<? super T, ? extends U> f) {
        return new AsyncIterator<U>(){

            @Override
            public CompletionStage<Either<AsyncIterator.End, U>> nextStage() {
                CompletionStage<Either<AsyncIterator.End, Either>> next = it.nextStage();
                return next.thenApply(this::eitherFunction);
            }

            Either<AsyncIterator.End, U> eitherFunction(Either<AsyncIterator.End, T> either) {
                return either.map(f);
            }

            @Override
            public CompletionStage<Void> close() {
                return it.close();
            }
        };
    }

    static <T, U> AsyncIterator<U> thenComposeImpl(final AsyncIterator<T> it, final Function<? super T, ? extends CompletionStage<U>> f) {
        return new AsyncIterator<U>(){

            @Override
            public CompletionStage<Either<AsyncIterator.End, U>> nextStage() {
                CompletionStage<Either<AsyncIterator.End, Either>> nxt = it.nextStage();
                return nxt.thenCompose(this::eitherFunction);
            }

            private CompletionStage<Either<AsyncIterator.End, U>> eitherFunction(Either<AsyncIterator.End, T> either) {
                return either.fold(end -> AsyncIterator.End.endStage(), (? super R t) -> ((CompletionStage)f.apply(t)).thenApply(Either::right));
            }

            @Override
            public CompletionStage<Void> close() {
                return it.close();
            }
        };
    }

    private static class EmptyAsyncIterator<T>
    implements AsyncIterator<T> {
        private EmptyAsyncIterator() {
        }

        @Override
        public CompletionStage<Either<AsyncIterator.End, T>> nextStage() {
            return AsyncIterator.End.endStage();
        }

        public String toString() {
            return "EmptyAsyncIterator";
        }
    }
}

