/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.type.descriptor.jdbc;

import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectDelegateWrapper;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.reactive.type.descriptor.jdbc.ReactiveArrayJdbcType;
import org.hibernate.reactive.type.descriptor.jdbc.ReactiveOracleArrayJdbcType;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeConstructor;
import org.hibernate.type.spi.TypeConfiguration;

public class ReactiveArrayJdbcTypeConstructor
implements JdbcTypeConstructor {
    public static final ReactiveArrayJdbcTypeConstructor INSTANCE = new ReactiveArrayJdbcTypeConstructor();

    public JdbcType resolveType(TypeConfiguration typeConfiguration, Dialect dialect, BasicType<?> elementType, ColumnTypeInformation columnTypeInformation) {
        Dialect realDialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect);
        if (realDialect instanceof OracleDialect) {
            String typeName;
            String string = typeName = columnTypeInformation == null ? null : columnTypeInformation.getTypeName();
            if (typeName == null || typeName.isBlank()) {
                typeName = ReactiveOracleArrayJdbcType.getTypeName(elementType.getJavaTypeDescriptor(), dialect);
            }
            return new ReactiveOracleArrayJdbcType(elementType.getJdbcType(), typeName);
        }
        return this.resolveType(typeConfiguration, dialect, elementType.getJdbcType(), columnTypeInformation);
    }

    public JdbcType resolveType(TypeConfiguration typeConfiguration, Dialect dialect, JdbcType elementType, ColumnTypeInformation columnTypeInformation) {
        Dialect realDialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect);
        if (realDialect instanceof OracleDialect) {
            return new ReactiveOracleArrayJdbcType(elementType, columnTypeInformation == null ? null : columnTypeInformation.getTypeName());
        }
        return new ReactiveArrayJdbcType(elementType);
    }

    public int getDefaultSqlTypeCode() {
        return 2003;
    }
}

