/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.type.descriptor.jdbc;

import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.hibernate.reactive.adaptor.impl.ArrayAdaptor;
import org.hibernate.reactive.adaptor.impl.ResultSetAdaptor;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.ByteArrayJavaType;
import org.hibernate.type.descriptor.java.ByteJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.internal.JdbcLiteralFormatterArray;
import org.hibernate.type.spi.TypeConfiguration;

public class ReactiveArrayJdbcType
implements JdbcType {
    private final JdbcType elementJdbcType;

    public ReactiveArrayJdbcType(JdbcType elementJdbcType) {
        this.elementJdbcType = elementJdbcType;
    }

    public int getJdbcTypeCode() {
        return 2003;
    }

    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        JavaType elementJavaType = this.elementJdbcType.getJdbcRecommendedJavaTypeMapping(precision, scale, typeConfiguration);
        return typeConfiguration.getJavaTypeRegistry().resolveDescriptor(Array.newInstance(elementJavaType.getJavaTypeClass(), 0).getClass());
    }

    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaTypeDescriptor) {
        Object elementJavaType = javaTypeDescriptor instanceof ByteArrayJavaType ? ByteJavaType.INSTANCE : ((BasicPluralJavaType)javaTypeDescriptor).getElementJavaType();
        JdbcLiteralFormatter elementFormatter = this.elementJdbcType.getJdbcLiteralFormatter((JavaType)elementJavaType);
        return new JdbcLiteralFormatterArray(javaTypeDescriptor, elementFormatter);
    }

    public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
        return java.sql.Array.class;
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                ArrayAdaptor arrayObject = this.getArrayObject(value, options);
                st.setArray(index, arrayObject);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) {
                throw new UnsupportedOperationException();
            }

            private ArrayAdaptor getArrayObject(X value, WrapperOptions options) {
                TypeConfiguration typeConfiguration = options.getSessionFactory().getTypeConfiguration();
                ReactiveArrayJdbcType jdbcType = (ReactiveArrayJdbcType)this.getJdbcType();
                JdbcType elementJdbcType = jdbcType.getElementJdbcType();
                JdbcType underlyingJdbcType = typeConfiguration.getJdbcTypeRegistry().getDescriptor(elementJdbcType.getDefaultSqlTypeCode());
                Class<?> elementJdbcJavaTypeClass = this.elementJdbcJavaTypeClass(options, elementJdbcType, underlyingJdbcType, typeConfiguration);
                Class<?> arrayClass = Array.newInstance(elementJdbcJavaTypeClass, 0).getClass();
                Object[] objects = (Object[])this.getJavaType().unwrap(value, arrayClass, options);
                return new ArrayAdaptor(elementJdbcType, objects);
            }

            private Class<?> elementJdbcJavaTypeClass(WrapperOptions options, JdbcType elementJdbcType, JdbcType underlyingJdbcType, TypeConfiguration typeConfiguration) {
                Class preferredJavaTypeClass = elementJdbcType.getPreferredJavaTypeClass(options);
                Class elementJdbcJavaTypeClass = preferredJavaTypeClass == null ? underlyingJdbcType.getJdbcRecommendedJavaTypeMapping(null, null, typeConfiguration).getJavaTypeClass() : preferredJavaTypeClass;
                return this.convertTypes(elementJdbcJavaTypeClass);
            }

            private Class<?> convertTypes(Class<?> elementJdbcJavaTypeClass) {
                if (Timestamp.class.equals(elementJdbcJavaTypeClass)) {
                    return LocalDateTime.class;
                }
                if (Date.class.equals(elementJdbcJavaTypeClass)) {
                    return LocalDate.class;
                }
                if (Time.class.equals(elementJdbcJavaTypeClass)) {
                    return LocalTime.class;
                }
                return elementJdbcJavaTypeClass;
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) {
                return javaTypeDescriptor.wrap((Object)((ResultSetAdaptor)rs).getArray(paramIndex, ReactiveArrayJdbcType.this.elementJdbcType), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) {
                return javaTypeDescriptor.wrap((Object)((ResultSetAdaptor)((Object)statement)).getArray(index, ReactiveArrayJdbcType.this.elementJdbcType), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)statement.getArray(name), options);
            }
        };
    }

    public String getFriendlyName() {
        return "ARRAY";
    }

    public JdbcType getElementJdbcType() {
        return this.elementJdbcType;
    }

    public String toString() {
        return ReactiveArrayJdbcType.class.getSimpleName() + "(" + this.getFriendlyName() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReactiveArrayJdbcType that = (ReactiveArrayJdbcType)o;
        return this.elementJdbcType.equals(that.elementJdbcType);
    }

    public int hashCode() {
        return this.elementJdbcType.hashCode();
    }
}

