/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.spi;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.reactive.sql.exec.spi.ReactiveRowProcessingState;
import org.hibernate.reactive.sql.exec.spi.ReactiveValuesResultSet;
import org.hibernate.reactive.sql.results.spi.ReactiveResultsConsumer;
import org.hibernate.reactive.sql.results.spi.ReactiveRowReader;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.spi.LoadContexts;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.EntityJavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class ReactiveListResultsConsumer<R>
implements ReactiveResultsConsumer<List<R>, R> {
    private static final ReactiveListResultsConsumer<?> NEVER_DE_DUP_CONSUMER = new ReactiveListResultsConsumer(UniqueSemantic.NEVER);
    private static final ReactiveListResultsConsumer<?> ALLOW_DE_DUP_CONSUMER = new ReactiveListResultsConsumer(UniqueSemantic.ALLOW);
    private static final ReactiveListResultsConsumer<?> IGNORE_DUP_CONSUMER = new ReactiveListResultsConsumer(UniqueSemantic.NONE);
    private static final ReactiveListResultsConsumer<?> DE_DUP_CONSUMER = new ReactiveListResultsConsumer(UniqueSemantic.FILTER);
    private static final ReactiveListResultsConsumer<?> ERROR_DUP_CONSUMER = new ReactiveListResultsConsumer(UniqueSemantic.ASSERT);
    private final UniqueSemantic uniqueSemantic;

    private static void validateUniqueResult(Boolean unique) {
        if (!unique.booleanValue()) {
            throw new HibernateException(String.format(Locale.ROOT, "Duplicate row was found and `%s` was specified", new Object[]{UniqueSemantic.ASSERT}));
        }
    }

    @Override
    public CompletionStage<List<R>> consume(ReactiveValuesResultSet jdbcValues, SharedSessionContractImplementor session, JdbcValuesSourceProcessingOptions processingOptions, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, ReactiveRowProcessingState rowProcessingState, ReactiveRowReader<R> rowReader) {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        TypeConfiguration typeConfiguration = session.getTypeConfiguration();
        QueryOptions queryOptions = rowProcessingState.getQueryOptions();
        persistenceContext.beforeLoad();
        persistenceContext.getLoadContexts().register((JdbcValuesSourceProcessingState)jdbcValuesSourceProcessingState);
        JavaType<R> domainResultJavaType = this.resolveDomainResultJavaType(rowReader.getDomainResultResultJavaType(), rowReader.getResultJavaTypes(), typeConfiguration);
        boolean isEntityResultType = domainResultJavaType instanceof EntityJavaType;
        Results results = (this.uniqueSemantic == UniqueSemantic.ALLOW || this.uniqueSemantic == UniqueSemantic.FILTER) && isEntityResultType ? new EntityResult(domainResultJavaType) : new Results(domainResultJavaType);
        Supplier<CompletionStage<Void>> addToResultsSupplier = this.addToResultsSupplier(results, rowReader, rowProcessingState, processingOptions, isEntityResultType);
        int[] readRows = new int[]{0};
        return CompletionStages.whileLoop(() -> rowProcessingState.next().thenCompose(arg_0 -> ReactiveListResultsConsumer.lambda$consume$1((Supplier)addToResultsSupplier, rowProcessingState, readRows, arg_0))).thenApply(v -> this.finishUp(results, jdbcValuesSourceProcessingState, rowReader, persistenceContext, queryOptions, readRows[0])).handle((list, ex) -> {
            this.end(jdbcValues, session, jdbcValuesSourceProcessingState, rowReader, persistenceContext, (Throwable)ex);
            return list;
        });
    }

    private Supplier<CompletionStage<Void>> addToResultsSupplier(Results<R> results, ReactiveRowReader<R> rowReader, ReactiveRowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions processingOptions, boolean isEntityResultType) {
        if (this.uniqueSemantic == UniqueSemantic.FILTER || this.uniqueSemantic == UniqueSemantic.ASSERT && rowProcessingState.hasCollectionInitializers() || this.uniqueSemantic == UniqueSemantic.ALLOW && isEntityResultType) {
            return () -> rowReader.reactiveReadRow(rowProcessingState, processingOptions).thenAccept(results::addUnique);
        }
        if (this.uniqueSemantic == UniqueSemantic.ASSERT) {
            return () -> rowReader.reactiveReadRow(rowProcessingState, processingOptions).thenApply(results::addUnique).thenAccept(ReactiveListResultsConsumer::validateUniqueResult);
        }
        return () -> rowReader.reactiveReadRow(rowProcessingState, processingOptions).thenAccept(results::add);
    }

    private void end(ReactiveValuesResultSet jdbcValues, SharedSessionContractImplementor session, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, ReactiveRowReader<R> rowReader, PersistenceContext persistenceContext, Throwable ex) {
        try {
            rowReader.finishUp((JdbcValuesSourceProcessingState)jdbcValuesSourceProcessingState);
            persistenceContext.afterLoad();
            persistenceContext.initializeNonLazyCollections();
        }
        catch (Throwable e) {
            if (ex != null) {
                ex.addSuppressed(e);
                throw (RuntimeException)ex;
            }
            throw e;
        }
        if (ex != null) {
            throw (RuntimeException)ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<R> finishUp(Results<R> results, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, ReactiveRowReader<R> rowReader, PersistenceContext persistenceContext, QueryOptions queryOptions, int readRows) {
        try {
            rowReader.finishUp((JdbcValuesSourceProcessingState)jdbcValuesSourceProcessingState);
            jdbcValuesSourceProcessingState.finishUp(readRows > 0);
        }
        finally {
            persistenceContext.getLoadContexts().deregister((JdbcValuesSourceProcessingState)jdbcValuesSourceProcessingState);
        }
        ResultListTransformer resultListTransformer = queryOptions.getResultListTransformer();
        return resultListTransformer != null ? resultListTransformer.transformList(results.getResults()) : results.getResults();
    }

    public static <R> ReactiveListResultsConsumer<R> instance(UniqueSemantic uniqueSemantic) {
        switch (uniqueSemantic) {
            case ASSERT: {
                return ERROR_DUP_CONSUMER;
            }
            case FILTER: {
                return DE_DUP_CONSUMER;
            }
            case NEVER: {
                return NEVER_DE_DUP_CONSUMER;
            }
            case ALLOW: {
                return ALLOW_DE_DUP_CONSUMER;
            }
        }
        return IGNORE_DUP_CONSUMER;
    }

    public ReactiveListResultsConsumer(UniqueSemantic uniqueSemantic) {
        this.uniqueSemantic = uniqueSemantic;
    }

    private JavaType<R> resolveDomainResultJavaType(Class<R> domainResultResultJavaType, List<JavaType<?>> resultJavaTypes, TypeConfiguration typeConfiguration) {
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        if (domainResultResultJavaType != null) {
            return javaTypeRegistry.resolveDescriptor(domainResultResultJavaType);
        }
        if (resultJavaTypes.size() == 1) {
            return resultJavaTypes.get(0);
        }
        return javaTypeRegistry.resolveDescriptor(Object[].class);
    }

    @Override
    public boolean canResultsBeCached() {
        return true;
    }

    public String toString() {
        return ReactiveResultsConsumer.class.getSimpleName() + "(" + this.uniqueSemantic + ")";
    }

    private static /* synthetic */ CompletionStage lambda$consume$1(Supplier addToResultsSupplier, ReactiveRowProcessingState rowProcessingState, int[] readRows, Boolean hasNext) {
        if (hasNext.booleanValue()) {
            return ((CompletionStage)addToResultsSupplier.get()).thenApply(unused -> {
                rowProcessingState.finishRowProcessing();
                readRows[0] = readRows[0] + 1;
                return true;
            });
        }
        return CompletionStages.falseFuture();
    }

    private static class EntityResult<R>
    extends Results<R> {
        private static final Object DUMP_VALUE = new Object();
        private final IdentityHashMap<R, Object> added = new IdentityHashMap();

        public EntityResult(JavaType resultJavaType) {
            super(resultJavaType);
        }

        @Override
        public boolean addUnique(R result) {
            if (this.added.put(result, DUMP_VALUE) == null) {
                super.add(result);
                return true;
            }
            return false;
        }
    }

    private static class Results<R> {
        private final List<R> results = new ArrayList<R>();
        private final JavaType resultJavaType;

        public Results(JavaType resultJavaType) {
            this.resultJavaType = resultJavaType;
        }

        public boolean addUnique(R result) {
            for (R r : this.results) {
                if (!this.resultJavaType.areEqual(r, result)) continue;
                return false;
            }
            this.results.add(result);
            return true;
        }

        public void add(R result) {
            this.results.add(result);
        }

        public List<R> getResults() {
            return this.results;
        }
    }

    public static enum UniqueSemantic {
        NONE,
        FILTER,
        ASSERT,
        NEVER,
        ALLOW;

    }

    private static class RegistrationHandler {
        private final LoadContexts contexts;
        private final JdbcValuesSourceProcessingStateStandardImpl state;

        private RegistrationHandler(LoadContexts contexts, JdbcValuesSourceProcessingStateStandardImpl state) {
            this.contexts = contexts;
            this.state = state;
        }

        public void register() {
            this.contexts.register((JdbcValuesSourceProcessingState)this.state);
        }

        public void deregister() {
            this.contexts.deregister((JdbcValuesSourceProcessingState)this.state);
        }
    }
}

