/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.reactive.sql.exec.spi.ReactiveRowProcessingState;
import org.hibernate.reactive.sql.results.graph.ReactiveDomainResultsAssembler;
import org.hibernate.reactive.sql.results.internal.ReactiveInitializersList;
import org.hibernate.reactive.sql.results.spi.ReactiveRowReader;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.results.LoadingLogger;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.type.descriptor.java.JavaType;

public class ReactiveStandardRowReader<R>
implements ReactiveRowReader<R> {
    private final List<DomainResultAssembler<?>> resultAssemblers;
    private final ReactiveInitializersList initializers;
    private final RowTransformer<R> rowTransformer;
    private final Class<R> domainResultJavaType;
    private final int assemblerCount;

    public ReactiveStandardRowReader(List<DomainResultAssembler<?>> resultAssemblers, ReactiveInitializersList initializers, RowTransformer<R> rowTransformer, Class<R> domainResultJavaType) {
        this.resultAssemblers = resultAssemblers;
        this.initializers = initializers;
        this.rowTransformer = rowTransformer;
        this.assemblerCount = resultAssemblers.size();
        this.domainResultJavaType = domainResultJavaType;
    }

    @Override
    public CompletionStage<R> reactiveReadRow(ReactiveRowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        LoadingLogger.LOGGER.trace((Object)"ReactiveStandardRowReader#readRow");
        return this.coordinateInitializers(rowProcessingState).thenCompose(v -> {
            Object[] resultRow = new Object[this.assemblerCount];
            return CompletionStages.loop(0, this.assemblerCount, i -> {
                DomainResultAssembler<?> assembler = this.resultAssemblers.get(i);
                LoadingLogger.LOGGER.debugf("Calling top-level assembler (%s / %s) : %s", i, this.assemblerCount, assembler);
                if (assembler instanceof ReactiveDomainResultsAssembler) {
                    return ((ReactiveDomainResultsAssembler)assembler).reactiveAssemble(rowProcessingState, options).thenAccept(obj -> {
                        resultRow[i] = obj;
                    });
                }
                resultRow[i] = assembler.assemble((RowProcessingState)rowProcessingState, options);
                return CompletionStages.voidFuture();
            }).thenApply(ignore -> {
                this.afterRow(rowProcessingState);
                return this.rowTransformer.transformRow(resultRow);
            });
        });
    }

    public Class<R> getDomainResultResultJavaType() {
        return this.domainResultJavaType;
    }

    public Class<?> getResultJavaType() {
        if (this.resultAssemblers.size() == 1) {
            return this.resultAssemblers.get(0).getAssembledJavaType().getJavaTypeClass();
        }
        return Object[].class;
    }

    public List<JavaType<?>> getResultJavaTypes() {
        ArrayList javaTypes = new ArrayList(this.resultAssemblers.size());
        for (DomainResultAssembler<?> resultAssembler : this.resultAssemblers) {
            javaTypes.add(resultAssembler.getAssembledJavaType());
        }
        return javaTypes;
    }

    public List<Initializer> getInitializers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReactiveInitializersList getReactiveInitializersList() {
        return this.initializers;
    }

    public R readRow(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        throw LOG.nonReactiveMethodCall("reactiveRowReader");
    }

    private void afterRow(RowProcessingState rowProcessingState) {
        LoadingLogger.LOGGER.trace((Object)"ReactiveStandardRowReader#afterRow");
        this.initializers.finishUpRow(rowProcessingState);
    }

    private CompletionStage<Void> coordinateInitializers(ReactiveRowProcessingState rowProcessingState) {
        this.initializers.resolveKeys(rowProcessingState);
        return this.initializers.resolveInstances(rowProcessingState).thenCompose(v -> this.initializers.initializeInstance(rowProcessingState));
    }

    public void finishUp(JdbcValuesSourceProcessingState processingState) {
        this.initializers.endLoading(processingState.getExecutionContext());
    }
}

