/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.internal;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.reactive.sql.results.internal.ReactiveInitializersList;
import org.hibernate.reactive.sql.results.internal.ReactiveStandardRowReader;
import org.hibernate.reactive.sql.results.spi.ReactiveRowReader;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.ResultsLogger;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerProducer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.spi.RowTransformer;

public class ReactiveResultsHelper {
    public static <R> ReactiveRowReader<R> createRowReader(ExecutionContext executionContext, LockOptions lockOptions, RowTransformer<R> rowTransformer, Class<R> transformedResultJavaType, JdbcValuesMapping jdbcValuesMapping) {
        SessionFactoryImplementor sessionFactory = executionContext.getSession().getFactory();
        LinkedHashMap<NavigablePath, Initializer> initializerMap = new LinkedHashMap<NavigablePath, Initializer>();
        ReactiveInitializersList.Builder initializersBuilder = new ReactiveInitializersList.Builder();
        List assemblers = jdbcValuesMapping.resolveAssemblers(ReactiveResultsHelper.creationState(executionContext, lockOptions, sessionFactory, initializerMap, initializersBuilder));
        ReactiveResultsHelper.logInitializers(initializerMap);
        ReactiveInitializersList initializersList = initializersBuilder.build(initializerMap);
        return new ReactiveStandardRowReader<R>(assemblers, initializersList, rowTransformer, transformedResultJavaType);
    }

    private static AssemblerCreationState creationState(final ExecutionContext executionContext, final LockOptions lockOptions, final SessionFactoryImplementor sessionFactory, final Map<NavigablePath, Initializer> initializerMap, final ReactiveInitializersList.Builder initializersBuilder) {
        return new AssemblerCreationState(){

            public boolean isScrollResult() {
                return executionContext.isScrollResult();
            }

            public LockMode determineEffectiveLockMode(String identificationVariable) {
                return lockOptions.getEffectiveLockMode(identificationVariable);
            }

            public Initializer resolveInitializer(NavigablePath navigablePath, ModelPart fetchedModelPart, Supplier<Initializer> producer) {
                return this.resolveInitializer(navigablePath, fetchedModelPart, null, null, (resultGraphNode, parentAccess, creationState) -> (Initializer)producer.get());
            }

            public <P extends FetchParent> Initializer resolveInitializer(P resultGraphNode, FetchParentAccess parentAccess, InitializerProducer<P> producer) {
                return this.resolveInitializer(resultGraphNode.getNavigablePath(), resultGraphNode.getReferencedModePart(), resultGraphNode, parentAccess, producer);
            }

            public <T extends FetchParent> Initializer resolveInitializer(NavigablePath navigablePath, ModelPart fetchedModelPart, T resultGraphNode, FetchParentAccess parentAccess, InitializerProducer<T> producer) {
                Initializer existing = (Initializer)initializerMap.get(navigablePath);
                if (existing != null && fetchedModelPart.getNavigableRole().equals((Object)existing.getInitializedPart().getNavigableRole())) {
                    ResultsLogger.RESULTS_MESSAGE_LOGGER.tracef("Returning previously-registered initializer : %s", (Object)existing);
                    return existing;
                }
                Initializer initializer = producer.createInitializer(resultGraphNode, parentAccess, (AssemblerCreationState)this);
                ResultsLogger.RESULTS_MESSAGE_LOGGER.tracef("Registering initializer : %s", (Object)initializer);
                initializerMap.put(navigablePath, initializer);
                initializersBuilder.addInitializer(initializer);
                return initializer;
            }

            public SqlAstCreationContext getSqlAstCreationContext() {
                return sessionFactory;
            }

            public ExecutionContext getExecutionContext() {
                return executionContext;
            }
        };
    }

    private static void logInitializers(Map<NavigablePath, Initializer> initializerMap) {
        if (!ResultsLogger.RESULTS_MESSAGE_LOGGER.isDebugEnabled()) {
            return;
        }
        ResultsLogger.RESULTS_MESSAGE_LOGGER.debug((Object)"Initializer list");
        initializerMap.forEach((navigablePath, initializer) -> ResultsLogger.RESULTS_MESSAGE_LOGGER.debugf("    %s -> %s@%s (%s)", new Object[]{navigablePath, initializer, initializer.hashCode(), initializer.getInitializedPart()}));
    }
}

