/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.internal;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.reactive.sql.exec.spi.ReactiveRowProcessingState;
import org.hibernate.reactive.sql.results.graph.ReactiveInitializer;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public final class ReactiveInitializersList {
    private final Initializer[] initializers;
    private final Initializer[] sortedNonCollectionsFirst;
    private final Initializer[] sortedForResolveInstance;
    private final boolean hasCollectionInitializers;
    private final Map<NavigablePath, Initializer> initializerMap;

    private ReactiveInitializersList(Initializer[] initializers, Initializer[] sortedNonCollectionsFirst, Initializer[] sortedForResolveInstance, boolean hasCollectionInitializers, Map<NavigablePath, Initializer> initializerMap) {
        this.initializers = initializers;
        this.sortedNonCollectionsFirst = sortedNonCollectionsFirst;
        this.sortedForResolveInstance = sortedForResolveInstance;
        this.hasCollectionInitializers = hasCollectionInitializers;
        this.initializerMap = initializerMap;
    }

    public Initializer resolveInitializer(NavigablePath path) {
        return this.initializerMap.get(path);
    }

    public void finishUpRow(RowProcessingState rowProcessingState) {
        for (Initializer init : this.initializers) {
            init.finishUpRow(rowProcessingState);
        }
    }

    public CompletionStage<Void> initializeInstance(ReactiveRowProcessingState rowProcessingState) {
        return CompletionStages.loop(this.initializers, initializer -> {
            if (initializer instanceof ReactiveInitializer) {
                return ((ReactiveInitializer)initializer).reactiveInitializeInstance(rowProcessingState);
            }
            initializer.initializeInstance((RowProcessingState)rowProcessingState);
            return CompletionStages.voidFuture();
        });
    }

    public void endLoading(ExecutionContext executionContext) {
        for (Initializer initializer : this.initializers) {
            initializer.endLoading(executionContext);
        }
    }

    public void resolveKeys(RowProcessingState rowProcessingState) {
        for (Initializer init : this.sortedNonCollectionsFirst) {
            init.resolveKey(rowProcessingState);
        }
    }

    public CompletionStage<Void> resolveInstances(ReactiveRowProcessingState rowProcessingState) {
        return CompletionStages.loop(this.sortedNonCollectionsFirst, initializer -> {
            if (initializer instanceof ReactiveInitializer) {
                return ((ReactiveInitializer)initializer).reactiveResolveInstance(rowProcessingState);
            }
            initializer.resolveInstance((RowProcessingState)rowProcessingState);
            return CompletionStages.voidFuture();
        });
    }

    public boolean hasCollectionInitializers() {
        return this.hasCollectionInitializers;
    }

    static class Builder {
        private final ArrayList<Initializer> initializers = new ArrayList();
        int nonCollectionInitializersNum = 0;
        int resolveFirstNum = 0;

        public void addInitializer(Initializer initializer) {
            this.initializers.add(initializer);
            if (!initializer.isCollectionInitializer()) {
                ++this.nonCollectionInitializersNum;
            }
            if (Builder.initializeFirst(initializer)) {
                ++this.resolveFirstNum;
            }
        }

        private static boolean initializeFirst(Initializer initializer) {
            return !(initializer instanceof EntityDelayedFetchInitializer) && !(initializer instanceof EntitySelectFetchInitializer);
        }

        ReactiveInitializersList build(Map<NavigablePath, Initializer> initializerMap) {
            Initializer[] originalSortInitializers;
            int size = this.initializers.size();
            Initializer[] sortedNonCollectionsFirst = new Initializer[size];
            Initializer[] sortedForResolveInstance = new Initializer[size];
            int nonCollectionIdx = 0;
            int collectionIdx = this.nonCollectionInitializersNum;
            int resolveFirstIdx = 0;
            int resolveLaterIdx = this.resolveFirstNum;
            for (Initializer initializer : originalSortInitializers = this.toArray(this.initializers)) {
                if (initializer.isCollectionInitializer()) {
                    sortedNonCollectionsFirst[collectionIdx++] = initializer;
                } else {
                    sortedNonCollectionsFirst[nonCollectionIdx++] = initializer;
                }
                if (Builder.initializeFirst(initializer)) {
                    sortedForResolveInstance[resolveFirstIdx++] = initializer;
                    continue;
                }
                sortedForResolveInstance[resolveLaterIdx++] = initializer;
            }
            boolean hasCollectionInitializers = this.nonCollectionInitializersNum != this.initializers.size();
            return new ReactiveInitializersList(originalSortInitializers, sortedNonCollectionsFirst, sortedForResolveInstance, hasCollectionInitializers, initializerMap);
        }

        private Initializer[] toArray(ArrayList<Initializer> initializers) {
            return initializers.toArray(new Initializer[0]);
        }
    }
}

