/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.internal;

import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectDelegateWrapper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.pool.impl.Parameters;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.sql.results.internal.ReactiveResultSetAccess;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.jdbc.internal.DeferredResultSetAccess;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class ReactiveDeferredResultSetAccess
extends DeferredResultSetAccess
implements ReactiveResultSetAccess {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final SqlStatementLogger sqlStatementLogger;
    private final ExecutionContext executionContext;
    private CompletionStage<ResultSet> resultSetStage;
    private Integer columnCount;
    private ResultSet resultSet;

    public ReactiveDeferredResultSetAccess(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, Function<String, PreparedStatement> statementCreator) {
        super(jdbcSelect, jdbcParameterBindings, executionContext, statementCreator);
        this.executionContext = executionContext;
        this.sqlStatementLogger = executionContext.getSession().getJdbcServices().getSqlStatementLogger();
    }

    @Override
    public ResultSet getResultSet() {
        if (this.resultSet == null) {
            throw LOG.nonReactiveMethodCall("getReactiveResultSet");
        }
        return this.resultSet;
    }

    @Override
    public CompletionStage<ResultSet> getReactiveResultSet() {
        if (this.resultSetStage == null) {
            this.resultSetStage = this.executeQuery().thenApply(this::saveResultSet);
        }
        return this.resultSetStage;
    }

    @Override
    public int getColumnCount() {
        if (this.columnCount == null) {
            throw LOG.nonReactiveMethodCall("getReactiveColumnCount");
        }
        return this.columnCount;
    }

    @Override
    public CompletionStage<Integer> getReactiveColumnCount() {
        return this.getReactiveResultSet().thenApply(ReactiveDeferredResultSetAccess::columnCount).thenApply(this::saveColumnCount);
    }

    private Integer saveColumnCount(Integer columnCount) {
        this.columnCount = columnCount;
        return this.columnCount;
    }

    public <J> BasicType<J> resolveType(int position, JavaType<J> explicitJavaType, SessionFactoryImplementor sessionFactory) {
        return super.resolveType(position, explicitJavaType, sessionFactory);
    }

    @Override
    public <J> BasicType<J> resolveType(int position, JavaType<J> explicitJavaType, TypeConfiguration typeConfiguration) {
        return super.resolveType(position, explicitJavaType, typeConfiguration);
    }

    @Override
    public CompletionStage<JdbcValuesMetadata> resolveJdbcValueMetadata() {
        return this.getReactiveResultSet().thenApply(this::convertToMetadata);
    }

    private JdbcValuesMetadata convertToMetadata(ResultSet resultSet) {
        return (JdbcValuesMetadata)resultSet;
    }

    @Override
    public CompletionStage<ResultSetMetaData> getReactiveMetadata() {
        return this.getReactiveResultSet().thenApply(this::reactiveMetadata);
    }

    private ResultSetMetaData reactiveMetadata(ResultSet resultSet) {
        try {
            return resultSet.getMetaData();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static int columnCount(ResultSet resultSet) {
        try {
            return resultSet.getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private JdbcSessionContext context() {
        return this.executionContext.getSession().getJdbcCoordinator().getJdbcSessionOwner().getJdbcSessionContext();
    }

    private CompletionStage<ResultSet> executeQuery() {
        LogicalConnectionImplementor logicalConnection = this.getPersistenceContext().getJdbcCoordinator().getLogicalConnection();
        return CompletionStages.completedFuture(logicalConnection).thenCompose(lg -> {
            LOG.tracef("Executing query to retrieve ResultSet : %s", this.getFinalSql());
            Dialect dialect = DialectDelegateWrapper.extractRealDialect((Dialect)this.executionContext.getSession().getJdbcServices().getDialect());
            String sql = Parameters.instance(dialect).process(this.getFinalSql());
            Object[] parameters = PreparedStatementAdaptor.bind(x$0 -> super.bindParameters(x$0));
            SessionEventListenerManager eventListenerManager = this.executionContext.getSession().getEventListenerManager();
            long executeStartNanos = this.executionStartNanos();
            eventListenerManager.jdbcExecuteStatementStart();
            return this.connection().selectJdbc(sql, parameters).thenCompose(this::validateResultSet).whenComplete((resultSet, throwable) -> {
                eventListenerManager.jdbcExecuteStatementEnd();
                this.sqlStatementLogger.logSlowQuery(this.getFinalSql(), executeStartNanos, this.context());
            }).thenCompose(this::reactiveSkipRows).handle(CompletionStages::handle).thenCompose(handler -> handler.hasFailed() ? this.convertException((Object)this.resultSet, (Throwable)handler.getThrowable()) : handler.getResultAsCompletionStage());
        }).whenComplete((o, throwable) -> logicalConnection.afterStatement());
    }

    private CompletionStage<ResultSet> validateResultSet(ResultSet resultSet) {
        try {
            return resultSet.getMetaData().getColumnCount() == 0 ? CompletionStages.failedFuture(LOG.noResultException(this.getFinalSql())) : CompletionStages.completedFuture(resultSet);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private ResultSet saveResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
        return this.saveColumnCount(resultSet);
    }

    private ResultSet saveColumnCount(ResultSet resultSet) {
        this.columnCount = ReactiveDeferredResultSetAccess.columnCount(resultSet);
        this.saveColumnCount(this.columnCount);
        return resultSet;
    }

    private ReactiveConnection connection() {
        return ((ReactiveConnectionSupplier)this.executionContext.getSession()).getReactiveConnection();
    }

    private <T> CompletionStage<T> convertException(T object, Throwable throwable) {
        if (throwable != null) {
            Throwable cause = throwable;
            if (throwable instanceof CompletionException) {
                cause = throwable.getCause();
            }
            if (cause instanceof SQLException) {
                return CompletionStages.failedFuture((Throwable)this.executionContext.getSession().getJdbcServices().getSqlExceptionHelper().convert((SQLException)cause, "Exception executing SQL [" + this.getFinalSql() + "]"));
            }
            if (cause instanceof HibernateException) {
                return CompletionStages.failedFuture(cause);
            }
            return CompletionStages.failedFuture(new HibernateException(cause));
        }
        return CompletionStages.completedFuture(object);
    }

    private CompletionStage<ResultSet> reactiveSkipRows(ResultSet resultSet) {
        try {
            this.skipRows(resultSet);
            return CompletionStages.completedFuture(resultSet);
        }
        catch (SQLException sqlException) {
            return CompletionStages.failedFuture(sqlException);
        }
    }

    private long executionStartNanos() {
        return this.sqlStatementLogger.getLogSlowQuery() > 0L ? System.nanoTime() : 0L;
    }
}

