/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.graph.entity.internal;

import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.metamodel.internal.StandardEmbeddableInstantiator;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.sql.results.graph.entity.internal.ReactiveEntitySelectFetchByUniqueKeyInitializer;
import org.hibernate.reactive.sql.results.graph.entity.internal.ReactiveEntitySelectFetchInitializer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchEntityInsideEmbeddableSelectFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchEntitySelectFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchInitializeEntitySelectFetchInitializer;

public class ReactiveEntitySelectFetchInitializerBuilder {
    public static EntityInitializer createInitializer(FetchParentAccess parentAccess, ToOneAttributeMapping fetchedAttribute, EntityPersister entityPersister, DomainResult<?> keyResult, NavigablePath navigablePath, boolean selectByUniqueKey, AssemblerCreationState creationState) {
        if (selectByUniqueKey) {
            return new ReactiveEntitySelectFetchByUniqueKeyInitializer(parentAccess, fetchedAttribute, navigablePath, entityPersister, keyResult.createResultAssembler(parentAccess, creationState));
        }
        BatchMode batchMode = ReactiveEntitySelectFetchInitializerBuilder.determineBatchMode(entityPersister, parentAccess, creationState);
        switch (batchMode) {
            case NONE: {
                return new ReactiveEntitySelectFetchInitializer(parentAccess, fetchedAttribute, navigablePath, entityPersister, keyResult.createResultAssembler(parentAccess, creationState));
            }
            case BATCH_LOAD: {
                if (parentAccess.isEmbeddableInitializer()) {
                    return new BatchEntityInsideEmbeddableSelectFetchInitializer(parentAccess, fetchedAttribute, navigablePath, entityPersister, keyResult.createResultAssembler(parentAccess, creationState));
                }
                return new BatchEntitySelectFetchInitializer(parentAccess, fetchedAttribute, navigablePath, entityPersister, keyResult.createResultAssembler(parentAccess, creationState));
            }
            case BATCH_INITIALIZE: {
                return new BatchInitializeEntitySelectFetchInitializer(parentAccess, fetchedAttribute, navigablePath, entityPersister, keyResult.createResultAssembler(parentAccess, creationState));
            }
        }
        throw new IllegalStateException("Should be unreachable");
    }

    private static BatchMode determineBatchMode(EntityPersister entityPersister, FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        if (!entityPersister.isBatchLoadable() || creationState.isScrollResult()) {
            return BatchMode.NONE;
        }
        while (parentAccess.isEmbeddableInitializer()) {
            EmbeddableInitializer embeddableInitializer = parentAccess.asEmbeddableInitializer();
            EmbeddableValuedModelPart initializedPart = embeddableInitializer.getInitializedPart();
            if (initializedPart.isEntityIdentifierMapping() || initializedPart.isVirtual() || !(initializedPart.getMappedType().getRepresentationStrategy().getInstantiator() instanceof StandardEmbeddableInstantiator)) {
                return entityPersister.hasSubclasses() ? BatchMode.NONE : BatchMode.BATCH_INITIALIZE;
            }
            if ((parentAccess = parentAccess.getFetchParentAccess()) != null) continue;
            break;
        }
        if (parentAccess != null) {
            assert (parentAccess.getInitializedPart() instanceof EntityValuedModelPart);
            EntityPersister parentPersister = parentAccess.asEntityInitializer().getEntityDescriptor();
            EntityDataAccess cacheAccess = parentPersister.getCacheAccessStrategy();
            if (cacheAccess != null) {
                return BatchMode.BATCH_INITIALIZE;
            }
        }
        return BatchMode.BATCH_LOAD;
    }

    static enum BatchMode {
        NONE,
        BATCH_LOAD,
        BATCH_INITIALIZE;

    }
}

