/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.graph.entity.internal;

import java.util.concurrent.CompletionStage;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.sql.exec.spi.ReactiveRowProcessingState;
import org.hibernate.reactive.sql.results.graph.entity.internal.ReactiveEntitySelectFetchInitializer;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class ReactiveEntitySelectFetchByUniqueKeyInitializer
extends ReactiveEntitySelectFetchInitializer {
    private final ToOneAttributeMapping fetchedAttribute;

    public ReactiveEntitySelectFetchByUniqueKeyInitializer(FetchParentAccess parentAccess, ToOneAttributeMapping fetchedAttribute, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResultAssembler<?> keyAssembler) {
        super(parentAccess, fetchedAttribute, fetchedNavigable, concreteDescriptor, keyAssembler);
        this.fetchedAttribute = fetchedAttribute;
    }

    @Override
    public CompletionStage<Void> reactiveResolveInstance(ReactiveRowProcessingState rowProcessingState) {
        if (this.state != EntitySelectFetchInitializer.State.UNINITIALIZED) {
            return CompletionStages.voidFuture();
        }
        this.state = EntitySelectFetchInitializer.State.RESOLVED;
        if (this.parentShallowCached || this.shouldSkipInitializer(rowProcessingState)) {
            this.state = EntitySelectFetchInitializer.State.INITIALIZED;
            return CompletionStages.voidFuture();
        }
        this.entityIdentifier = this.keyAssembler.assemble((RowProcessingState)rowProcessingState);
        if (this.entityIdentifier == null) {
            this.state = EntitySelectFetchInitializer.State.INITIALIZED;
            return CompletionStages.voidFuture();
        }
        NavigablePath[] np = new NavigablePath[]{this.getNavigablePath().getParent()};
        if (np[0] == null) {
            return CompletionStages.voidFuture();
        }
        return CompletionStages.whileLoop(() -> {
            CompletionStage<Void> loop = CompletionStages.voidFuture();
            if (np[0] instanceof EntityIdentifierNavigablePath || "{fk}".equals(np[0].getLocalName()) || "{fk-target}".equals(np[0].getLocalName())) {
                loop = this.reactiveInitializeInstance(rowProcessingState);
            }
            return loop.thenApply(v -> {
                np[0] = np[0].getParent();
                return np[0] != null;
            });
        });
    }

    @Override
    public CompletionStage<Void> reactiveInitializeInstance(ReactiveRowProcessingState rowProcessingState) {
        if (this.state != EntitySelectFetchInitializer.State.RESOLVED) {
            return CompletionStages.voidFuture();
        }
        this.state = EntitySelectFetchInitializer.State.INITIALIZED;
        String entityName = this.concreteDescriptor.getEntityName();
        String uniqueKeyPropertyName = this.fetchedAttribute.getReferencedPropertyName();
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        EntityUniqueKey euk = new EntityUniqueKey(entityName, uniqueKeyPropertyName, this.entityIdentifier, this.concreteDescriptor.getPropertyType(uniqueKeyPropertyName), session.getFactory());
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        this.setEntityInstance(persistenceContext.getEntity(euk));
        if (this.entityInstance == null) {
            return ((ReactiveEntityPersister)this.concreteDescriptor).reactiveLoadByUniqueKey(uniqueKeyPropertyName, this.entityIdentifier, session).thenAccept(this::setEntityInstance).thenAccept(v -> {
                if (this.entityInstance != null) {
                    persistenceContext.addEntity(euk, this.entityInstance);
                }
            });
        }
        if (this.entityInstance != null) {
            this.setEntityInstance(persistenceContext.proxyFor(this.entityInstance));
        }
        return CompletionStages.voidFuture();
    }

    private void setEntityInstance(Object instance) {
        this.entityInstance = instance;
    }
}

