/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.graph.entity.internal;

import org.hibernate.FetchNotFoundException;
import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.reactive.sql.results.graph.entity.ReactiveAbstractEntityInitializer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.AbstractEntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityLoadingLogging;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class ReactiveEntityJoinedFetchInitializer
extends ReactiveAbstractEntityInitializer {
    private static final String CONCRETE_NAME = ReactiveEntityJoinedFetchInitializer.class.getSimpleName();
    private final DomainResultAssembler<?> keyAssembler;
    private final NotFoundAction notFoundAction;

    public ReactiveEntityJoinedFetchInitializer(EntityResultGraphNode resultDescriptor, EntityValuedFetchable referencedFetchable, NavigablePath navigablePath, LockMode lockMode, NotFoundAction notFoundAction, DomainResult<?> keyResult, DomainResult<Object> rowIdResult, Fetch identifierFetch, Fetch discriminatorFetch, FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        super(resultDescriptor, navigablePath, lockMode, identifierFetch, discriminatorFetch, rowIdResult, parentAccess, creationState);
        assert (this.getInitializedPart() == referencedFetchable);
        this.notFoundAction = notFoundAction;
        this.keyAssembler = keyResult == null ? null : keyResult.createResultAssembler((FetchParentAccess)this, creationState);
    }

    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.isParentShallowCached()) {
            this.state = AbstractEntityInitializer.State.MISSING;
        } else if (this.state == AbstractEntityInitializer.State.UNINITIALIZED) {
            Object fkKeyValue;
            if (this.shouldSkipInitializer(rowProcessingState)) {
                this.state = AbstractEntityInitializer.State.MISSING;
                return;
            }
            super.resolveKey(rowProcessingState);
            if (this.keyAssembler != null && (fkKeyValue = this.keyAssembler.assemble(rowProcessingState)) != null && this.state == AbstractEntityInitializer.State.MISSING) {
                if (this.notFoundAction != NotFoundAction.IGNORE) {
                    throw new FetchNotFoundException(this.getEntityDescriptor().getEntityName(), fkKeyValue);
                }
                EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("Ignoring dangling foreign-key due to `@NotFound(IGNORE); association will be null - %s", (Object)this.getNavigablePath());
            }
        }
    }

    public void initializeInstanceFromParent(Object parentInstance, RowProcessingState rowProcessingState) {
        AttributeMapping attributeMapping = this.getInitializedPart().asAttributeMapping();
        Object instance = attributeMapping != null ? attributeMapping.getValue(parentInstance) : parentInstance;
        this.setEntityInstance(instance);
        this.setEntityInstanceForNotify(Hibernate.unproxy((Object)instance));
        this.state = AbstractEntityInitializer.State.INITIALIZED;
        this.initializeSubInstancesFromParent(rowProcessingState);
    }

    protected String getSimpleConcreteImplName() {
        return CONCRETE_NAME;
    }

    public boolean isResultInitializer() {
        return false;
    }

    public String toString() {
        return "ReactiveEntityJoinedFetchInitializer(" + LoggingHelper.toLoggableString((NavigablePath)this.getNavigablePath()) + ")";
    }
}

