/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.graph.entity.internal;

import java.util.concurrent.CompletionStage;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.session.impl.ReactiveQueryExecutorLookup;
import org.hibernate.reactive.sql.exec.spi.ReactiveRowProcessingState;
import org.hibernate.reactive.sql.results.graph.ReactiveInitializer;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedFetchInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.Type;

public class ReactiveEntityDelayedFetchInitializer
extends EntityDelayedFetchInitializer
implements ReactiveInitializer {
    private final ToOneAttributeMapping referencedModelPart;

    public ReactiveEntityDelayedFetchInitializer(FetchParentAccess parentAccess, NavigablePath fetchedNavigable, ToOneAttributeMapping referencedModelPart, boolean selectByUniqueKey, DomainResultAssembler<?> identifierAssembler) {
        super(parentAccess, fetchedNavigable, referencedModelPart, selectByUniqueKey, identifierAssembler);
        this.referencedModelPart = referencedModelPart;
    }

    @Override
    public CompletionStage<Void> reactiveResolveInstance(ReactiveRowProcessingState rowProcessingState) {
        if (this.isProcessed()) {
            return CompletionStages.voidFuture();
        }
        this.setProcessed(true);
        if (this.parentShallowCached || this.shouldSkipInitializer(rowProcessingState)) {
            return CompletionStages.voidFuture();
        }
        this.setIdentifier(this.getIdentifierAssembler().assemble((RowProcessingState)rowProcessingState));
        CompletionStage<Void> stage = CompletionStages.voidFuture();
        if (this.getIdentifier() == null) {
            this.setEntityInstance(null);
        } else {
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            EntityPersister concreteDescriptor = this.referencedModelPart.getEntityMappingType().getEntityPersister();
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            if (this.isSelectByUniqueKey()) {
                String uniqueKeyPropertyName = this.referencedModelPart.getReferencedPropertyName();
                Type uniqueKeyPropertyType = uniqueKeyPropertyName == null ? concreteDescriptor.getIdentifierType() : session.getFactory().getReferencedPropertyType(concreteDescriptor.getEntityName(), uniqueKeyPropertyName);
                EntityUniqueKey euk = new EntityUniqueKey(concreteDescriptor.getEntityName(), uniqueKeyPropertyName, this.getIdentifier(), uniqueKeyPropertyType, session.getFactory());
                this.setEntityInstance(persistenceContext.getEntity(euk));
                if (this.getEntityInstance() == null) {
                    if (this.referencedModelPart.isLazy()) {
                        this.setEntityInstance(LazyPropertyInitializer.UNFETCHED_PROPERTY);
                    } else {
                        stage = stage.thenCompose(v -> ((ReactiveEntityPersister)concreteDescriptor).reactiveLoadByUniqueKey(uniqueKeyPropertyName, this.getIdentifier(), session)).thenAccept(arg_0 -> ((ReactiveEntityDelayedFetchInitializer)this).setEntityInstance(arg_0)).thenAccept(v -> {
                            if (this.getEntityInstance() != null) {
                                persistenceContext.addEntity(euk, this.getEntityInstance());
                            }
                        });
                    }
                }
                stage = stage.thenAccept(v -> {
                    if (this.getEntityInstance() != null) {
                        this.setEntityInstance(persistenceContext.proxyFor(this.getEntityInstance()));
                    }
                });
            } else {
                EntityKey entityKey = new EntityKey(this.getIdentifier(), concreteDescriptor);
                EntityHolder holder = persistenceContext.getEntityHolder(entityKey);
                if (holder != null && holder.getEntity() != null) {
                    this.setEntityInstance(persistenceContext.proxyFor(holder, concreteDescriptor));
                } else if (this.referencedModelPart.isOptional() && this.referencedModelPart.isLazy()) {
                    this.setEntityInstance(LazyPropertyInitializer.UNFETCHED_PROPERTY);
                } else {
                    stage = stage.thenCompose(v -> ReactiveQueryExecutorLookup.extract(session).reactiveInternalLoad(concreteDescriptor.getEntityName(), this.getIdentifier(), false, false).thenAccept(arg_0 -> ((ReactiveEntityDelayedFetchInitializer)this).setEntityInstance(arg_0)));
                }
                stage = stage.thenAccept(v -> {
                    LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer((Object)this.getEntityInstance());
                    if (lazyInitializer != null) {
                        lazyInitializer.setUnwrap(this.referencedModelPart.isUnwrapProxy() && concreteDescriptor.isInstrumented());
                    }
                });
            }
        }
        return stage;
    }

    @Override
    public CompletionStage<Void> reactiveInitializeInstance(ReactiveRowProcessingState rowProcessingState) {
        return CompletionStages.voidFuture();
    }
}

