/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.model;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.internal.MutationQueryOptions;
import org.hibernate.engine.jdbc.mutation.internal.PreparedStatementGroupSingleTable;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.persister.entity.mutation.UpdateValuesAnalysis;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.reactive.adaptor.impl.PrepareStatementDetailsAdaptor;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.sql.model.ReactiveSelfExecutingUpdateOperation;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.sql.model.ast.TableMutation;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.sql.model.internal.TableDeleteStandard;
import org.hibernate.sql.model.jdbc.DeleteOrUpsertOperation;
import org.hibernate.sql.model.jdbc.JdbcDeleteMutation;
import org.hibernate.sql.model.jdbc.UpsertOperation;

public class ReactiveDeleteOrUpsertOperation
extends DeleteOrUpsertOperation
implements ReactiveSelfExecutingUpdateOperation {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final OptionalTableUpdate upsert;
    private final UpsertOperation upsertOperation;

    public ReactiveDeleteOrUpsertOperation(EntityMutationTarget mutationTarget, EntityTableMapping tableMapping, UpsertOperation upsertOperation, OptionalTableUpdate optionalTableUpdate) {
        super(mutationTarget, tableMapping, upsertOperation, optionalTableUpdate);
        this.upsert = optionalTableUpdate;
        this.upsertOperation = upsertOperation;
    }

    public void performMutation(JdbcValueBindings jdbcValueBindings, ValuesAnalysis valuesAnalysis, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("performReactiveMutation");
    }

    @Override
    public CompletionStage<Void> performReactiveMutation(JdbcValueBindings jdbcValueBindings, ValuesAnalysis incomingValuesAnalysis, SharedSessionContractImplementor session) {
        UpdateValuesAnalysis valuesAnalysis = (UpdateValuesAnalysis)incomingValuesAnalysis;
        if (!valuesAnalysis.getTablesNeedingUpdate().contains(this.getTableDetails())) {
            return CompletionStages.voidFuture();
        }
        return this.doReactiveMutation(this.getTableDetails(), jdbcValueBindings, valuesAnalysis, session);
    }

    private CompletionStage<Void> doReactiveMutation(TableMapping tableMapping, JdbcValueBindings jdbcValueBindings, UpdateValuesAnalysis valuesAnalysis, SharedSessionContractImplementor session) {
        return CompletionStages.voidFuture().thenCompose(v -> !valuesAnalysis.getTablesWithNonNullValues().contains(tableMapping) ? this.performReactiveDelete(jdbcValueBindings, session) : this.performReactiveUpsert(jdbcValueBindings, session)).whenComplete((o, throwable) -> jdbcValueBindings.afterStatement(tableMapping));
    }

    private CompletionStage<Void> performReactiveUpsert(JdbcValueBindings jdbcValueBindings, SharedSessionContractImplementor session) {
        String tableName = this.getTableDetails().getTableName();
        ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("#performReactiveUpsert(%s)", (Object)tableName);
        PreparedStatementGroupSingleTable statementGroup = new PreparedStatementGroupSingleTable((PreparableMutationOperation)this.upsertOperation, session);
        PreparedStatementDetails statementDetails = statementGroup.resolvePreparedStatementDetails(tableName);
        session.getJdbcServices().getSqlStatementLogger().logStatement(statementDetails.getSqlString());
        Object[] params = PreparedStatementAdaptor.bind(statement -> {
            PrepareStatementDetailsAdaptor details = new PrepareStatementDetailsAdaptor(statementDetails, statement, session.getJdbcServices());
            jdbcValueBindings.beforeStatement((PreparedStatementDetails)details);
        });
        ReactiveConnection reactiveConnection = ((ReactiveConnectionSupplier)session).getReactiveConnection();
        return reactiveConnection.update(statementDetails.getSqlString(), params).thenAccept(rowCount -> ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("`%s` rows upserted into `%s`", rowCount, (Object)this.getTableDetails().getTableName()));
    }

    private CompletionStage<Void> performReactiveDelete(JdbcValueBindings jdbcValueBindings, SharedSessionContractImplementor session) {
        String tableName = this.getTableDetails().getTableName();
        ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("#performReactiveDelete(%s)", (Object)tableName);
        TableDeleteStandard upsertDeleteAst = new TableDeleteStandard(this.upsert.getMutatingTable(), this.getMutationTarget(), "upsert delete", this.upsert.getKeyBindings(), Collections.emptyList(), Collections.emptyList());
        SqlAstTranslator translator = session.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildModelMutationTranslator((TableMutation)upsertDeleteAst, session.getFactory());
        JdbcDeleteMutation upsertDelete = (JdbcDeleteMutation)translator.translate(null, (QueryOptions)MutationQueryOptions.INSTANCE);
        PreparedStatementGroupSingleTable statementGroup = new PreparedStatementGroupSingleTable((PreparableMutationOperation)upsertDelete, session);
        PreparedStatementDetails statementDetails = statementGroup.resolvePreparedStatementDetails(tableName);
        session.getJdbcServices().getSqlStatementLogger().logStatement(statementDetails.getSqlString());
        Object[] params = PreparedStatementAdaptor.bind(statement -> {
            PrepareStatementDetailsAdaptor details = new PrepareStatementDetailsAdaptor(statementDetails, statement, session.getJdbcServices());
            jdbcValueBindings.beforeStatement((PreparedStatementDetails)details);
        });
        ReactiveConnection reactiveConnection = ((ReactiveConnectionSupplier)session).getReactiveConnection();
        String sqlString = statementDetails.getSqlString();
        return reactiveConnection.update(sqlString, params).thenAccept(rowCount -> ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("`%s` rows upsert-deleted from `%s`", rowCount, (Object)tableName));
    }
}

