/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.exec.spi;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.exception.DataException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.reactive.sql.results.internal.ReactiveResultSetAccess;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.exec.ExecutionException;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.caching.QueryCachePutManager;
import org.hibernate.sql.results.caching.internal.QueryCachePutManagerEnabledImpl;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.WrapperOptions;

public class ReactiveValuesResultSet {
    private final QueryCachePutManager queryCachePutManager;
    private final ReactiveResultSetAccess resultSetAccess;
    private final JdbcValuesMapping valuesMapping;
    private final ExecutionContext executionContext;
    private final SqlSelection[] sqlSelections;
    private final BitSet initializedIndexes;
    private final Object[] currentRowJdbcValues;
    private final int[] valueIndexesToCacheIndexes;
    private final int rowToCacheSize;

    public ReactiveValuesResultSet(ReactiveResultSetAccess resultSetAccess, QueryKey queryCacheKey, String queryIdentifier, QueryOptions queryOptions, JdbcValuesMapping valuesMapping, JdbcValuesMetadata metadataForCache, ExecutionContext executionContext) {
        this.queryCachePutManager = ReactiveValuesResultSet.resolveQueryCachePutManager(executionContext, queryOptions, queryCacheKey, queryIdentifier, metadataForCache);
        this.resultSetAccess = resultSetAccess;
        this.valuesMapping = valuesMapping;
        this.executionContext = executionContext;
        int rowSize = valuesMapping.getRowSize();
        this.sqlSelections = new SqlSelection[rowSize];
        for (Object selection : valuesMapping.getSqlSelections()) {
            int valuesArrayPosition = selection.getValuesArrayPosition();
            this.sqlSelections[valuesArrayPosition] = selection;
        }
        this.initializedIndexes = new BitSet(rowSize);
        this.currentRowJdbcValues = new Object[rowSize];
        if (this.queryCachePutManager == null) {
            this.valueIndexesToCacheIndexes = null;
            this.rowToCacheSize = -1;
        } else {
            BitSet valueIndexesToCache = new BitSet(rowSize);
            for (DomainResult domainResult : valuesMapping.getDomainResults()) {
                domainResult.collectValueIndexesToCache(valueIndexesToCache);
            }
            if (valueIndexesToCache.nextClearBit(0) == -1) {
                this.valueIndexesToCacheIndexes = null;
                this.rowToCacheSize = -1;
            } else {
                int i;
                int[] valueIndexesToCacheIndexes = new int[rowSize];
                int cacheIndex = 0;
                for (i = 0; i < valueIndexesToCacheIndexes.length; ++i) {
                    valueIndexesToCacheIndexes[i] = valueIndexesToCache.get(i) ? cacheIndex++ : -1;
                }
                this.valueIndexesToCacheIndexes = valueIndexesToCacheIndexes;
                if (cacheIndex == 1) {
                    for (i = 0; i < valueIndexesToCacheIndexes.length; ++i) {
                        if (valueIndexesToCacheIndexes[i] == -1) continue;
                        cacheIndex = -i;
                        break;
                    }
                }
                this.rowToCacheSize = cacheIndex;
            }
        }
    }

    private static QueryCachePutManager resolveQueryCachePutManager(ExecutionContext executionContext, QueryOptions queryOptions, QueryKey queryCacheKey, String queryIdentifier, JdbcValuesMetadata metadataForCache) {
        if (queryCacheKey != null) {
            SessionFactoryImplementor factory = executionContext.getSession().getFactory();
            QueryResultsCache queryCache = factory.getCache().getQueryResultsCache(queryOptions.getResultCacheRegionName());
            return new QueryCachePutManagerEnabledImpl(queryCache, factory.getStatistics(), queryCacheKey, queryIdentifier, metadataForCache);
        }
        return null;
    }

    public final CompletionStage<Boolean> next() {
        return this.processNext();
    }

    protected final CompletionStage<Boolean> processNext() {
        return this.advance(() -> this.resultSetAccess.getReactiveResultSet().thenCompose(this::doNext));
    }

    private CompletionStage<Boolean> doNext(ResultSet resultSet) {
        try {
            boolean next = resultSet.next();
            return CompletionStages.completedFuture(next);
        }
        catch (SQLException e) {
            return CompletionStages.failedFuture((Throwable)this.makeExecutionException("Error advancing (next) ResultSet position", e));
        }
    }

    private ExecutionException makeExecutionException(String message, SQLException cause) {
        JDBCException jdbcException = this.executionContext.getSession().getJdbcServices().getSqlExceptionHelper().convert(cause, message);
        if (jdbcException instanceof QueryTimeoutException || jdbcException instanceof DataException || jdbcException instanceof LockTimeoutException) {
            throw jdbcException;
        }
        return new ExecutionException(message + " [" + cause.getMessage() + "]", (Throwable)jdbcException);
    }

    public JdbcValuesMapping getValuesMapping() {
        return this.valuesMapping;
    }

    public Object[] getCurrentRowValuesArray() {
        return this.currentRowJdbcValues;
    }

    public void finishUp(SharedSessionContractImplementor session) {
        if (this.queryCachePutManager != null) {
            this.queryCachePutManager.finishUp(session);
        }
        this.resultSetAccess.release();
    }

    public void finishRowProcessing(RowProcessingState rowProcessingState, boolean wasAdded) {
        if (this.queryCachePutManager != null) {
            Object objectToCache;
            if (this.valueIndexesToCacheIndexes == null) {
                objectToCache = Arrays.copyOf(this.currentRowJdbcValues, this.currentRowJdbcValues.length);
            } else if (this.rowToCacheSize < 1) {
                if (!wasAdded) {
                    return;
                }
                objectToCache = this.currentRowJdbcValues[-this.rowToCacheSize];
            } else {
                Object[] rowToCache = new Object[this.rowToCacheSize];
                for (int i = 0; i < this.currentRowJdbcValues.length; ++i) {
                    int cacheIndex = this.valueIndexesToCacheIndexes[i];
                    if (cacheIndex == -1) continue;
                    rowToCache[cacheIndex] = this.initializedIndexes.get(i) ? this.currentRowJdbcValues[i] : null;
                }
                objectToCache = rowToCache;
            }
            this.queryCachePutManager.registerJdbcRow(objectToCache);
        }
    }

    private CompletionStage<Boolean> advance(Advancer advancer) {
        return advancer.advance().thenCompose(this::readCurrentRowValues);
    }

    private CompletionStage<Boolean> readCurrentRowValues(boolean hasResults) {
        if (!hasResults) {
            return CompletionStages.falseFuture();
        }
        return this.resultSetAccess.getReactiveResultSet().thenApply(resultSet -> {
            SharedSessionContractImplementor session = this.executionContext.getSession();
            for (SqlSelection sqlSelection : this.sqlSelections) {
                try {
                    this.currentRowJdbcValues[sqlSelection.getValuesArrayPosition()] = sqlSelection.getJdbcValueExtractor().extract(resultSet, sqlSelection.getJdbcResultSetIndex(), (WrapperOptions)session);
                }
                catch (Exception e) {
                    throw new HibernateException("Unable to extract JDBC value for position `" + sqlSelection.getJdbcResultSetIndex() + "`", (Throwable)e);
                }
            }
            return true;
        });
    }

    @FunctionalInterface
    private static interface Advancer {
        public CompletionStage<Boolean> advance();
    }
}

