/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.session.impl;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.metamodel.Attribute;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.TypeMismatchException;
import org.hibernate.UnknownEntityTypeException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.spi.EffectiveEntityGraph;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.ExceptionConverter;
import org.hibernate.engine.spi.NaturalIdResolutions;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.DeleteContext;
import org.hibernate.event.spi.DeleteEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.InitializeCollectionEvent;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.event.spi.LockEvent;
import org.hibernate.event.spi.MergeContext;
import org.hibernate.event.spi.MergeEvent;
import org.hibernate.event.spi.PersistContext;
import org.hibernate.event.spi.PersistEvent;
import org.hibernate.event.spi.RefreshContext;
import org.hibernate.event.spi.RefreshEvent;
import org.hibernate.event.spi.ResolveNaturalIdEvent;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.AbstractSharedSessionContract;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.SessionImpl;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jpa.spi.NativeQueryTupleTransformer;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.query.IllegalMutationQueryException;
import org.hibernate.query.Query;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.criteria.JpaCriteriaInsertSelect;
import org.hibernate.query.hql.spi.SqmQueryImplementor;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;
import org.hibernate.query.sql.spi.NativeQueryImplementor;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.spi.NamedSqmQueryMemento;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.reactive.common.AffectedEntities;
import org.hibernate.reactive.common.InternalStateAssertions;
import org.hibernate.reactive.common.ResultSetMapping;
import org.hibernate.reactive.engine.ReactiveActionQueue;
import org.hibernate.reactive.engine.impl.ReactivePersistenceContextAdapter;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.pool.BatchingConnection;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.query.ReactiveMutationQuery;
import org.hibernate.reactive.query.ReactiveNativeQuery;
import org.hibernate.reactive.query.ReactiveQuery;
import org.hibernate.reactive.query.ReactiveQueryImplementor;
import org.hibernate.reactive.query.ReactiveSelectionQuery;
import org.hibernate.reactive.query.sql.internal.ReactiveNativeQueryImpl;
import org.hibernate.reactive.query.sql.spi.ReactiveNativeQueryImplementor;
import org.hibernate.reactive.query.sqm.internal.ReactiveQuerySqmImpl;
import org.hibernate.reactive.query.sqm.internal.ReactiveSqmSelectionQueryImpl;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.session.impl.ReactiveExceptionConverter;
import org.hibernate.reactive.session.impl.SessionUtil;
import org.hibernate.reactive.util.impl.CompletionStages;

public class ReactiveSessionImpl
extends SessionImpl
implements ReactiveSession,
EventSource {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final transient ReactiveActionQueue reactiveActionQueue = new ReactiveActionQueue(this);
    private ReactiveConnection reactiveConnection;
    private final Thread associatedWorkThread;
    private transient ExceptionConverter exceptionConverter;

    public ReactiveSessionImpl(SessionFactoryImpl delegate, SessionCreationOptions options, ReactiveConnection connection) {
        super(delegate, options);
        InternalStateAssertions.assertUseOnEventLoop();
        this.associatedWorkThread = Thread.currentThread();
        Integer batchSize = this.getConfiguredJdbcBatchSize();
        this.reactiveConnection = batchSize == null || batchSize < 2 ? connection : new BatchingConnection(connection, batchSize);
    }

    @Override
    public SessionImplementor getSharedContract() {
        return this;
    }

    @Override
    public Dialect getDialect() {
        this.threadCheck();
        return this.getJdbcServices().getDialect();
    }

    private void threadCheck() {
        InternalStateAssertions.assertCurrentThreadMatches(this.associatedWorkThread);
    }

    protected StatefulPersistenceContext createPersistenceContext() {
        return new ReactivePersistenceContextAdapter((SharedSessionContractImplementor)this);
    }

    @Override
    public ReactiveActionQueue getReactiveActionQueue() {
        this.threadCheck();
        return this.reactiveActionQueue;
    }

    public Object immediateLoad(String entityName, Object id) throws HibernateException {
        throw LOG.lazyInitializationException(entityName, id);
    }

    @Override
    public CompletionStage<Object> reactiveImmediateLoad(String entityName, Object id) throws HibernateException {
        if (LOG.isDebugEnabled()) {
            EntityPersister persister = this.getFactory().getMappingMetamodel().getEntityDescriptor(entityName);
            LOG.debugf("Initializing proxy: %s", MessageHelper.infoString((EntityPersister)persister, (Object)id, (SessionFactoryImplementor)this.getFactory()));
        }
        this.threadCheck();
        LoadEvent event = new LoadEvent(id, entityName, true, (EventSource)this, this.getReadOnlyFromLoadQueryInfluencers());
        return this.fireLoadNoChecks(event, LoadEventListener.IMMEDIATE_LOAD).thenApply(v -> {
            Object result = event.getResult();
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer((Object)result);
            return lazyInitializer != null ? lazyInitializer.getImplementation() : result;
        });
    }

    @Override
    public CompletionStage<Object> reactiveInternalLoad(String entityName, Object id, boolean eager, boolean nullable) {
        boolean clearedEffectiveGraph;
        LoadEventListener.LoadType type = ReactiveSessionImpl.internalLoadType((boolean)eager, (boolean)nullable);
        EffectiveEntityGraph effectiveEntityGraph = this.getLoadQueryInfluencers().getEffectiveEntityGraph();
        GraphSemantic semantic = effectiveEntityGraph.getSemantic();
        RootGraphImplementor graph = effectiveEntityGraph.getGraph();
        if (semantic == null || graph.appliesTo(this.getFactory().getJpaMetamodel().entity(entityName))) {
            clearedEffectiveGraph = false;
        } else {
            LOG.debug("Clearing effective entity graph for subsequent-select");
            clearedEffectiveGraph = true;
            effectiveEntityGraph.clear();
        }
        this.threadCheck();
        LoadEvent event = new LoadEvent(id, entityName, true, (EventSource)this, this.getReadOnlyFromLoadQueryInfluencers());
        return this.fireLoadNoChecks(event, type).thenApply(v -> {
            Object result = event.getResult();
            if (!nullable) {
                UnresolvableObjectException.throwIfNull((Object)result, (Object)id, (String)entityName);
            }
            return result;
        }).whenComplete((v, x) -> {
            if (clearedEffectiveGraph) {
                effectiveEntityGraph.applyGraph(graph, semantic);
            }
        });
    }

    @Override
    public <T> CompletionStage<T> reactiveFetch(T association, boolean unproxy) {
        this.checkOpen();
        if (association == null) {
            return CompletionStages.nullFuture();
        }
        if (association instanceof HibernateProxy) {
            LazyInitializer initializer = ((HibernateProxy)association).getHibernateLazyInitializer();
            if (!initializer.isUninitialized()) {
                return CompletionStages.completedFuture(unproxy ? initializer.getImplementation() : association);
            }
            String entityName = initializer.getEntityName();
            Object identifier = initializer.getIdentifier();
            return this.reactiveImmediateLoad(entityName, identifier).thenApply(entity -> {
                SessionUtil.checkEntityFound((SharedSessionContractImplementor)this, entityName, identifier, entity);
                initializer.setSession((SharedSessionContractImplementor)this);
                initializer.setImplementation(entity);
                return unproxy ? entity : association;
            });
        }
        if (association instanceof PersistentCollection) {
            PersistentCollection persistentCollection = (PersistentCollection)association;
            if (persistentCollection.wasInitialized()) {
                return CompletionStages.completedFuture(association);
            }
            return this.reactiveInitializeCollection(persistentCollection, false).thenApply(v -> association);
        }
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(association)) {
            PersistentAttributeInterceptable interceptable = ManagedTypeHelper.asPersistentAttributeInterceptable(association);
            PersistentAttributeInterceptor interceptor = interceptable.$$_hibernate_getInterceptor();
            if (interceptor instanceof EnhancementAsProxyLazinessInterceptor) {
                EnhancementAsProxyLazinessInterceptor eapli = (EnhancementAsProxyLazinessInterceptor)interceptor;
                return ReactiveEntityPersister.forceInitialize(association, null, eapli.getIdentifier(), eapli.getEntityName(), (SharedSessionContractImplementor)this).thenApply(i -> association);
            }
            return CompletionStages.completedFuture(association);
        }
        return CompletionStages.completedFuture(association);
    }

    @Override
    public <E, T> CompletionStage<T> reactiveFetch(E entity, Attribute<E, T> field) {
        return ((ReactiveEntityPersister)this.getEntityPersister(null, entity)).reactiveInitializeLazyProperty(field, entity, (SharedSessionContractImplementor)this);
    }

    @Override
    public <R> ReactiveQuery<R> createReactiveQuery(CriteriaQuery<R> criteriaQuery) {
        this.checkOpen();
        try {
            SqmQuerySpec querySpec;
            SqmSelectStatement selectStatement = (SqmSelectStatement)criteriaQuery;
            if (!(selectStatement.getQueryPart() instanceof SqmQueryGroup) && (querySpec = selectStatement.getQuerySpec()).getSelectClause().getSelections().isEmpty() && querySpec.getFromClause().getRoots().size() == 1) {
                querySpec.getSelectClause().setSelection((SqmSelectableNode)querySpec.getFromClause().getRoots().get(0));
            }
            return this.createCriteriaQuery((SqmStatement)selectStatement, criteriaQuery.getResultType());
        }
        catch (RuntimeException e) {
            if (this.getSessionFactory().getJpaMetamodel().getJpaCompliance().isJpaTransactionComplianceEnabled()) {
                this.markForRollbackOnly();
            }
            throw this.getExceptionConverter().convert(e);
        }
    }

    private <T> ReactiveQueryImplementor<T> createCriteriaQuery(SqmStatement<T> criteria, Class<T> resultType) {
        ReactiveQuerySqmImpl<T> query = new ReactiveQuerySqmImpl<T>(criteria, resultType, (SharedSessionContractImplementor)this);
        this.applyQuerySettingsAndHints((Query)query);
        return query;
    }

    @Override
    public <R> ReactiveQuery<R> createReactiveQuery(String queryString) {
        return this.createReactiveQuery(queryString, null);
    }

    @Override
    public <R> ReactiveQuery<R> createReactiveQuery(String queryString, Class<R> expectedResultType) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            HqlInterpretation interpretation = this.interpretHql(queryString, expectedResultType);
            ReactiveQuerySqmImpl<R> query = new ReactiveQuerySqmImpl<R>(queryString, interpretation, expectedResultType, (SharedSessionContractImplementor)this);
            this.applyQuerySettingsAndHints((Query)query);
            query.setComment(queryString);
            return query;
        }
        catch (RuntimeException e) {
            this.markForRollbackOnly();
            throw this.getExceptionConverter().convert(e);
        }
    }

    public <T> ReactiveNativeQueryImplementor<T> createReactiveNativeQuery(String sqlString) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            ReactiveNativeQueryImpl query = new ReactiveNativeQueryImpl(sqlString, (SharedSessionContractImplementor)this);
            if (StringHelper.isEmpty((String)query.getComment())) {
                query.setComment("dynamic native SQL query");
            }
            this.applyQuerySettingsAndHints((Query)query);
            return query;
        }
        catch (RuntimeException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    public void prepareForQueryExecution(boolean requiresTxn) {
        this.checkOpen();
        this.checkTransactionSynchStatus();
    }

    public <T> ReactiveNativeQuery<T> createReactiveNativeQuery(String sqlString, Class<T> resultClass) {
        ReactiveNativeQuery query = this.createReactiveNativeQuery(sqlString);
        return this.addResultType(resultClass, query);
    }

    private <T> ReactiveNativeQuery<T> addResultType(Class<T> resultClass, ReactiveNativeQuery<T> query) {
        if (Tuple.class.equals(resultClass)) {
            query.setTupleTransformer((TupleTransformer)new NativeQueryTupleTransformer());
        } else if (this.getFactory().getMappingMetamodel().isEntityClass(resultClass)) {
            query.addEntity("alias1", resultClass.getName(), LockMode.READ);
        } else if (resultClass != Object.class && resultClass != Object[].class) {
            query.addResultTypeClass(resultClass);
        }
        return query;
    }

    @Override
    public <R> ReactiveNativeQuery<R> createReactiveNativeQuery(String sqlString, Class<R> resultClass, String tableAlias) {
        ReactiveNativeQuery query = this.createReactiveNativeQuery(sqlString);
        if (this.getFactory().getMappingMetamodel().isEntityClass(resultClass)) {
            query.addEntity(tableAlias, resultClass.getName(), LockMode.READ);
            return query;
        }
        throw new UnknownEntityTypeException("unable to locate persister: " + resultClass.getName());
    }

    @Override
    public <R> ReactiveNativeQuery<R> createReactiveNativeQuery(String sqlString, String resultSetMappingName) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            return StringHelper.isNotEmpty((String)resultSetMappingName) ? new ReactiveNativeQueryImpl(sqlString, this.getResultSetMappingMemento(resultSetMappingName), (AbstractSharedSessionContract)this) : new ReactiveNativeQueryImpl(sqlString, (SharedSessionContractImplementor)this);
        }
        catch (RuntimeException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    @Override
    public <R> ReactiveNativeQuery<R> createReactiveNativeQuery(String sqlString, String resultSetMappingName, Class<R> resultClass) {
        ReactiveNativeQuery<R> query = this.createReactiveNativeQuery(sqlString, resultSetMappingName);
        if (Tuple.class.equals(resultClass)) {
            query.setTupleTransformer((TupleTransformer)new NativeQueryTupleTransformer());
        }
        return query;
    }

    @Override
    public <R> ReactiveSelectionQuery<R> createReactiveSelectionQuery(String hqlString, Class<R> resultType) {
        return this.interpretAndCreateSelectionQuery(hqlString, resultType);
    }

    private <R> ReactiveSelectionQuery<R> interpretAndCreateSelectionQuery(String hql, Class<R> resultType) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            HqlInterpretation interpretation = this.interpretHql(hql, resultType);
            ReactiveSessionImpl.checkSelectionQuery((String)hql, (HqlInterpretation)interpretation);
            return this.createSelectionQuery(hql, resultType, interpretation);
        }
        catch (RuntimeException e) {
            this.markForRollbackOnly();
            throw e;
        }
    }

    private <R> ReactiveSelectionQuery<R> createSelectionQuery(String hql, Class<R> resultType, HqlInterpretation interpretation) {
        ReactiveSqmSelectionQueryImpl<R> query = new ReactiveSqmSelectionQueryImpl<R>(hql, interpretation, resultType, (SharedSessionContractImplementor)this);
        if (resultType != null) {
            ReactiveSessionImpl.checkResultType(resultType, query);
        }
        query.setComment(hql);
        this.applyQuerySettingsAndHints((SelectionQuery)query);
        return query;
    }

    @Override
    public <R> ReactiveQueryImplementor<R> createReactiveNamedQuery(String name, Class<R> resultType) {
        return (ReactiveQueryImplementor)this.buildNamedQuery(name, resultType);
    }

    @Override
    public <R> ReactiveSelectionQuery<R> createReactiveSelectionQuery(CriteriaQuery<R> criteria) {
        SqmUtil.verifyIsSelectStatement((SqmStatement)((SqmStatement)criteria), null);
        return new ReactiveSqmSelectionQueryImpl((SqmSelectStatement)criteria, criteria.getResultType(), (SharedSessionContractImplementor)this);
    }

    @Override
    public <R> ReactiveMutationQuery<R> createReactiveMutationQuery(String hqlString) {
        QueryImplementor query = this.createQuery(hqlString);
        SqmStatement sqmStatement = ((SqmQueryImplementor)query).getSqmStatement();
        ReactiveSessionImpl.checkMutationQuery((String)hqlString, (SqmStatement)sqmStatement);
        return new ReactiveQuerySqmImpl(sqmStatement, null, (SharedSessionContractImplementor)this);
    }

    @Override
    public <R> ReactiveMutationQuery<R> createReactiveMutationQuery(CriteriaUpdate<R> updateQuery) {
        this.checkOpen();
        try {
            return this.createCriteriaQuery((SqmStatement)((SqmUpdateStatement)updateQuery), null);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public <R> ReactiveMutationQuery<R> createReactiveMutationQuery(CriteriaDelete<R> deleteQuery) {
        this.checkOpen();
        try {
            return this.createCriteriaQuery((SqmStatement)((SqmDeleteStatement)deleteQuery), null);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public <R> ReactiveMutationQuery<R> createReactiveMutationQuery(JpaCriteriaInsertSelect<R> insertSelect) {
        this.checkOpen();
        try {
            return this.createCriteriaQuery((SqmStatement)((SqmInsertSelectStatement)insertSelect), null);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public <R> ReactiveMutationQuery<R> createNamedReactiveMutationQuery(String queryName) {
        return (ReactiveMutationQuery)this.buildNamedQuery(queryName, memento -> this.createSqmQueryImplementor(queryName, (NamedSqmQueryMemento)memento), memento -> this.createNativeQueryImplementor(queryName, (NamedNativeQueryMemento)memento));
    }

    @Override
    public <R> ReactiveSelectionQuery<R> createNamedReactiveSelectionQuery(String queryName) {
        return (ReactiveSelectionQuery)this.createNamedSelectionQuery(queryName, null);
    }

    @Override
    public <R> ReactiveSelectionQuery<R> createNamedReactiveSelectionQuery(String queryName, Class<R> expectedResultType) {
        return (ReactiveSelectionQuery)this.createNamedSelectionQuery(queryName, expectedResultType);
    }

    @Override
    public <R> ReactiveMutationQuery<R> createNativeReactiveMutationQuery(String sqlString) {
        ReactiveNativeQuery query = this.createReactiveNativeQuery(sqlString);
        if (query.isSelectQuery() == Boolean.TRUE) {
            throw new IllegalMutationQueryException("Expecting a native mutation query, but found `" + sqlString + "`");
        }
        return query;
    }

    @Override
    public <R> ReactiveNativeQuery<R> createReactiveNativeQuery(String queryString, AffectedEntities affectedEntities) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            ReactiveNativeQueryImpl query = new ReactiveNativeQueryImpl(queryString, (SharedSessionContractImplementor)this);
            this.addAffectedEntities(affectedEntities, (NativeQueryImplementor<?>)query);
            if (StringHelper.isEmpty((String)query.getComment())) {
                query.setComment("dynamic native SQL query");
            }
            this.applyQuerySettingsAndHints((Query)query);
            return query;
        }
        catch (RuntimeException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    private void addAffectedEntities(AffectedEntities affectedEntities, NativeQueryImplementor<?> query) {
        for (String space : affectedEntities.getAffectedSpaces(this.getFactory())) {
            query.addSynchronizedQuerySpace(space);
        }
    }

    @Override
    public <R> ReactiveNativeQuery<R> createReactiveNativeQuery(String queryString, Class<R> resultType, AffectedEntities affectedEntities) {
        ReactiveNativeQuery<R> query = this.createReactiveNativeQuery(queryString, affectedEntities);
        return this.addResultType(resultType, query);
    }

    public <R> ReactiveNativeQueryImpl<R> createReactiveNativeQuery(String queryString, ResultSetMapping<R> resultSetMapping) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            ReactiveNativeQueryImpl nativeQuery = resultSetMapping != null ? new ReactiveNativeQueryImpl(queryString, this.getResultSetMappingMemento(resultSetMapping.getName()), (AbstractSharedSessionContract)this) : new ReactiveNativeQueryImpl(queryString, (SharedSessionContractImplementor)this);
            this.applyQuerySettingsAndHints((Query)nativeQuery);
            return nativeQuery;
        }
        catch (RuntimeException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    @Override
    public <R> ReactiveNativeQuery<R> createReactiveNativeQuery(String queryString, ResultSetMapping<R> resultSetMapping, AffectedEntities affectedEntities) {
        ReactiveNativeQuery nativeQuery = this.createReactiveNativeQuery(queryString, (ResultSetMapping)resultSetMapping);
        this.addAffectedEntities(affectedEntities, (NativeQueryImplementor<?>)nativeQuery);
        return nativeQuery;
    }

    @Override
    public <T> ResultSetMapping<T> getResultSetMapping(final Class<T> resultType, final String mappingName) {
        NamedResultSetMappingMemento mapping = this.getResultSetMappingMemento(mappingName);
        if (mapping == null) {
            throw new IllegalArgumentException("result set mapping does not exist: " + mappingName);
        }
        return new ResultSetMapping<T>(){

            @Override
            public String getName() {
                return mappingName;
            }

            @Override
            public Class<T> getResultType() {
                return resultType;
            }
        };
    }

    @Deprecated
    public void initializeCollection(PersistentCollection<?> collection, boolean writing) {
        throw LOG.collectionCannotBeInitializedlazyInitializationException(ReactiveSessionImpl.collectionRoleLogMessage(collection));
    }

    private static String collectionRoleLogMessage(PersistentCollection<?> collection) {
        if (collection == null) {
            return "collection is null";
        }
        return collection.getRole();
    }

    @Override
    public CompletionStage<Void> reactiveInitializeCollection(PersistentCollection<?> collection, boolean writing) {
        this.checkOpenOrWaitingForAutoClose();
        this.pulseTransactionCoordinator();
        InitializeCollectionEvent event = new InitializeCollectionEvent(collection, (EventSource)this);
        return this.fastSessionServices.eventListenerGroup_INIT_COLLECTION.fireEventOnEachListener((Object)event, l -> l::onReactiveInitializeCollection).handle((v, e) -> {
            this.delayedAfterCompletion();
            if (e instanceof MappingException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException(e.getMessage()));
            }
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    @Override
    public CompletionStage<Void> reactivePersist(Object entity) {
        this.checkOpen();
        return this.firePersist(new PersistEvent(null, entity, (EventSource)this));
    }

    @Override
    public CompletionStage<Void> reactivePersist(Object object, PersistContext copiedAlready) {
        this.checkOpenOrWaitingForAutoClose();
        return this.firePersist(copiedAlready, new PersistEvent(null, object, (EventSource)this));
    }

    private CompletionStage<Void> firePersist(PersistEvent event) {
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        return this.fastSessionServices.eventListenerGroup_PERSIST.fireEventOnEachListener((Object)event, l -> l::reactiveOnPersist).handle((v, e) -> {
            this.checkNoUnresolvedActionsAfterOperation();
            if (e instanceof MappingException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException(e.getMessage()));
            }
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    private CompletionStage<Void> firePersist(PersistContext copiedAlready, PersistEvent event) {
        this.pulseTransactionCoordinator();
        return this.fastSessionServices.eventListenerGroup_PERSIST.fireEventOnEachListener((Object)event, (Object)copiedAlready, l -> l::reactiveOnPersist).handle((v, e) -> {
            this.delayedAfterCompletion();
            if (e instanceof MappingException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException(e.getMessage()));
            }
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    @Override
    public CompletionStage<Void> reactivePersistOnFlush(Object entity, PersistContext copiedAlready) {
        this.checkOpenOrWaitingForAutoClose();
        return this.firePersistOnFlush(copiedAlready, new PersistEvent(null, entity, (EventSource)this));
    }

    private CompletionStage<Void> firePersistOnFlush(PersistContext copiedAlready, PersistEvent event) {
        this.pulseTransactionCoordinator();
        return this.fastSessionServices.eventListenerGroup_PERSIST.fireEventOnEachListener((Object)event, (Object)copiedAlready, l -> l::reactiveOnPersist).whenComplete((v, e) -> this.delayedAfterCompletion());
    }

    @Override
    public CompletionStage<Void> reactiveRemove(Object entity) {
        this.checkOpen();
        return this.fireRemove(new DeleteEvent(entity, (EventSource)this));
    }

    @Override
    public CompletionStage<Void> reactiveRemove(String entityName, boolean isCascadeDeleteEnabled, DeleteContext transientEntities) throws HibernateException {
        return this.reactiveRemove(entityName, null, isCascadeDeleteEnabled, transientEntities);
    }

    @Override
    public CompletionStage<Void> reactiveRemove(String entityName, Object child, boolean isCascadeDeleteEnabled, DeleteContext transientEntities) {
        this.checkOpenOrWaitingForAutoClose();
        boolean removingOrphanBeforeUpates = this.persistenceContext().isRemovingOrphanBeforeUpates();
        if (LOG.isTraceEnabled() && removingOrphanBeforeUpates) {
            this.logRemoveOrphanBeforeUpdates("before continuing", entityName, entityName);
        }
        return this.fireRemove(new DeleteEvent(entityName, child, isCascadeDeleteEnabled, removingOrphanBeforeUpates, (EventSource)this), transientEntities);
    }

    private ReactivePersistenceContextAdapter persistenceContext() {
        return (ReactivePersistenceContextAdapter)this.getPersistenceContextInternal();
    }

    private void logRemoveOrphanBeforeUpdates(String timing, String entityName, Object entity) {
        if (LOG.isTraceEnabled()) {
            EntityEntry entityEntry = this.persistenceContext().getEntry(entity);
            LOG.tracef("%s remove orphan before updates: [%s]", timing, entityEntry == null ? entityName : MessageHelper.infoString((String)entityName, (Object)entityEntry.getId()));
        }
    }

    private CompletionStage<Void> fireRemove(DeleteEvent event) {
        this.pulseTransactionCoordinator();
        return this.fastSessionServices.eventListenerGroup_DELETE.fireEventOnEachListener((Object)event, l -> l::reactiveOnDelete).handle((v, e) -> {
            this.delayedAfterCompletion();
            if (e instanceof ObjectDeletedException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException((Throwable)e));
            }
            if (e instanceof MappingException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException(e.getMessage(), (Throwable)e));
            }
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    private CompletionStage<Void> fireRemove(DeleteEvent event, DeleteContext transientEntities) {
        this.pulseTransactionCoordinator();
        return this.fastSessionServices.eventListenerGroup_DELETE.fireEventOnEachListener((Object)event, (Object)transientEntities, l -> l::reactiveOnDelete).handle((v, e) -> {
            this.delayedAfterCompletion();
            if (e instanceof ObjectDeletedException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException((Throwable)e));
            }
            if (e instanceof MappingException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException(e.getMessage(), (Throwable)e));
            }
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    @Override
    public <T> CompletionStage<T> reactiveMerge(T object) throws HibernateException {
        this.checkOpen();
        return this.fireMerge(new MergeEvent(null, object, (EventSource)this));
    }

    @Override
    public CompletionStage<Void> reactiveMerge(Object object, MergeContext copiedAlready) throws HibernateException {
        this.checkOpenOrWaitingForAutoClose();
        return this.fireMerge(copiedAlready, new MergeEvent(null, object, (EventSource)this));
    }

    private <T> CompletionStage<T> fireMerge(MergeEvent event) {
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        return this.fastSessionServices.eventListenerGroup_MERGE.fireEventOnEachListener((Object)event, l -> l::reactiveOnMerge).handle((v, e) -> {
            this.checkNoUnresolvedActionsAfterOperation();
            if (e instanceof ObjectDeletedException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException((Throwable)e));
            }
            if (e instanceof MappingException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException(e.getMessage(), (Throwable)e));
            }
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return CompletionStages.returnOrRethrow(e, event.getResult());
        });
    }

    private CompletionStage<Void> fireMerge(MergeContext copiedAlready, MergeEvent event) {
        this.pulseTransactionCoordinator();
        return this.fastSessionServices.eventListenerGroup_MERGE.fireEventOnEachListener((Object)event, (Object)copiedAlready, l -> l::reactiveOnMerge).handle((v, e) -> {
            this.delayedAfterCompletion();
            if (e instanceof ObjectDeletedException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException((Throwable)e));
            }
            if (e instanceof MappingException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException(e.getMessage(), (Throwable)e));
            }
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    @Override
    public CompletionStage<Void> reactiveFlush() {
        this.checkOpen();
        return this.doFlush();
    }

    @Override
    public CompletionStage<Void> reactiveAutoflush() {
        return this.getHibernateFlushMode().lessThan(FlushMode.COMMIT) ? CompletionStages.voidFuture() : this.doFlush();
    }

    @Override
    public CompletionStage<Boolean> reactiveAutoFlushIfRequired(Set<String> querySpaces) {
        this.checkOpen();
        AutoFlushEvent event = new AutoFlushEvent(querySpaces, (EventSource)this);
        return this.fastSessionServices.eventListenerGroup_AUTO_FLUSH.fireEventOnEachListener((Object)event, l -> l::reactiveOnAutoFlush).thenApply(v -> event.isFlushRequired());
    }

    @Override
    public CompletionStage<Void> reactiveForceFlush(EntityEntry entry) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Flushing to force deletion of re-saved object: %s", MessageHelper.infoString((EntityPersister)entry.getPersister(), (Object)entry.getId(), (SessionFactoryImplementor)this.getFactory()));
        }
        if (this.getPersistenceContextInternal().getCascadeLevel() > 0) {
            return CompletionStages.failedFuture((Throwable)new ObjectDeletedException("deleted object would be re-saved by cascade (remove deleted object from associations)", entry.getId(), entry.getPersister().getEntityName()));
        }
        this.checkOpenOrWaitingForAutoClose();
        return this.doFlush();
    }

    private CompletionStage<Void> doFlush() {
        this.checkTransactionNeededForUpdateOperation("no transaction is in progress");
        this.pulseTransactionCoordinator();
        if (this.getPersistenceContextInternal().getCascadeLevel() > 0) {
            throw LOG.flushDuringCascadeIsDangerous();
        }
        return this.fastSessionServices.eventListenerGroup_FLUSH.fireEventOnEachListener((Object)new FlushEvent((EventSource)this), l -> l::reactiveOnFlush).handle((v, e) -> {
            this.delayedAfterCompletion();
            if (e instanceof CompletionException && e.getCause() instanceof RuntimeException) {
                e = this.getExceptionConverter().convert((RuntimeException)e.getCause());
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    public ExceptionConverter getExceptionConverter() {
        if (this.exceptionConverter == null) {
            this.exceptionConverter = new ReactiveExceptionConverter((SharedSessionContractImplementor)this);
        }
        return this.exceptionConverter;
    }

    @Override
    public CompletionStage<Void> reactiveRefresh(Object entity, LockOptions lockOptions) {
        this.checkOpen();
        return this.fireRefresh(new RefreshEvent(entity, lockOptions, (EventSource)this));
    }

    @Override
    public CompletionStage<Void> reactiveRefresh(Object object, RefreshContext refreshedAlready) {
        this.checkOpenOrWaitingForAutoClose();
        return this.fireRefresh(refreshedAlready, new RefreshEvent(null, object, (EventSource)this));
    }

    CompletionStage<Void> fireRefresh(RefreshEvent event) {
        if (!this.getSessionFactory().getSessionFactoryOptions().isAllowRefreshDetachedEntity() && (event.getEntityName() != null ? !this.contains(event.getEntityName(), event.getObject()) : !this.contains(event.getObject()))) {
            throw new IllegalArgumentException("Entity not managed");
        }
        this.pulseTransactionCoordinator();
        return this.fastSessionServices.eventListenerGroup_REFRESH.fireEventOnEachListener((Object)event, l -> l::reactiveOnRefresh).handle((v, e) -> {
            this.delayedAfterCompletion();
            if (e instanceof RuntimeException) {
                if (!this.getSessionFactory().getSessionFactoryOptions().isJpaBootstrap() && e instanceof HibernateException) {
                    return (Void)CompletionStages.rethrow(e);
                }
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    private CompletionStage<Void> fireRefresh(RefreshContext refreshedAlready, RefreshEvent event) {
        this.pulseTransactionCoordinator();
        return this.fastSessionServices.eventListenerGroup_REFRESH.fireEventOnEachListener((Object)event, (Object)refreshedAlready, l -> l::reactiveOnRefresh).handle((v, e) -> {
            this.delayedAfterCompletion();
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    @Override
    public CompletionStage<Void> reactiveLock(Object object, LockOptions lockOptions) {
        this.checkOpen();
        return this.fireLock(new LockEvent(object, lockOptions, (EventSource)this));
    }

    private CompletionStage<Void> fireLock(LockEvent event) {
        this.pulseTransactionCoordinator();
        return this.fastSessionServices.eventListenerGroup_LOCK.fireEventOnEachListener((Object)event, l -> l::reactiveOnLock).handle((v, e) -> {
            this.delayedAfterCompletion();
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e);
            }
            return (Void)CompletionStages.returnNullorRethrow(e);
        });
    }

    @Override
    public <T> CompletionStage<T> reactiveGet(Class<T> entityClass, Object id) {
        return new ReactiveIdentifierLoadAccessImpl<T>(entityClass).load(id);
    }

    @Override
    public <T> CompletionStage<T> reactiveFind(Class<T> entityClass, Object id, LockOptions lockOptions, EntityGraph<T> fetchGraph) {
        this.checkOpen();
        if (fetchGraph != null) {
            this.getLoadQueryInfluencers().getEffectiveEntityGraph().applyGraph((RootGraphImplementor)fetchGraph, GraphSemantic.FETCH);
        }
        ReactiveIdentifierLoadAccessImpl<T> loadAccess = new ReactiveIdentifierLoadAccessImpl<T>(entityClass).with(this.determineAppropriateLocalCacheMode(null)).with(lockOptions);
        return loadAccess.load(id).handle((result, e) -> {
            if (e instanceof EntityNotFoundException) {
                throw new UnsupportedOperationException();
            }
            if (e instanceof ObjectDeletedException) {
                throw new UnsupportedOperationException();
            }
            if (e instanceof ObjectNotFoundException) {
                throw new IllegalArgumentException(e.getMessage(), (Throwable)e);
            }
            if (e instanceof MappingException || e instanceof TypeMismatchException || e instanceof ClassCastException) {
                throw this.getExceptionConverter().convert((RuntimeException)new IllegalArgumentException(e.getMessage(), (Throwable)e));
            }
            if (e instanceof JDBCException) {
                throw this.getExceptionConverter().convert((HibernateException)((JDBCException)e), lockOptions);
            }
            if (e instanceof RuntimeException) {
                throw this.getExceptionConverter().convert((RuntimeException)e, lockOptions);
            }
            return result;
        }).whenComplete((v, e) -> this.getLoadQueryInfluencers().getEffectiveEntityGraph().clear());
    }

    @Override
    public <T> CompletionStage<List<T>> reactiveFind(Class<T> entityClass, Object ... ids) {
        return new ReactiveMultiIdentifierLoadAccessImpl<T>(entityClass).multiLoad(ids);
    }

    @Override
    public <T> CompletionStage<T> reactiveFind(Class<T> entityClass, Map<String, Object> ids) {
        EntityPersister persister = this.getFactory().getMappingMetamodel().getEntityDescriptor(entityClass);
        return new NaturalIdLoadAccessImpl(persister).resolveNaturalId(ids).thenCompose(id -> this.reactiveFind(entityClass, id, null, null));
    }

    private CompletionStage<Void> fireReactiveLoad(LoadEvent event, LoadEventListener.LoadType loadType) {
        this.checkOpenOrWaitingForAutoClose();
        return this.fireLoadNoChecks(event, loadType).whenComplete((v, e) -> this.delayedAfterCompletion());
    }

    private CompletionStage<Void> fireLoadNoChecks(LoadEvent event, LoadEventListener.LoadType loadType) {
        this.pulseTransactionCoordinator();
        return this.fastSessionServices.eventListenerGroup_LOAD.fireEventOnEachListener((Object)event, (Object)loadType, l -> l::reactiveOnLoad);
    }

    private CompletionStage<Void> fireResolveNaturalId(ResolveNaturalIdEvent event) {
        this.checkOpenOrWaitingForAutoClose();
        return this.fastSessionServices.eventListenerGroup_RESOLVE_NATURAL_ID.fireEventOnEachListener((Object)event, l -> l::onReactiveResolveNaturalId).whenComplete((c, e) -> this.delayedAfterCompletion());
    }

    public void delayedAfterCompletion() {
    }

    public void afterOperation(boolean success) {
    }

    public void checkTransactionNeededForUpdateOperation(String exceptionMessage) {
    }

    private Boolean getReadOnlyFromLoadQueryInfluencers() {
        return this.getLoadQueryInfluencers().getReadOnly();
    }

    public <T> T unwrap(Class<T> clazz) {
        if (ReactiveSession.class.isAssignableFrom(clazz)) {
            return clazz.cast(this);
        }
        return (T)super.unwrap(clazz);
    }

    @Override
    public ReactiveConnection getReactiveConnection() {
        InternalStateAssertions.assertUseOnEventLoop();
        return this.reactiveConnection;
    }

    public void close() throws HibernateException {
        throw LOG.nonReactiveMethodCall("reactiveClose()");
    }

    @Override
    public CompletionStage<Void> reactiveClose() {
        super.close();
        return this.reactiveConnection != null ? this.reactiveConnection.close() : CompletionStages.voidFuture();
    }

    @Override
    public Integer getBatchSize() {
        return this.getJdbcBatchSize();
    }

    @Override
    public void setBatchSize(Integer batchSize) {
        this.setJdbcBatchSize(batchSize);
        this.reactiveConnection = this.reactiveConnection.withBatchSize(batchSize);
    }

    public <T> Class<T> getEntityClass(T entity) {
        if (entity instanceof HibernateProxy) {
            return ((HibernateProxy)entity).getHibernateLazyInitializer().getPersistentClass();
        }
        return this.getEntityPersister(null, entity).getMappedClass();
    }

    @Override
    public Object getEntityId(Object entity) {
        if (entity instanceof HibernateProxy) {
            return ((HibernateProxy)entity).getHibernateLazyInitializer().getIdentifier();
        }
        return this.getEntityPersister(null, entity).getIdentifier(entity, (SharedSessionContractImplementor)this);
    }

    public void checkOpen() {
        this.threadCheck();
        super.checkOpen();
    }

    public void removeOrphanBeforeUpdates(String entityName, Object child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<Void> reactiveRemoveOrphanBeforeUpdates(String entityName, Object child) {
        StatefulPersistenceContext persistenceContext = (StatefulPersistenceContext)this.getPersistenceContextInternal();
        persistenceContext.beginRemoveOrphanBeforeUpdates();
        return this.fireRemove(new DeleteEvent(entityName, child, false, true, (EventSource)this)).thenAccept(v -> {
            persistenceContext.endRemoveOrphanBeforeUpdates();
            if (LOG.isTraceEnabled()) {
                this.logRemoveOrphanBeforeUpdates("end", entityName, child, persistenceContext);
            }
        });
    }

    @Override
    public void clear() {
        super.clear();
        this.reactiveActionQueue.clear();
    }

    private void logRemoveOrphanBeforeUpdates(String timing, String entityName, Object entity, StatefulPersistenceContext persistenceContext) {
        if (LOG.isTraceEnabled()) {
            EntityEntry entityEntry = persistenceContext.getEntry(entity);
            LOG.tracef("%s remove orphan before updates: [%s]", timing, entityEntry == null ? entityName : MessageHelper.infoString((String)entityName, (Object)entityEntry.getId()));
        }
    }

    public <T> RootGraphImplementor<T> createEntityGraph(Class<T> entity, String name) {
        RootGraphImplementor entityGraph = this.createEntityGraph(name);
        if (!entityGraph.getGraphedType().getJavaType().equals(entity)) {
            throw LOG.wrongEntityType();
        }
        return entityGraph;
    }

    public <T> RootGraphImplementor<T> getEntityGraph(Class<T> entity, String name) {
        RootGraphImplementor entityGraph = this.getEntityGraph(name);
        if (!entityGraph.getGraphedType().getJavaType().equals(entity)) {
            throw LOG.wrongEntityType();
        }
        return entityGraph;
    }

    private class NaturalIdLoadAccessImpl<T> {
        private final EntityPersister entityPersister;
        private LockOptions lockOptions;
        private boolean synchronizationEnabled = true;

        private NaturalIdLoadAccessImpl(EntityPersister entityPersister) {
            this.entityPersister = entityPersister;
            if (!entityPersister.hasNaturalIdentifier()) {
                throw LOG.entityDidNotDefinedNaturalId(entityPersister.getEntityName());
            }
        }

        public NaturalIdLoadAccessImpl<T> with(LockOptions lockOptions) {
            this.lockOptions = lockOptions;
            return this;
        }

        protected void synchronizationEnabled(boolean synchronizationEnabled) {
            this.synchronizationEnabled = synchronizationEnabled;
        }

        protected final CompletionStage<Object> resolveNaturalId(Map<String, Object> naturalIdParameters) {
            this.performAnyNeededCrossReferenceSynchronizations();
            ResolveNaturalIdEvent event = new ResolveNaturalIdEvent(naturalIdParameters, this.entityPersister, (EventSource)ReactiveSessionImpl.this);
            return ReactiveSessionImpl.this.fireResolveNaturalId(event).thenApply(v -> event.getEntityId() == NaturalIdResolutions.INVALID_NATURAL_ID_REFERENCE ? null : event.getEntityId());
        }

        protected void performAnyNeededCrossReferenceSynchronizations() {
            if (!this.synchronizationEnabled) {
                return;
            }
            if (this.entityPersister.getEntityMetamodel().hasImmutableNaturalId()) {
                return;
            }
            if (!ReactiveSessionImpl.this.isTransactionInProgress()) {
                return;
            }
            PersistenceContext persistenceContext = ReactiveSessionImpl.this.getPersistenceContextInternal();
            for (Object pk : persistenceContext.getNaturalIdResolutions().getCachedPkResolutions((EntityMappingType)this.entityPersister)) {
                EntityKey entityKey = ReactiveSessionImpl.this.generateEntityKey(pk, this.entityPersister);
                Object entity = persistenceContext.getEntity(entityKey);
                EntityEntry entry = persistenceContext.getEntry(entity);
                if (entry == null || !entry.requiresDirtyCheck(entity) || entry.getStatus() != Status.MANAGED) continue;
                persistenceContext.getNaturalIdResolutions().handleSynchronization(pk, entity, (EntityMappingType)this.entityPersister);
            }
        }

        protected final ReactiveIdentifierLoadAccessImpl<T> getIdentifierLoadAccess() {
            ReactiveIdentifierLoadAccessImpl identifierLoadAccess = new ReactiveIdentifierLoadAccessImpl(this.entityPersister);
            if (this.lockOptions != null) {
                identifierLoadAccess.with(this.lockOptions);
            }
            return identifierLoadAccess;
        }

        protected EntityPersister entityPersister() {
            return this.entityPersister;
        }
    }

    private class ReactiveMultiIdentifierLoadAccessImpl<T>
    implements MultiIdLoadOptions {
        private final EntityPersister entityPersister;
        private LockOptions lockOptions;
        private CacheMode cacheMode;
        private RootGraphImplementor<T> rootGraph;
        private GraphSemantic graphSemantic;
        private Integer batchSize;
        private boolean sessionCheckingEnabled;
        private boolean returnOfDeletedEntitiesEnabled;
        private boolean orderedReturnEnabled = true;

        public ReactiveMultiIdentifierLoadAccessImpl(EntityPersister entityPersister) {
            this.entityPersister = entityPersister;
        }

        public ReactiveMultiIdentifierLoadAccessImpl(Class<T> entityClass) {
            this(reactiveSessionImpl.getFactory().getMappingMetamodel().getEntityDescriptor(entityClass));
        }

        public LockOptions getLockOptions() {
            return this.lockOptions;
        }

        public final ReactiveMultiIdentifierLoadAccessImpl<T> with(LockOptions lockOptions) {
            this.lockOptions = lockOptions;
            return this;
        }

        public ReactiveMultiIdentifierLoadAccessImpl<T> with(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
            return this;
        }

        public ReactiveMultiIdentifierLoadAccessImpl<T> with(RootGraph<T> graph, GraphSemantic semantic) {
            this.rootGraph = (RootGraphImplementor)graph;
            this.graphSemantic = semantic;
            return this;
        }

        public Integer getBatchSize() {
            return this.batchSize;
        }

        public ReactiveMultiIdentifierLoadAccessImpl<T> withBatchSize(int batchSize) {
            this.batchSize = batchSize < 1 ? null : Integer.valueOf(batchSize);
            return this;
        }

        public boolean isSessionCheckingEnabled() {
            return this.sessionCheckingEnabled;
        }

        public boolean isSecondLevelCacheCheckingEnabled() {
            return this.cacheMode == CacheMode.NORMAL || this.cacheMode == CacheMode.GET;
        }

        public ReactiveMultiIdentifierLoadAccessImpl<T> enableSessionCheck(boolean enabled) {
            this.sessionCheckingEnabled = enabled;
            return this;
        }

        public boolean isReturnOfDeletedEntitiesEnabled() {
            return this.returnOfDeletedEntitiesEnabled;
        }

        public ReactiveMultiIdentifierLoadAccessImpl<T> enableReturnOfDeletedEntities(boolean enabled) {
            this.returnOfDeletedEntitiesEnabled = enabled;
            return this;
        }

        public boolean isOrderReturnEnabled() {
            return this.orderedReturnEnabled;
        }

        public ReactiveMultiIdentifierLoadAccessImpl<T> enableOrderedReturn(boolean enabled) {
            this.orderedReturnEnabled = enabled;
            return this;
        }

        public CompletionStage<List<T>> multiLoad(Object ... ids) {
            Object[] sids = new Object[ids.length];
            System.arraycopy(ids, 0, sids, 0, ids.length);
            return this.perform(() -> ((ReactiveEntityPersister)this.entityPersister).reactiveMultiLoad(sids, ReactiveSessionImpl.this, this));
        }

        public CompletionStage<List<T>> perform(Supplier<CompletionStage<List<T>>> executor) {
            CacheMode sessionCacheMode = ReactiveSessionImpl.this.getCacheMode();
            boolean cacheModeChanged = false;
            if (this.cacheMode != null && this.cacheMode != sessionCacheMode) {
                ReactiveSessionImpl.this.setCacheMode(this.cacheMode);
                cacheModeChanged = true;
            }
            if (this.graphSemantic != null) {
                if (this.rootGraph == null) {
                    throw new IllegalArgumentException("Graph semantic specified, but no RootGraph was supplied");
                }
                ReactiveSessionImpl.this.getLoadQueryInfluencers().getEffectiveEntityGraph().applyGraph(this.rootGraph, this.graphSemantic);
            }
            boolean finalCacheModeChanged = cacheModeChanged;
            return executor.get().whenComplete((v, x) -> {
                if (this.graphSemantic != null) {
                    ReactiveSessionImpl.this.getLoadQueryInfluencers().getEffectiveEntityGraph().clear();
                }
                if (finalCacheModeChanged) {
                    ReactiveSessionImpl.this.setCacheMode(sessionCacheMode);
                }
            });
        }

        public <K> CompletionStage<List<T>> multiLoad(List<K> ids) {
            return this.perform(() -> (CompletionStage)((Object)this.entityPersister.multiLoad(ids.toArray(new Object[0]), (EventSource)ReactiveSessionImpl.this, (MultiIdLoadOptions)this)));
        }
    }

    private class ReactiveIdentifierLoadAccessImpl<T> {
        private final EntityPersister entityPersister;
        private LockOptions lockOptions;
        private CacheMode cacheMode;
        private RootGraphImplementor<T> rootGraph;
        private GraphSemantic graphSemantic;

        public ReactiveIdentifierLoadAccessImpl(EntityPersister entityPersister) {
            this.entityPersister = entityPersister;
        }

        public ReactiveIdentifierLoadAccessImpl(String entityName) {
            this(reactiveSessionImpl.getFactory().getMappingMetamodel().getEntityDescriptor(entityName));
        }

        public ReactiveIdentifierLoadAccessImpl(Class<T> entityClass) {
            this(reactiveSessionImpl.getFactory().getMappingMetamodel().getEntityDescriptor(entityClass));
        }

        public final ReactiveIdentifierLoadAccessImpl<T> with(LockOptions lockOptions) {
            this.lockOptions = lockOptions;
            return this;
        }

        public ReactiveIdentifierLoadAccessImpl<T> with(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
            return this;
        }

        public ReactiveIdentifierLoadAccessImpl<T> with(RootGraph<T> graph, GraphSemantic semantic) {
            this.rootGraph = (RootGraphImplementor)graph;
            this.graphSemantic = semantic;
            return this;
        }

        public final CompletionStage<T> getReference(Object id) {
            return this.perform(() -> this.doGetReference(id));
        }

        protected CompletionStage<T> perform(Supplier<CompletionStage<T>> executor) {
            if (this.graphSemantic != null && this.rootGraph == null) {
                throw new IllegalArgumentException("Graph semantic specified, but no RootGraph was supplied");
            }
            CacheMode sessionCacheMode = ReactiveSessionImpl.this.getCacheMode();
            boolean cacheModeChanged = false;
            if (this.cacheMode != null && this.cacheMode != sessionCacheMode) {
                ReactiveSessionImpl.this.setCacheMode(this.cacheMode);
                cacheModeChanged = true;
            }
            if (this.graphSemantic != null) {
                ReactiveSessionImpl.this.getLoadQueryInfluencers().getEffectiveEntityGraph().applyGraph(this.rootGraph, this.graphSemantic);
            }
            boolean finalCacheModeChanged = cacheModeChanged;
            return executor.get().whenComplete((v, x) -> {
                if (this.graphSemantic != null) {
                    ReactiveSessionImpl.this.getLoadQueryInfluencers().getEffectiveEntityGraph().clear();
                }
                if (finalCacheModeChanged) {
                    ReactiveSessionImpl.this.setCacheMode(sessionCacheMode);
                }
            });
        }

        protected CompletionStage<T> doGetReference(Object id) {
            if (this.lockOptions != null) {
                LoadEvent event = new LoadEvent(id, this.entityPersister.getEntityName(), this.lockOptions, (EventSource)ReactiveSessionImpl.this, ReactiveSessionImpl.this.getReadOnlyFromLoadQueryInfluencers());
                return ReactiveSessionImpl.this.fireReactiveLoad(event, LoadEventListener.LOAD).thenApply(v -> event.getResult());
            }
            LoadEvent event = new LoadEvent(id, this.entityPersister.getEntityName(), false, (EventSource)ReactiveSessionImpl.this, ReactiveSessionImpl.this.getReadOnlyFromLoadQueryInfluencers());
            return ReactiveSessionImpl.this.fireReactiveLoad(event, LoadEventListener.LOAD).thenApply(v -> {
                if (event.getResult() == null) {
                    ReactiveSessionImpl.this.getFactory().getEntityNotFoundDelegate().handleEntityNotFound(this.entityPersister.getEntityName(), id);
                }
                return event.getResult();
            }).whenComplete((v, x) -> ReactiveSessionImpl.this.afterOperation(x != null));
        }

        public final CompletionStage<T> load(Object id) {
            return this.perform(() -> this.doLoad(id, LoadEventListener.GET));
        }

        protected final CompletionStage<T> doLoad(Object id, LoadEventListener.LoadType loadType) {
            if (id == null) {
                return CompletionStages.nullFuture();
            }
            if (this.lockOptions != null) {
                LoadEvent event = new LoadEvent(id, this.entityPersister.getEntityName(), this.lockOptions, (EventSource)ReactiveSessionImpl.this, ReactiveSessionImpl.this.getReadOnlyFromLoadQueryInfluencers());
                return ReactiveSessionImpl.this.fireReactiveLoad(event, loadType).thenApply(v -> event.getResult());
            }
            LoadEvent event = new LoadEvent(id, this.entityPersister.getEntityName(), false, (EventSource)ReactiveSessionImpl.this, ReactiveSessionImpl.this.getReadOnlyFromLoadQueryInfluencers());
            return ReactiveSessionImpl.this.fireReactiveLoad(event, loadType).whenComplete((v, t) -> ReactiveSessionImpl.this.afterOperation(t != null)).thenApply(v -> event.getResult());
        }
    }
}

