/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.mutation.internal.temptable;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.TableBasedDeleteHandler;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.query.sqm.mutation.internal.temptable.ReactiveRestrictedDeleteExecutionDelegate;
import org.hibernate.reactive.query.sqm.mutation.spi.ReactiveAbstractMutationHandler;

public class ReactiveTableBasedDeleteHandler
extends TableBasedDeleteHandler
implements ReactiveAbstractMutationHandler {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public ReactiveTableBasedDeleteHandler(SqmDeleteStatement<?> sqmDeleteStatement, DomainParameterXref domainParameterXref, TemporaryTable idTable, AfterUseAction afterUseAction, Function<SharedSessionContractImplementor, String> sessionUidAccess, SessionFactoryImplementor sessionFactory) {
        super(sqmDeleteStatement, domainParameterXref, idTable, afterUseAction, sessionUidAccess, sessionFactory);
    }

    @Override
    public CompletionStage<Integer> reactiveExecute(DomainQueryExecutionContext executionContext) {
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Starting multi-table delete execution - %s", this.getSqmDeleteOrUpdateStatement().getRoot().getModel().getName());
        }
        return this.resolveDelegate(executionContext).reactiveExecute(executionContext);
    }

    protected ReactiveExecutionDelegate resolveDelegate(DomainQueryExecutionContext executionContext) {
        return new ReactiveRestrictedDeleteExecutionDelegate(this.getEntityDescriptor(), this.getIdTable(), this.getAfterUseAction(), this.getSqmDeleteOrUpdateStatement(), this.getDomainParameterXref(), this.getSessionUidAccess(), executionContext.getQueryOptions(), executionContext.getSession().getLoadQueryInfluencers(), executionContext.getQueryParameterBindings(), this.getSessionFactory());
    }

    public static interface ReactiveExecutionDelegate
    extends TableBasedDeleteHandler.ExecutionDelegate {
        default public int execute(DomainQueryExecutionContext executionContext) {
            throw LOG.nonReactiveMethodCall("reactiveExecute");
        }

        public CompletionStage<Integer> reactiveExecute(DomainQueryExecutionContext var1);
    }
}

