/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.internal;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.TemporalType;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.query.BindableType;
import org.hibernate.query.Order;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.internal.DelegatingDomainQueryExecutionContext;
import org.hibernate.query.spi.AbstractSelectionQuery;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.SqlOmittingQueryOptions;
import org.hibernate.query.sqm.internal.SqmInterpretationsKey;
import org.hibernate.query.sqm.internal.SqmSelectionQueryImpl;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.reactive.query.spi.ReactiveAbstractSelectionQuery;
import org.hibernate.reactive.query.sqm.ReactiveSqmSelectionQuery;

public class ReactiveSqmSelectionQueryImpl<R>
extends SqmSelectionQueryImpl<R>
implements ReactiveSqmSelectionQuery<R> {
    private final ReactiveAbstractSelectionQuery<R> selectionQueryDelegate;

    public ReactiveSqmSelectionQueryImpl(String hql, HqlInterpretation hqlInterpretation, Class<R> expectedResultType, SharedSessionContractImplementor session) {
        super(hql, hqlInterpretation, expectedResultType, session);
        this.selectionQueryDelegate = this.createSelectionQueryDelegate(session);
    }

    public ReactiveSqmSelectionQueryImpl(SqmSelectStatement<R> criteria, Class<R> expectedResultType, SharedSessionContractImplementor session) {
        super(criteria, expectedResultType, session);
        this.selectionQueryDelegate = this.createSelectionQueryDelegate(session);
    }

    private ReactiveAbstractSelectionQuery<R> createSelectionQueryDelegate(SharedSessionContractImplementor session) {
        return new ReactiveAbstractSelectionQuery<Object>((SqmInterpretationsKey.InterpretationsKeySource)this, session, this::doReactiveList, () -> ((ReactiveSqmSelectionQueryImpl)this).getSqmStatement(), () -> ((ReactiveSqmSelectionQueryImpl)this).getTupleMetadata(), () -> ((ReactiveSqmSelectionQueryImpl)this).getDomainParameterXref(), () -> ((ReactiveSqmSelectionQueryImpl)this).getResultType(), () -> ((ReactiveSqmSelectionQueryImpl)this).getQueryString(), () -> ((ReactiveSqmSelectionQueryImpl)this).beforeQuery(), arg_0 -> ((ReactiveSqmSelectionQueryImpl)this).afterQuery(arg_0), AbstractSelectionQuery::uniqueElement);
    }

    private CompletionStage<List<R>> doReactiveList() {
        ReactiveSqmSelectionQueryImpl<R> executionContextToUse;
        boolean needsDistinct;
        this.getSession().prepareForQueryExecution(this.requiresTxn(this.getQueryOptions().getLockOptions().findGreatestLockMode()));
        SqmSelectStatement sqmStatement = this.getSqmStatement();
        boolean containsCollectionFetches = sqmStatement.containsCollectionFetches();
        boolean hasLimit = ReactiveSqmSelectionQueryImpl.hasLimit((SqmSelectStatement)sqmStatement, (MutableQueryOptions)this.getQueryOptions());
        boolean bl = needsDistinct = containsCollectionFetches && (sqmStatement.usesDistinct() || ReactiveSqmSelectionQueryImpl.hasAppliedGraph((MutableQueryOptions)this.getQueryOptions()) || hasLimit);
        if (hasLimit && containsCollectionFetches) {
            boolean fail = this.getSessionFactory().getSessionFactoryOptions().isFailOnPaginationOverCollectionFetchEnabled();
            if (fail) {
                throw new HibernateException("firstResult/maxResults specified with collection fetch. In memory pagination was about to be applied. Failing because 'Fail on pagination over collection fetch' is enabled.");
            }
            QueryLogging.QUERY_MESSAGE_LOGGER.firstOrMaxResultsSpecifiedWithCollectionFetch();
            MutableQueryOptions originalQueryOptions = this.getQueryOptions();
            final QueryOptions normalizedQueryOptions = SqlOmittingQueryOptions.omitSqlQueryOptions((QueryOptions)originalQueryOptions, (boolean)true, (boolean)false);
            executionContextToUse = originalQueryOptions == normalizedQueryOptions ? this : new DelegatingDomainQueryExecutionContext((DomainQueryExecutionContext)this){

                public QueryOptions getQueryOptions() {
                    return normalizedQueryOptions;
                }
            };
        } else {
            executionContextToUse = this;
        }
        return this.selectionQueryDelegate.resolveSelectReactiveQueryPlan().reactivePerformList((DomainQueryExecutionContext)executionContextToUse).thenApply(list -> needsDistinct ? this.applyDistinct((SqmSelectStatement<?>)sqmStatement, hasLimit, (List<R>)list) : list);
    }

    private List<R> applyDistinct(SqmSelectStatement<?> sqmStatement, boolean hasLimit, List<R> list) {
        int includedCount = -1;
        int first = !hasLimit || this.getQueryOptions().getLimit().getFirstRow() == null ? this.getIntegerLiteral(sqmStatement.getOffset(), 0) : this.getQueryOptions().getLimit().getFirstRow().intValue();
        int max = !hasLimit || this.getQueryOptions().getLimit().getMaxRows() == null ? this.getMaxRows(sqmStatement, list.size()) : this.getQueryOptions().getLimit().getMaxRows().intValue();
        ArrayList<R> tmp = new ArrayList<R>(list.size());
        IdentitySet distinction = new IdentitySet(list.size());
        for (R result : list) {
            if (!distinction.add(result) || ++includedCount < first) continue;
            tmp.add(result);
            if (max < 0 || includedCount - first < max - 1) continue;
            break;
        }
        return tmp;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setFlushMode(FlushModeType flushMode) {
        super.setFlushMode(flushMode);
        return this;
    }

    @Override
    public CompletionStage<R> getReactiveSingleResult() {
        return this.selectionQueryDelegate.getReactiveSingleResult();
    }

    @Override
    public CompletionStage<List<R>> reactiveList() {
        return this.selectionQueryDelegate.reactiveList();
    }

    @Override
    public CompletionStage<R> getReactiveSingleResultOrNull() {
        return this.selectionQueryDelegate.getReactiveSingleResultOrNull();
    }

    @Override
    public CompletionStage<R> reactiveUnique() {
        return this.selectionQueryDelegate.reactiveUnique();
    }

    @Override
    public CompletionStage<Optional<R>> reactiveUniqueResultOptional() {
        return this.selectionQueryDelegate.reactiveUniqueResultOptional();
    }

    public R getSingleResult() {
        return this.selectionQueryDelegate.getSingleResult();
    }

    public R getSingleResultOrNull() {
        return this.selectionQueryDelegate.getSingleResultOrNull();
    }

    public List<R> getResultList() {
        return this.selectionQueryDelegate.getResultList();
    }

    public Stream<R> getResultStream() {
        return this.selectionQueryDelegate.getResultStream();
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setLockMode(LockModeType lockMode) {
        super.setLockMode(lockMode);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setHibernateLockMode(LockMode lockMode) {
        super.setHibernateLockMode(lockMode);
        return this;
    }

    @Override
    @Deprecated
    public ReactiveSqmSelectionQueryImpl<R> setAliasSpecificLockMode(String alias, LockMode lockMode) {
        super.setAliasSpecificLockMode(alias, lockMode);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setLockMode(String alias, LockMode lockMode) {
        super.setLockMode(alias, lockMode);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setFollowOnLocking(boolean enable) {
        super.setFollowOnLocking(enable);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setOrder(List<Order<? super R>> orders) {
        super.setOrder(orders);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setOrder(Order<? super R> order) {
        super.setOrder(order);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setCacheMode(CacheMode cacheMode) {
        super.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        super.setCacheRetrieveMode(cacheRetrieveMode);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        super.setCacheStoreMode(cacheStoreMode);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setCacheable(boolean cacheable) {
        super.setCacheable(cacheable);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setCacheRegion(String regionName) {
        super.setCacheRegion(regionName);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setHibernateFlushMode(FlushMode flushMode) {
        super.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setTimeout(int timeout) {
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setMaxResults(int maxResult) {
        super.setMaxResults(maxResult);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setFirstResult(int startPosition) {
        super.setFirstResult(startPosition);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setHint(String hintName, Object value) {
        super.setHint(hintName, value);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameter(String name, P value, Class<P> javaType) {
        super.setParameter(name, value, javaType);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameter(String name, P value, BindableType<P> type) {
        super.setParameter(name, value, type);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setParameter(String name, Instant value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameter(int position, P value, Class<P> javaType) {
        super.setParameter(position, value, javaType);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameter(int position, P value, BindableType<P> type) {
        super.setParameter(position, value, type);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setParameter(int position, Instant value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameter(QueryParameter<P> parameter, P value) {
        super.setParameter(parameter, value);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameter(QueryParameter<P> parameter, P value, Class<P> javaType) {
        super.setParameter(parameter, value, javaType);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameter(QueryParameter<P> parameter, P value, BindableType<P> type) {
        super.setParameter(parameter, value, type);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameter(Parameter<P> parameter, P value) {
        super.setParameter(parameter, value);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        super.setParameter(param, value, temporalType);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        super.setParameter(param, value, temporalType);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setParameter(String name, Date value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setParameter(int position, Date value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setParameterList(String name, Collection values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameterList(String name, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(name, values, javaType);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameterList(String name, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(name, values, type);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setParameterList(String name, Object[] values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameterList(String name, P[] values, Class<P> javaType) {
        super.setParameterList(name, (Object[])values, javaType);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameterList(String name, P[] values, BindableType<P> type) {
        super.setParameterList(name, (Object[])values, type);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setParameterList(int position, Collection values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameterList(int position, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(position, values, javaType);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameterList(int position, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(position, values, type);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setParameterList(int position, Object[] values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameterList(int position, P[] values, Class<P> javaType) {
        super.setParameterList(position, (Object[])values, javaType);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameterList(int position, P[] values, BindableType<P> type) {
        super.setParameterList(position, (Object[])values, type);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values) {
        super.setParameterList(parameter, values);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(parameter, values, javaType);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(parameter, values, type);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameterList(QueryParameter<P> parameter, P[] values) {
        super.setParameterList(parameter, (Object[])values);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameterList(QueryParameter<P> parameter, P[] values, Class<P> javaType) {
        super.setParameterList(parameter, (Object[])values, javaType);
        return this;
    }

    @Override
    public <P> ReactiveSqmSelectionQueryImpl<R> setParameterList(QueryParameter<P> parameter, P[] values, BindableType<P> type) {
        super.setParameterList(parameter, (Object[])values, type);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setProperties(Map map) {
        super.setProperties(map);
        return this;
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> setProperties(Object bean) {
        super.setProperties(bean);
        return this;
    }

    @Override
    public void applyGraph(RootGraphImplementor<?> graph, GraphSemantic semantic) {
        this.getQueryOptions().applyGraph(graph, semantic);
    }

    @Override
    public ReactiveSqmSelectionQueryImpl<R> enableFetchProfile(String profileName) {
        this.selectionQueryDelegate.enableFetchProfile(profileName);
        return this;
    }
}

