/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.reactive.query.sql.spi.ReactiveNonSelectQueryPlan;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveJdbcMutationExecutor;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQueryInsert;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;

public class ReactiveSimpleInsertQueryPlan
implements ReactiveNonSelectQueryPlan {
    private final SqmInsertStatement<?> sqmInsert;
    private final DomainParameterXref domainParameterXref;
    private Map<SqmParameter<?>, MappingModelExpressible<?>> paramTypeResolutions;
    private JdbcOperationQueryInsert jdbcInsert;
    private FromClauseAccess tableGroupAccess;
    private Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref;

    public ReactiveSimpleInsertQueryPlan(SqmInsertStatement<?> sqmInsert, DomainParameterXref domainParameterXref) {
        this.sqmInsert = sqmInsert;
        this.domainParameterXref = domainParameterXref;
    }

    @Override
    public CompletionStage<Integer> executeReactiveUpdate(DomainQueryExecutionContext executionContext) {
        BulkOperationCleanupAction.schedule((SharedSessionContractImplementor)executionContext.getSession(), this.sqmInsert);
        SharedSessionContractImplementor session = executionContext.getSession();
        SqlAstTranslator<JdbcOperationQueryInsert> insertTranslator = null;
        if (this.jdbcInsert == null) {
            insertTranslator = this.createInsertTranslator(executionContext);
        }
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings((QueryParameterBindings)executionContext.getQueryParameterBindings(), (DomainParameterXref)this.domainParameterXref, this.jdbcParamsXref, (MappingMetamodel)session.getFactory().getRuntimeMetamodels().getMappingMetamodel(), arg_0 -> ((FromClauseAccess)this.tableGroupAccess).findTableGroup(arg_0), (SqmParameterMappingModelResolutionAccess)new SqmParameterMappingModelResolutionAccess(){

            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return ReactiveSimpleInsertQueryPlan.this.paramTypeResolutions.get(parameter);
            }
        }, (SharedSessionContractImplementor)session);
        if (this.jdbcInsert != null && !this.jdbcInsert.isCompatibleWith(jdbcParameterBindings, executionContext.getQueryOptions())) {
            insertTranslator = this.createInsertTranslator(executionContext);
        }
        if (insertTranslator != null) {
            this.jdbcInsert = (JdbcOperationQueryInsert)insertTranslator.translate(jdbcParameterBindings, executionContext.getQueryOptions());
        }
        return StandardReactiveJdbcMutationExecutor.INSTANCE.executeReactive((JdbcOperationQueryMutation)this.jdbcInsert, jdbcParameterBindings, arg_0 -> ((StatementPreparer)session.getJdbcCoordinator().getStatementPreparer()).prepareStatement(arg_0), (i, ps) -> {}, (ExecutionContext)SqmJdbcExecutionContextAdapter.omittingLockingAndPaging((DomainQueryExecutionContext)executionContext));
    }

    private SqlAstTranslator<JdbcOperationQueryInsert> createInsertTranslator(DomainQueryExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        QueryEngine queryEngine = factory.getQueryEngine();
        SqmTranslatorFactory translatorFactory = queryEngine.getSqmTranslatorFactory();
        SqmTranslator translator = translatorFactory.createInsertTranslator(this.sqmInsert, executionContext.getQueryOptions(), this.domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getSession().getLoadQueryInfluencers(), (SqlAstCreationContext)factory);
        SqmTranslation sqmInterpretation = translator.translate();
        this.tableGroupAccess = sqmInterpretation.getFromClauseAccess();
        this.jdbcParamsXref = SqmUtil.generateJdbcParamsXref((DomainParameterXref)this.domainParameterXref, () -> ((SqmTranslation)sqmInterpretation).getJdbcParamsBySqmParam());
        this.paramTypeResolutions = sqmInterpretation.getSqmParameterMappingModelTypeResolutions();
        return factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildInsertTranslator(factory, (InsertStatement)sqmInterpretation.getSqlAst());
    }
}

