/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.internal;

import java.sql.PreparedStatement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SoftDeleteMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SimpleDeleteQueryPlan;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.reactive.query.sql.spi.ReactiveNonSelectQueryPlan;
import org.hibernate.reactive.query.sqm.mutation.internal.ReactiveSqmMutationStrategyHelper;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveJdbcMutationExecutor;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.AbstractUpdateOrDeleteStatement;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.from.MutatingTableReferenceGroupWrapper;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public class ReactiveSimpleDeleteQueryPlan
extends SimpleDeleteQueryPlan
implements ReactiveNonSelectQueryPlan {
    private final EntityMappingType entityDescriptor;
    private final SqmDeleteStatement<?> sqmDelete;
    private final DomainParameterXref domainParameterXref;
    private JdbcOperationQueryMutation jdbcOperation;
    private SqmTranslation<? extends AbstractUpdateOrDeleteStatement> sqmInterpretation;
    private Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref;

    public ReactiveSimpleDeleteQueryPlan(EntityMappingType entityDescriptor, SqmDeleteStatement<?> sqmDelete, DomainParameterXref domainParameterXref) {
        super(entityDescriptor, sqmDelete, domainParameterXref);
        this.entityDescriptor = entityDescriptor;
        this.sqmDelete = sqmDelete;
        this.domainParameterXref = domainParameterXref;
    }

    protected SqlAstTranslator<? extends JdbcOperationQueryMutation> createTranslator(DomainQueryExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        SqmTranslator translator = factory.getQueryEngine().getSqmTranslatorFactory().createMutationTranslator(this.sqmDelete, executionContext.getQueryOptions(), this.domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getSession().getLoadQueryInfluencers(), (SqlAstCreationContext)factory);
        this.sqmInterpretation = translator.translate();
        this.jdbcParamsXref = SqmUtil.generateJdbcParamsXref((DomainParameterXref)this.domainParameterXref, () -> this.sqmInterpretation.getJdbcParamsBySqmParam());
        return factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildMutationTranslator(factory, this.mutationStatement());
    }

    private MutationStatement mutationStatement() {
        if (this.entityDescriptor.getSoftDeleteMapping() == null) {
            return (MutationStatement)this.sqmInterpretation.getSqlAst();
        }
        AbstractUpdateOrDeleteStatement sqlDeleteAst = (AbstractUpdateOrDeleteStatement)this.sqmInterpretation.getSqlAst();
        NamedTableReference targetTable = sqlDeleteAst.getTargetTable();
        SoftDeleteMapping columnMapping = this.getEntityDescriptor().getSoftDeleteMapping();
        ColumnReference columnReference = new ColumnReference((TableReference)targetTable, (SelectableMapping)columnMapping);
        JdbcLiteral jdbcLiteral = new JdbcLiteral(columnMapping.getDeletedLiteralValue(), columnMapping.getJdbcMapping());
        Assignment assignment = new Assignment((Assignable)columnReference, (Expression)jdbcLiteral);
        return new UpdateStatement(targetTable, Collections.singletonList(assignment), sqlDeleteAst.getRestriction());
    }

    @Override
    public CompletionStage<Integer> executeReactiveUpdate(DomainQueryExecutionContext executionContext) {
        boolean missingRestriction;
        BulkOperationCleanupAction.schedule((SharedSessionContractImplementor)executionContext.getSession(), this.sqmDelete);
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        SqlAstTranslator<? extends JdbcOperationQueryMutation> sqlAstTranslator = null;
        if (this.jdbcOperation == null) {
            sqlAstTranslator = this.createTranslator(executionContext);
        }
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings((QueryParameterBindings)executionContext.getQueryParameterBindings(), (DomainParameterXref)this.domainParameterXref, this.jdbcParamsXref, (MappingMetamodel)factory.getRuntimeMetamodels().getMappingMetamodel(), arg_0 -> ((FromClauseAccess)this.sqmInterpretation.getFromClauseAccess()).findTableGroup(arg_0), (SqmParameterMappingModelResolutionAccess)new SqmParameterMappingModelResolutionAccess(){

            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return (MappingModelExpressible)ReactiveSimpleDeleteQueryPlan.this.sqmInterpretation.getSqmParameterMappingModelTypeResolutions().get(parameter);
            }
        }, (SharedSessionContractImplementor)session);
        if (this.jdbcOperation != null && !this.jdbcOperation.isCompatibleWith(jdbcParameterBindings, executionContext.getQueryOptions())) {
            sqlAstTranslator = this.createTranslator(executionContext);
        }
        if (sqlAstTranslator != null) {
            this.jdbcOperation = (JdbcOperationQueryMutation)sqlAstTranslator.translate(jdbcParameterBindings, executionContext.getQueryOptions());
        }
        boolean bl = missingRestriction = this.sqmDelete.getWhereClause() == null || this.sqmDelete.getWhereClause().getPredicate() == null;
        if (missingRestriction) {
            assert (this.domainParameterXref.getSqmParameterCount() == 0);
            assert (this.jdbcParamsXref.isEmpty());
        }
        SqmJdbcExecutionContextAdapter executionContextAdapter = SqmJdbcExecutionContextAdapter.usingLockingAndPaging((DomainQueryExecutionContext)executionContext);
        return ReactiveSqmMutationStrategyHelper.cleanUpCollectionTables(this.entityDescriptor, (tableReference, attributeMapping) -> {
            if (missingRestriction) {
                return null;
            }
            ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
            Expression fkColumnExpression = MappingModelCreationHelper.buildColumnReferenceExpression((TableGroup)new MutatingTableReferenceGroupWrapper(new NavigablePath(attributeMapping.getRootPathName()), (ModelPartContainer)attributeMapping, (NamedTableReference)tableReference), (ModelPart)fkDescriptor.getKeyPart(), null, (SessionFactoryImplementor)factory);
            QuerySpec matchingIdSubQuery = new QuerySpec(false);
            MutatingTableReferenceGroupWrapper tableGroup = new MutatingTableReferenceGroupWrapper(new NavigablePath(attributeMapping.getRootPathName()), (ModelPartContainer)attributeMapping, ((AbstractUpdateOrDeleteStatement)this.sqmInterpretation.getSqlAst()).getTargetTable());
            Expression fkTargetColumnExpression = MappingModelCreationHelper.buildColumnReferenceExpression((TableGroup)tableGroup, (ModelPart)fkDescriptor.getTargetPart(), (SqlExpressionResolver)this.sqmInterpretation.getSqlExpressionResolver(), (SessionFactoryImplementor)factory);
            matchingIdSubQuery.getSelectClause().addSqlSelection((SqlSelection)new SqlSelectionImpl(0, fkTargetColumnExpression));
            matchingIdSubQuery.getFromClause().addRoot((TableGroup)tableGroup);
            matchingIdSubQuery.applyPredicate(((AbstractUpdateOrDeleteStatement)this.sqmInterpretation.getSqlAst()).getRestriction());
            return new InSubQueryPredicate(fkColumnExpression, (QueryPart)matchingIdSubQuery, false);
        }, missingRestriction ? JdbcParameterBindings.NO_BINDINGS : jdbcParameterBindings, (ExecutionContext)executionContextAdapter).thenCompose(unused -> StandardReactiveJdbcMutationExecutor.INSTANCE.executeReactive(this.jdbcOperation, jdbcParameterBindings, arg_0 -> ((StatementPreparer)session.getJdbcCoordinator().getStatementPreparer()).prepareStatement(arg_0), ReactiveSimpleDeleteQueryPlan::doNothing, (ExecutionContext)executionContextAdapter));
    }

    private static void doNothing(Integer i, PreparedStatement ps) {
    }
}

