/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.internal;

import java.util.concurrent.CompletionStage;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.reactive.query.sql.spi.ReactiveNonSelectQueryPlan;
import org.hibernate.reactive.query.sqm.mutation.spi.ReactiveSqmMultiTableInsertStrategy;

public class ReactiveMultiTableInsertQueryPlan
implements ReactiveNonSelectQueryPlan {
    private final SqmInsertStatement<?> sqmInsert;
    private final DomainParameterXref domainParameterXref;
    private final ReactiveSqmMultiTableInsertStrategy mutationStrategy;

    public ReactiveMultiTableInsertQueryPlan(SqmInsertStatement<?> sqmInsert, DomainParameterXref domainParameterXref, ReactiveSqmMultiTableInsertStrategy mutationStrategy) {
        this.sqmInsert = sqmInsert;
        this.domainParameterXref = domainParameterXref;
        this.mutationStrategy = mutationStrategy;
    }

    @Override
    public CompletionStage<Integer> executeReactiveUpdate(DomainQueryExecutionContext executionContext) {
        BulkOperationCleanupAction.schedule((SharedSessionContractImplementor)executionContext.getSession(), this.sqmInsert);
        return this.mutationStrategy.reactiveExecuteInsert(this.sqmInsert, this.domainParameterXref, executionContext);
    }
}

