/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.hibernate.ScrollMode;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.sqm.internal.ConcreteSqmSelectQueryPlan;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.reactive.engine.spi.ReactiveSharedSessionContractImplementor;
import org.hibernate.reactive.query.sqm.spi.ReactiveSelectQueryPlan;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveSelectExecutor;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.TupleMetadata;
import org.hibernate.sql.results.spi.RowTransformer;

public class ConcreteSqmSelectReactiveQueryPlan<R>
extends ConcreteSqmSelectQueryPlan<R>
implements ReactiveSelectQueryPlan<R> {
    private final SqmInterpreter<List<R>, Void> listInterpreter;
    private final RowTransformer<R> rowTransformer;
    private final SqmSelectStatement<?> sqm;
    private final DomainParameterXref domainParameterXref;
    private volatile CacheableSqmInterpretation cacheableSqmInterpretation;

    public ConcreteSqmSelectReactiveQueryPlan(SqmSelectStatement<?> sqm, String hql, DomainParameterXref domainParameterXref, Class<R> resultType, TupleMetadata tupleMetadata, QueryOptions queryOptions) {
        super(sqm, hql, domainParameterXref, resultType, tupleMetadata, queryOptions);
        this.sqm = sqm;
        this.domainParameterXref = domainParameterXref;
        this.rowTransformer = ConcreteSqmSelectReactiveQueryPlan.determineRowTransformer(sqm, resultType, (TupleMetadata)tupleMetadata, (QueryOptions)queryOptions);
        this.listInterpreter = (unused, executionContext, sqmInterpretation, jdbcParameterBindings) -> ConcreteSqmSelectReactiveQueryPlan.listInterpreter(hql, domainParameterXref, executionContext, sqmInterpretation, jdbcParameterBindings, this.rowTransformer);
    }

    private static <R> CompletionStage<List<R>> listInterpreter(String hql, DomainParameterXref domainParameterXref, DomainQueryExecutionContext executionContext, CacheableSqmInterpretation sqmInterpretation, JdbcParameterBindings jdbcParameterBindings, RowTransformer<R> rowTransformer) {
        ReactiveSharedSessionContractImplementor session = (ReactiveSharedSessionContractImplementor)executionContext.getSession();
        JdbcOperationQuerySelect jdbcSelect = sqmInterpretation.getJdbcSelect();
        Supplier<SubselectFetch.RegistrationHandler> fetchHandlerSupplier = () -> SubselectFetch.createRegistrationHandler((BatchFetchQueue)session.getPersistenceContext().getBatchFetchQueue(), (SelectStatement)sqmInterpretation.selectStatement, (JdbcParametersList)JdbcParametersList.empty(), (JdbcParameterBindings)jdbcParameterBindings);
        return CompletionStages.completedFuture(fetchHandlerSupplier).thenApply(Supplier::get).thenCompose(subSelectFetchKeyHandler -> session.reactiveAutoFlushIfRequired(jdbcSelect.getAffectedTableNames()).thenCompose(required -> StandardReactiveSelectExecutor.INSTANCE.list(jdbcSelect, jdbcParameterBindings, (ExecutionContext)ConcreteSqmSelectQueryPlan.listInterpreterExecutionContext((String)hql, (DomainQueryExecutionContext)executionContext, (JdbcOperationQuerySelect)jdbcSelect, (SubselectFetch.RegistrationHandler)subSelectFetchKeyHandler), rowTransformer, ReactiveListResultsConsumer.UniqueSemantic.ALLOW))).whenComplete((rs, t) -> domainParameterXref.clearExpansions());
    }

    @Override
    public ScrollableResultsImplementor<R> performScroll(ScrollMode scrollMode, DomainQueryExecutionContext executionContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<List<R>> reactivePerformList(DomainQueryExecutionContext executionContext) {
        return executionContext.getQueryOptions().getEffectiveLimit().getMaxRowsJpa() == 0 ? CompletionStages.completedFuture(Collections.emptyList()) : this.withCacheableSqmInterpretation(executionContext, this.listInterpreter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, X> CompletionStage<T> withCacheableSqmInterpretation(DomainQueryExecutionContext executionContext, SqmInterpreter<T, X> interpreter) {
        CacheableSqmInterpretation localCopy = this.cacheableSqmInterpretation;
        JdbcParameterBindings jdbcParameterBindings = null;
        if (localCopy == null) {
            ConcreteSqmSelectReactiveQueryPlan concreteSqmSelectReactiveQueryPlan = this;
            synchronized (concreteSqmSelectReactiveQueryPlan) {
                localCopy = this.cacheableSqmInterpretation;
                if (localCopy == null) {
                    localCopy = ConcreteSqmSelectReactiveQueryPlan.buildCacheableSqmInterpretation(this.sqm, this.domainParameterXref, executionContext);
                    jdbcParameterBindings = localCopy.firstParameterBindings;
                    localCopy.firstParameterBindings = null;
                    this.cacheableSqmInterpretation = localCopy;
                }
            }
        } else {
            if (localCopy.jdbcSelect.dependsOnParameterBindings()) {
                jdbcParameterBindings = this.createJdbcParameterBindings(localCopy, executionContext);
            }
            if (!localCopy.jdbcSelect.isCompatibleWith(jdbcParameterBindings, executionContext.getQueryOptions())) {
                localCopy = ConcreteSqmSelectReactiveQueryPlan.buildCacheableSqmInterpretation(this.sqm, this.domainParameterXref, executionContext);
                jdbcParameterBindings = localCopy.firstParameterBindings;
                localCopy.firstParameterBindings = null;
                this.cacheableSqmInterpretation = localCopy;
            }
        }
        if (jdbcParameterBindings == null) {
            jdbcParameterBindings = this.createJdbcParameterBindings(localCopy, executionContext);
        }
        return interpreter.interpret(null, executionContext, localCopy, jdbcParameterBindings);
    }

    private JdbcParameterBindings createJdbcParameterBindings(final CacheableSqmInterpretation sqmInterpretation, DomainQueryExecutionContext executionContext) {
        SharedSessionContractImplementor session = executionContext.getSession();
        return SqmUtil.createJdbcParameterBindings((QueryParameterBindings)executionContext.getQueryParameterBindings(), (DomainParameterXref)this.domainParameterXref, sqmInterpretation.getJdbcParamsXref(), (MappingMetamodel)session.getFactory().getRuntimeMetamodels().getMappingMetamodel(), arg_0 -> ((FromClauseAccess)sqmInterpretation.getTableGroupAccess()).findTableGroup(arg_0), (SqmParameterMappingModelResolutionAccess)new SqmParameterMappingModelResolutionAccess(){

            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return sqmInterpretation.getSqmParameterMappingModelTypes().get(parameter);
            }
        }, (SharedSessionContractImplementor)session);
    }

    private static CacheableSqmInterpretation buildCacheableSqmInterpretation(SqmSelectStatement<?> sqm, DomainParameterXref domainParameterXref, DomainQueryExecutionContext executionContext) {
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor sessionFactory = session.getFactory();
        QueryEngine queryEngine = sessionFactory.getQueryEngine();
        SqmTranslatorFactory sqmTranslatorFactory = queryEngine.getSqmTranslatorFactory();
        SqmTranslator sqmConverter = sqmTranslatorFactory.createSelectTranslator(sqm, executionContext.getQueryOptions(), domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getSession().getLoadQueryInfluencers(), (SqlAstCreationContext)sessionFactory, true);
        final SqmTranslation sqmInterpretation = sqmConverter.translate();
        FromClauseAccess tableGroupAccess = sqmConverter.getFromClauseAccess();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        SqlAstTranslator selectTranslator = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, (SelectStatement)sqmInterpretation.getSqlAst());
        Map jdbcParamsXref = SqmUtil.generateJdbcParamsXref((DomainParameterXref)domainParameterXref, () -> ((SqmTranslation)sqmInterpretation).getJdbcParamsBySqmParam());
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings((QueryParameterBindings)executionContext.getQueryParameterBindings(), (DomainParameterXref)domainParameterXref, (Map)jdbcParamsXref, (MappingMetamodel)session.getFactory().getRuntimeMetamodels().getMappingMetamodel(), arg_0 -> ((FromClauseAccess)tableGroupAccess).findTableGroup(arg_0), (SqmParameterMappingModelResolutionAccess)new SqmParameterMappingModelResolutionAccess(){

            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return (MappingModelExpressible)sqmInterpretation.getSqmParameterMappingModelTypeResolutions().get(parameter);
            }
        }, (SharedSessionContractImplementor)session);
        JdbcOperationQuerySelect jdbcSelect = (JdbcOperationQuerySelect)selectTranslator.translate(jdbcParameterBindings, executionContext.getQueryOptions());
        return new CacheableSqmInterpretation((SelectStatement)sqmInterpretation.getSqlAst(), jdbcSelect, tableGroupAccess, jdbcParamsXref, sqmInterpretation.getSqmParameterMappingModelTypeResolutions(), jdbcParameterBindings);
    }

    private static class CacheableSqmInterpretation {
        private final SelectStatement selectStatement;
        private final JdbcOperationQuerySelect jdbcSelect;
        private final FromClauseAccess tableGroupAccess;
        private final Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref;
        private final Map<SqmParameter<?>, MappingModelExpressible<?>> sqmParameterMappingModelTypes;
        private transient JdbcParameterBindings firstParameterBindings;

        CacheableSqmInterpretation(SelectStatement selectStatement, JdbcOperationQuerySelect jdbcSelect, FromClauseAccess tableGroupAccess, Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref, Map<SqmParameter<?>, MappingModelExpressible<?>> sqmParameterMappingModelTypes, JdbcParameterBindings firstParameterBindings) {
            this.selectStatement = selectStatement;
            this.jdbcSelect = jdbcSelect;
            this.tableGroupAccess = tableGroupAccess;
            this.jdbcParamsXref = jdbcParamsXref;
            this.sqmParameterMappingModelTypes = sqmParameterMappingModelTypes;
            this.firstParameterBindings = firstParameterBindings;
        }

        SelectStatement getSelectStatement() {
            return this.selectStatement;
        }

        JdbcOperationQuerySelect getJdbcSelect() {
            return this.jdbcSelect;
        }

        FromClauseAccess getTableGroupAccess() {
            return this.tableGroupAccess;
        }

        Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> getJdbcParamsXref() {
            return this.jdbcParamsXref;
        }

        public Map<SqmParameter<?>, MappingModelExpressible<?>> getSqmParameterMappingModelTypes() {
            return this.sqmParameterMappingModelTypes;
        }
    }

    private static interface SqmInterpreter<T, X> {
        public CompletionStage<T> interpret(X var1, DomainQueryExecutionContext var2, CacheableSqmInterpretation var3, JdbcParameterBindings var4);
    }
}

