/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.internal;

import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;
import org.hibernate.query.sqm.spi.NamedSqmQueryMemento;
import org.hibernate.reactive.query.sql.spi.ReactiveNamedNativeQueryMemento;
import org.hibernate.reactive.query.sql.spi.ReactiveNamedSqmQueryMemento;

public class ReactiveNamedObjectRepositoryImpl
implements NamedObjectRepository {
    private final NamedObjectRepository delegate;

    public ReactiveNamedObjectRepositoryImpl(NamedObjectRepository delegate) {
        this.delegate = delegate;
    }

    public NamedSqmQueryMemento getSqmQueryMemento(String queryName) {
        return ReactiveNamedObjectRepositoryImpl.wrapSqmQueryMemento(this.delegate.getSqmQueryMemento(queryName));
    }

    public void visitSqmQueryMementos(Consumer<NamedSqmQueryMemento> action) {
        this.delegate.visitSqmQueryMementos(action);
    }

    public void registerSqmQueryMemento(String name, NamedSqmQueryMemento descriptor) {
        this.delegate.registerSqmQueryMemento(name, descriptor);
    }

    public NamedNativeQueryMemento getNativeQueryMemento(String queryName) {
        return ReactiveNamedObjectRepositoryImpl.wrapNativeQueryMemento(this.delegate.getNativeQueryMemento(queryName));
    }

    public void visitNativeQueryMementos(Consumer<NamedNativeQueryMemento> action) {
        this.delegate.visitNativeQueryMementos(action);
    }

    public void registerNativeQueryMemento(String name, NamedNativeQueryMemento descriptor) {
        this.delegate.registerNativeQueryMemento(name, descriptor);
    }

    public NamedCallableQueryMemento getCallableQueryMemento(String name) {
        return this.delegate.getCallableQueryMemento(name);
    }

    public void visitCallableQueryMementos(Consumer<NamedCallableQueryMemento> action) {
        this.delegate.visitCallableQueryMementos(action);
    }

    public void registerCallableQueryMemento(String name, NamedCallableQueryMemento memento) {
        this.delegate.registerCallableQueryMemento(name, memento);
    }

    public NamedResultSetMappingMemento getResultSetMappingMemento(String mappingName) {
        return this.delegate.getResultSetMappingMemento(mappingName);
    }

    public void visitResultSetMappingMementos(Consumer<NamedResultSetMappingMemento> action) {
        this.delegate.visitResultSetMappingMementos(action);
    }

    public void registerResultSetMappingMemento(String name, NamedResultSetMappingMemento memento) {
        this.delegate.registerResultSetMappingMemento(name, memento);
    }

    public Map<String, HibernateException> checkNamedQueries(QueryEngine queryPlanCache) {
        return this.delegate.checkNamedQueries(queryPlanCache);
    }

    public void validateNamedQueries(QueryEngine queryEngine) {
        this.delegate.validateNamedQueries(queryEngine);
    }

    public NamedQueryMemento resolve(SessionFactoryImplementor sessionFactory, MetadataImplementor bootMetamodel, String registrationName) {
        return ReactiveNamedObjectRepositoryImpl.wrap(this.delegate.resolve(sessionFactory, bootMetamodel, registrationName));
    }

    public void prepare(SessionFactoryImplementor sessionFactory, Metadata bootMetamodel) {
        this.delegate.prepare(sessionFactory, bootMetamodel);
    }

    public void close() {
        this.delegate.close();
    }

    private static NamedQueryMemento wrap(NamedQueryMemento namedQueryMemento) {
        if (namedQueryMemento == null) {
            return null;
        }
        if (namedQueryMemento instanceof NamedSqmQueryMemento) {
            return ReactiveNamedObjectRepositoryImpl.wrapSqmQueryMemento((NamedSqmQueryMemento)namedQueryMemento);
        }
        return ReactiveNamedObjectRepositoryImpl.wrapNativeQueryMemento((NamedNativeQueryMemento)namedQueryMemento);
    }

    private static NamedSqmQueryMemento wrapSqmQueryMemento(NamedSqmQueryMemento sqmQueryMemento) {
        if (sqmQueryMemento == null) {
            return null;
        }
        if (sqmQueryMemento instanceof ReactiveNamedSqmQueryMemento) {
            return sqmQueryMemento;
        }
        return new ReactiveNamedSqmQueryMemento(sqmQueryMemento);
    }

    private static NamedNativeQueryMemento wrapNativeQueryMemento(NamedNativeQueryMemento nativeQueryMemento) {
        if (nativeQueryMemento == null) {
            return null;
        }
        if (nativeQueryMemento instanceof ReactiveNamedNativeQueryMemento) {
            return nativeQueryMemento;
        }
        return new ReactiveNamedNativeQueryMemento(nativeQueryMemento);
    }
}

