/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.provider.service;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.dialect.CockroachDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectDelegateWrapper;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.sql.ast.internal.ParameterMarkerStrategyStandard;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class NativeParametersHandling
implements StandardServiceInitiator<ParameterMarkerStrategy> {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    public static final NativeParametersHandling INSTANCE = new NativeParametersHandling();

    public ParameterMarkerStrategy initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        Dialect dialect = ((JdbcServices)registry.getService(JdbcServices.class)).getDialect();
        Dialect realDialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect);
        ParameterMarkerStrategy renderer = this.recommendRendered(realDialect);
        LOG.debugf("Initializing service JdbcParameterRenderer with implementation: %s", renderer.getClass());
        return renderer;
    }

    private ParameterMarkerStrategy recommendRendered(Dialect realDialect) {
        if (realDialect instanceof PostgreSQLDialect || realDialect instanceof CockroachDialect) {
            return new PostgreSQLNativeParameterMarkers();
        }
        if (realDialect instanceof SQLServerDialect) {
            return new SqlServerNativeParameterMarkers();
        }
        return realDialect.getNativeParameterMarkerStrategy() == null ? ParameterMarkerStrategyStandard.INSTANCE : realDialect.getNativeParameterMarkerStrategy();
    }

    public Class<ParameterMarkerStrategy> getServiceInitiated() {
        return ParameterMarkerStrategy.class;
    }

    private static class SqlServerNativeParameterMarkers
    implements ParameterMarkerStrategy {
        private SqlServerNativeParameterMarkers() {
        }

        public String createMarker(int position, JdbcType jdbcType) {
            return "@P" + position;
        }
    }

    private static class PostgreSQLNativeParameterMarkers
    implements ParameterMarkerStrategy {
        private PostgreSQLNativeParameterMarkers() {
        }

        public String createMarker(int position, JdbcType jdbcType) {
            return "$" + position;
        }
    }
}

