/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.pool.impl;

import io.vertx.core.Future;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.SqlConnection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.pool.ReactiveConnectionPool;
import org.hibernate.reactive.pool.impl.SqlClientConnection;

public abstract class SqlClientPool
implements ReactiveConnectionPool {
    protected abstract Pool getPool();

    protected abstract SqlStatementLogger getSqlStatementLogger();

    protected abstract SqlExceptionHelper getSqlExceptionHelper();

    protected Pool getTenantPool(String tenantId) {
        throw new UnsupportedOperationException("multitenancy not supported by built-in SqlClientPool");
    }

    @Override
    public CompletionStage<ReactiveConnection> getConnection() {
        return this.getConnectionFromPool(this.getPool());
    }

    @Override
    public CompletionStage<ReactiveConnection> getConnection(SqlExceptionHelper sqlExceptionHelper) {
        return this.getConnectionFromPool(this.getPool(), sqlExceptionHelper);
    }

    @Override
    public CompletionStage<ReactiveConnection> getConnection(String tenantId) {
        return this.getConnectionFromPool(this.getTenantPool(tenantId));
    }

    @Override
    public CompletionStage<ReactiveConnection> getConnection(String tenantId, SqlExceptionHelper sqlExceptionHelper) {
        return this.getConnectionFromPool(this.getTenantPool(tenantId), sqlExceptionHelper);
    }

    private CompletionStage<ReactiveConnection> getConnectionFromPool(Pool pool) {
        return this.completionStage(pool.getConnection().map(this::newConnection), ReactiveConnection::close);
    }

    private CompletionStage<ReactiveConnection> getConnectionFromPool(Pool pool, SqlExceptionHelper sqlExceptionHelper) {
        return this.completionStage(pool.getConnection().map(sqlConnection -> this.newConnection((SqlConnection)sqlConnection, sqlExceptionHelper)), ReactiveConnection::close);
    }

    private <T> CompletionStage<T> completionStage(Future<T> future, Consumer<T> onCancellation) {
        CompletableFuture completableFuture = new CompletableFuture();
        future.onComplete(ar -> {
            if (ar.succeeded()) {
                if (completableFuture.isCancelled()) {
                    onCancellation.accept(ar.result());
                }
                completableFuture.complete(ar.result());
            } else {
                completableFuture.completeExceptionally(ar.cause());
            }
        });
        return completableFuture;
    }

    private SqlClientConnection newConnection(SqlConnection connection) {
        return this.newConnection(connection, this.getSqlExceptionHelper());
    }

    private SqlClientConnection newConnection(SqlConnection connection, SqlExceptionHelper sqlExceptionHelper) {
        return new SqlClientConnection(connection, this.getPool(), this.getSqlStatementLogger(), sqlExceptionHelper);
    }
}

