/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.pool.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.ReactiveConnectionPool;
import org.hibernate.reactive.pool.impl.DefaultSqlClientPool;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class ReactiveConnectionPoolInitiator
implements StandardServiceInitiator<ReactiveConnectionPool> {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    public static final ReactiveConnectionPoolInitiator INSTANCE = new ReactiveConnectionPoolInitiator();

    public ReactiveConnectionPool initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        Class implClass;
        Object configValue = configurationValues.get("hibernate.vertx.pool.class");
        if (configValue == null) {
            return new DefaultSqlClientPool();
        }
        if (configValue instanceof ReactiveConnectionPool) {
            return (ReactiveConnectionPool)configValue;
        }
        if (configValue instanceof Class) {
            implClass = (Class)configValue;
        } else {
            String className = configValue.toString();
            ClassLoaderService classLoaderService = (ClassLoaderService)registry.getService(ClassLoaderService.class);
            try {
                implClass = classLoaderService.classForName(className);
            }
            catch (ClassLoadingException cle) {
                throw new ServiceException("Unable to locate specified reactive connection pool [" + className + "]");
            }
        }
        try {
            LOG.instantiatingReactivePool(implClass);
            return (ReactiveConnectionPool)implClass.newInstance();
        }
        catch (Exception e) {
            throw new ServiceException("Unable to instantiate specified reactive connection pool [" + implClass.getName() + "]");
        }
    }

    public Class<ReactiveConnectionPool> getServiceInitiated() {
        return ReactiveConnectionPool.class;
    }
}

