/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.entity.mutation;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.internal.ModelMutationHelper;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.mutation.AttributeAnalysis;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.persister.entity.mutation.TableSet;
import org.hibernate.persister.entity.mutation.UpdateCoordinatorStandard;
import org.hibernate.reactive.engine.jdbc.env.internal.ReactiveMutationExecutor;
import org.hibernate.reactive.persister.entity.mutation.GeneratorValueUtil;
import org.hibernate.reactive.persister.entity.mutation.ReactiveScopedUpdateCoordinator;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.tuple.entity.EntityMetamodel;

public class ReactiveUpdateCoordinatorStandard
extends UpdateCoordinatorStandard
implements ReactiveScopedUpdateCoordinator {
    private CompletableFuture<GeneratedValues> updateResultStage;

    public ReactiveUpdateCoordinatorStandard(AbstractEntityPersister entityPersister, SessionFactoryImplementor factory, MutationOperationGroup staticUpdateGroup, BatchKey batchKey, MutationOperationGroup versionUpdateGroup, BatchKey versionUpdateBatchkey) {
        super(entityPersister, factory, staticUpdateGroup, batchKey, versionUpdateGroup, versionUpdateBatchkey);
    }

    private void complete(GeneratedValues generatedValues, Throwable throwable) {
        if (throwable != null) {
            this.fail(throwable);
        } else {
            this.updateResultStage.complete(generatedValues);
        }
    }

    private void fail(Throwable throwable) {
        this.updateResultStage.completeExceptionally(throwable);
    }

    @Override
    public CompletionStage<GeneratedValues> reactiveUpdate(Object entity, Object id, Object rowId, Object[] values, Object oldVersion, Object[] incomingOldValues, int[] incomingDirtyAttributeIndexes, boolean hasDirtyCollection, SharedSessionContractImplementor session) {
        Supplier generatedValuesAccess;
        EntityVersionMapping versionMapping = this.entityPersister().getVersionMapping();
        if (versionMapping != null && (generatedValuesAccess = this.handlePotentialImplicitForcedVersionIncrement(entity, id, values, oldVersion, incomingDirtyAttributeIndexes, session, versionMapping)) != null) {
            return CompletionStages.completedFuture((GeneratedValues)generatedValuesAccess.get());
        }
        EntityEntry entry = session.getPersistenceContextInternal().getEntry(entity);
        if (entry == null && !this.entityPersister().isMutable()) {
            this.fail(new IllegalStateException("Updating immutable entity that is not in session yet"));
            return this.updateResultStage;
        }
        CompletionStage<Void> s = CompletionStages.voidFuture();
        return s.thenCompose(v -> this.reactivePreUpdateInMemoryValueGeneration(entity, values, session)).thenCompose(preUpdateGeneratedAttributeIndexes -> {
            boolean forceDynamicUpdate;
            boolean[] attributeUpdateability;
            int[] dirtyAttributeIndexes = ReactiveUpdateCoordinatorStandard.dirtyAttributeIndexes((int[])incomingDirtyAttributeIndexes, (int[])preUpdateGeneratedAttributeIndexes);
            if (this.entityPersister().getEntityMetamodel().isDynamicUpdate() && dirtyAttributeIndexes != null) {
                attributeUpdateability = this.getPropertiesToUpdate(dirtyAttributeIndexes, hasDirtyCollection);
                forceDynamicUpdate = true;
            } else if (!this.isModifiableEntity(entry)) {
                attributeUpdateability = this.getPropertiesToUpdate(dirtyAttributeIndexes == null ? ArrayHelper.EMPTY_INT_ARRAY : dirtyAttributeIndexes, hasDirtyCollection);
                forceDynamicUpdate = true;
            } else if (dirtyAttributeIndexes != null && this.entityPersister().hasUninitializedLazyProperties(entity) && this.entityPersister().hasLazyDirtyFields(dirtyAttributeIndexes)) {
                forceDynamicUpdate = true;
                attributeUpdateability = this.getPropertiesToUpdate(dirtyAttributeIndexes, hasDirtyCollection);
                boolean[] propertyLaziness = this.entityPersister().getPropertyLaziness();
                for (int i = 0; i < propertyLaziness.length; ++i) {
                    if (propertyLaziness[i]) continue;
                    attributeUpdateability[i] = true;
                }
            } else {
                attributeUpdateability = this.getPropertyUpdateability(entity);
                forceDynamicUpdate = this.entityPersister().hasUninitializedLazyProperties(entity);
            }
            this.performUpdate(entity, id, rowId, values, oldVersion, incomingOldValues, hasDirtyCollection, session, versionMapping, dirtyAttributeIndexes, attributeUpdateability, forceDynamicUpdate);
            return this.updateResultStage != null ? this.updateResultStage : CompletionStages.nullFuture();
        });
    }

    private CompletionStage<int[]> reactivePreUpdateInMemoryValueGeneration(Object entity, Object[] currentValues, SharedSessionContractImplementor session) {
        EntityMetamodel entityMetamodel = this.entityPersister().getEntityMetamodel();
        if (!entityMetamodel.hasPreUpdateGeneratedValues()) {
            return CompletionStages.completedFuture(ArrayHelper.EMPTY_INT_ARRAY);
        }
        CompletionStage<Void> result = CompletionStages.voidFuture();
        Generator[] generators = entityMetamodel.getGenerators();
        if (generators.length != 0) {
            int[] fieldsPreUpdateNeeded = new int[generators.length];
            AtomicInteger count = new AtomicInteger(0);
            for (int i = 0; i < generators.length; ++i) {
                int index = i;
                Generator generator = generators[i];
                if (generator == null || generator.generatedOnExecution() || !generator.generatesOnUpdate()) continue;
                Object currentValue = currentValues[i];
                BeforeExecutionGenerator beforeGenerator = (BeforeExecutionGenerator)generator;
                result = result.thenCompose(v -> GeneratorValueUtil.generateValue(session, entity, currentValue, beforeGenerator, EventType.INSERT).thenAccept(generatedValue -> {
                    currentValues[index] = generatedValue;
                    this.entityPersister().setValue(entity, index, generatedValue);
                    fieldsPreUpdateNeeded[count.getAndIncrement()] = index;
                }));
            }
            return result.thenApply(v -> {
                if (count.get() > 0) {
                    return ArrayHelper.trim((int[])fieldsPreUpdateNeeded, (int)count.get());
                }
                return ArrayHelper.EMPTY_INT_ARRAY;
            });
        }
        return CompletionStages.completedFuture(ArrayHelper.EMPTY_INT_ARRAY);
    }

    protected GeneratedValues doVersionUpdate(Object entity, Object id, Object version, Object oldVersion, SharedSessionContractImplementor session) {
        assert (this.getVersionUpdateGroup() != null);
        this.updateResultStage = new CompletableFuture();
        EntityTableMapping mutatingTableDetails = (EntityTableMapping)this.getVersionUpdateGroup().getSingleOperation().getTableDetails();
        ReactiveMutationExecutor mutationExecutor = this.mutationExecutor(session, this.getVersionUpdateGroup());
        EntityVersionMapping versionMapping = this.entityPersister().getVersionMapping();
        mutationExecutor.getJdbcValueBindings().bindValue(version, mutatingTableDetails.getTableName(), versionMapping.getSelectionExpression(), ParameterUsage.SET);
        mutatingTableDetails.getKeyMapping().breakDownKeyJdbcValues(id, (jdbcValue, columnMapping) -> mutationExecutor.getJdbcValueBindings().bindValue(jdbcValue, mutatingTableDetails.getTableName(), columnMapping.getColumnName(), ParameterUsage.RESTRICT), session);
        mutationExecutor.getJdbcValueBindings().bindValue(oldVersion, mutatingTableDetails.getTableName(), versionMapping.getSelectionExpression(), ParameterUsage.RESTRICT);
        mutationExecutor.executeReactive(entity, null, tableMapping -> tableMapping.getTableName().equals(this.entityPersister().getIdentifierTableName()), (statementDetails, affectedRowCount, batchPosition) -> ModelMutationHelper.identifiedResultsCheck((PreparedStatementDetails)statementDetails, (int)affectedRowCount, (int)batchPosition, (MutationTarget)this.entityPersister(), (Object)id, (SessionFactoryImplementor)this.factory()), session).whenComplete((o, t) -> mutationExecutor.release()).whenComplete(this::complete);
        return null;
    }

    private ReactiveMutationExecutor mutationExecutor(SharedSessionContractImplementor session, MutationOperationGroup operationGroup) {
        MutationExecutorService mutationExecutorService = (MutationExecutorService)session.getSessionFactory().getServiceRegistry().getService(MutationExecutorService.class);
        return (ReactiveMutationExecutor)mutationExecutorService.createExecutor(() -> ((ReactiveUpdateCoordinatorStandard)this).getBatchKey(), operationGroup, session);
    }

    protected GeneratedValues doDynamicUpdate(Object entity, Object id, Object rowId, Object[] values, Object[] oldValues, UpdateCoordinatorStandard.InclusionChecker dirtinessChecker, UpdateCoordinatorStandard.UpdateValuesAnalysisImpl valuesAnalysis, SharedSessionContractImplementor session) {
        this.updateResultStage = new CompletableFuture();
        MutationOperationGroup dynamicUpdateGroup = this.generateDynamicUpdateGroup(entity, id, rowId, oldValues, valuesAnalysis, session);
        ReactiveMutationExecutor mutationExecutor = this.mutationExecutor(session, dynamicUpdateGroup);
        this.decomposeForUpdate(id, rowId, values, valuesAnalysis, mutationExecutor, dynamicUpdateGroup, (attributeIndex, attribute) -> dirtinessChecker.include(attributeIndex, (SingularAttributeMapping)attribute) ? AttributeAnalysis.DirtynessStatus.CONSIDER_LIKE_DIRTY : AttributeAnalysis.DirtynessStatus.NOT_DIRTY, session);
        this.bindPartitionColumnValueBindings(oldValues, session, mutationExecutor.getJdbcValueBindings());
        mutationExecutor.executeReactive(entity, (ValuesAnalysis)valuesAnalysis, tableMapping -> {
            if (tableMapping.isOptional() && !valuesAnalysis.getTablesWithNonNullValues().contains(tableMapping)) {
                return false;
            }
            return valuesAnalysis.getTablesNeedingUpdate().contains(tableMapping);
        }, (statementDetails, affectedRowCount, batchPosition) -> ModelMutationHelper.identifiedResultsCheck((PreparedStatementDetails)statementDetails, (int)affectedRowCount, (int)batchPosition, (MutationTarget)this.entityPersister(), (Object)id, (SessionFactoryImplementor)this.factory()), session).whenComplete((o, throwable) -> mutationExecutor.release()).whenComplete(this::complete);
        return null;
    }

    protected GeneratedValues doStaticUpdate(Object entity, Object id, Object rowId, Object[] values, Object[] oldValues, UpdateCoordinatorStandard.UpdateValuesAnalysisImpl valuesAnalysis, SharedSessionContractImplementor session) {
        this.updateResultStage = new CompletableFuture();
        MutationOperationGroup staticUpdateGroup = this.getStaticMutationOperationGroup();
        ReactiveMutationExecutor mutationExecutor = this.mutationExecutor(session, staticUpdateGroup);
        this.decomposeForUpdate(id, rowId, values, valuesAnalysis, mutationExecutor, staticUpdateGroup, (position, attribute) -> AttributeAnalysis.DirtynessStatus.CONSIDER_LIKE_DIRTY, session);
        this.bindPartitionColumnValueBindings(oldValues, session, mutationExecutor.getJdbcValueBindings());
        mutationExecutor.executeReactive(entity, (ValuesAnalysis)valuesAnalysis, arg_0 -> ((TableSet)valuesAnalysis.getTablesNeedingUpdate()).contains(arg_0), (statementDetails, affectedRowCount, batchPosition) -> ModelMutationHelper.identifiedResultsCheck((PreparedStatementDetails)statementDetails, (int)affectedRowCount, (int)batchPosition, (MutationTarget)this.entityPersister(), (Object)id, (SessionFactoryImplementor)this.factory()), session).whenComplete((o, throwable) -> mutationExecutor.release()).whenComplete(this::complete);
        return null;
    }
}

