/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.entity.mutation;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.Internal;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.internal.NoBatchKeyAccess;
import org.hibernate.engine.jdbc.mutation.spi.BatchKeyAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.generator.values.GeneratedValuesMutationDelegate;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.mutation.AbstractMutationCoordinator;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.persister.entity.mutation.InsertCoordinator;
import org.hibernate.persister.entity.mutation.InsertCoordinatorStandard;
import org.hibernate.reactive.engine.jdbc.env.internal.ReactiveMutationExecutor;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.entity.mutation.GeneratorValueUtil;
import org.hibernate.reactive.persister.entity.mutation.ReactiveInsertCoordinator;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.sql.model.ast.builder.MutationGroupBuilder;
import org.hibernate.sql.model.ast.builder.TableInsertBuilder;
import org.hibernate.sql.model.ast.builder.TableInsertBuilderStandard;
import org.hibernate.sql.model.ast.builder.TableMutationBuilder;
import org.hibernate.tuple.entity.EntityMetamodel;

@Internal
public class ReactiveInsertCoordinatorStandard
extends AbstractMutationCoordinator
implements ReactiveInsertCoordinator,
InsertCoordinator {
    private final MutationOperationGroup staticInsertGroup;
    private final BasicBatchKey batchKey;
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public ReactiveInsertCoordinatorStandard(AbstractEntityPersister entityPersister, SessionFactoryImplementor factory) {
        super(entityPersister, factory);
        this.batchKey = entityPersister.isIdentifierAssignedByInsert() || entityPersister.hasInsertGeneratedProperties() ? null : new BasicBatchKey(entityPersister.getEntityName() + "#INSERT", null);
        this.staticInsertGroup = entityPersister.getEntityMetamodel().isDynamicInsert() ? null : this.generateStaticOperationGroup();
    }

    public GeneratedValues insert(Object entity, Object[] values, SharedSessionContractImplementor session) {
        return this.insert(entity, null, values, session);
    }

    public GeneratedValues insert(Object entity, Object id, Object[] values, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("reactiveInsert");
    }

    @Override
    public CompletionStage<GeneratedValues> reactiveInsert(Object entity, Object[] values, SharedSessionContractImplementor session) {
        return this.reactiveInsert(entity, null, values, session);
    }

    @Override
    public CompletionStage<GeneratedValues> reactiveInsert(Object entity, Object id, Object[] values, SharedSessionContractImplementor session) {
        return this.coordinateReactiveInsert(entity, id, values, session, true);
    }

    public CompletionStage<GeneratedValues> coordinateReactiveInsert(Object entity, Object id, Object[] values, SharedSessionContractImplementor session, boolean isIdentityInsert) {
        return this.reactivePreInsertInMemoryValueGeneration(values, entity, session).thenCompose(needsDynamicInsert -> {
            boolean forceIdentifierBinding = this.entityPersister().getGenerator().generatedOnExecution() && id != null;
            return this.entityPersister().getEntityMetamodel().isDynamicInsert() || needsDynamicInsert != false || forceIdentifierBinding ? this.doDynamicInserts(id, values, entity, session, forceIdentifierBinding, isIdentityInsert) : this.doStaticInserts(id, values, entity, session, isIdentityInsert);
        });
    }

    private CompletionStage<Boolean> reactivePreInsertInMemoryValueGeneration(Object[] currentValues, Object entity, SharedSessionContractImplementor session) {
        EntityMetamodel entityMetamodel = this.entityPersister().getEntityMetamodel();
        CompletionStage<Boolean> stage = CompletionStages.falseFuture();
        if (entityMetamodel.hasPreInsertGeneratedValues()) {
            Generator[] generators = entityMetamodel.getGenerators();
            for (int i = 0; i < generators.length; ++i) {
                int index = i;
                Generator generator = generators[i];
                if (generator == null || generator.generatedOnExecution() || !generator.generatesOnInsert()) continue;
                Object currentValue = currentValues[i];
                BeforeExecutionGenerator beforeGenerator = (BeforeExecutionGenerator)generator;
                stage = stage.thenCompose(foundStateDependentGenerator -> GeneratorValueUtil.generateValue(session, entity, currentValue, beforeGenerator, EventType.INSERT).thenApply(generatedValue -> {
                    currentValues[index] = generatedValue;
                    this.entityPersister().setValue(entity, index, generatedValue);
                    return foundStateDependentGenerator != false || beforeGenerator.generatedOnExecution();
                }));
            }
        }
        return stage;
    }

    protected CompletionStage<Void> decomposeForReactiveInsert(MutationExecutor mutationExecutor, Object id, Object[] values, MutationOperationGroup mutationGroup, boolean[] propertyInclusions, TableInclusionChecker tableInclusionChecker, SharedSessionContractImplementor session) {
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        mutationGroup.forEachOperation((position, operation) -> {
            EntityTableMapping tableDetails = (EntityTableMapping)operation.getTableDetails();
            if (tableInclusionChecker.include((TableMapping)tableDetails)) {
                int[] attributeIndexes;
                for (int attributeIndex : attributeIndexes = tableDetails.getAttributeIndexes()) {
                    if (!propertyInclusions[attributeIndex]) continue;
                    AttributeMapping mapping = this.entityPersister().getAttributeMappings().get(attributeIndex);
                    this.decomposeAttribute(values[attributeIndex], session, jdbcValueBindings, mapping);
                }
            }
        });
        mutationGroup.forEachOperation((position, jdbcOperation) -> {
            if (id == null) {
                assert (this.entityPersister().getIdentityInsertDelegate() != null);
            } else {
                EntityTableMapping tableDetails = (EntityTableMapping)jdbcOperation.getTableDetails();
                this.breakDownJdbcValue(id, session, jdbcValueBindings, tableDetails);
            }
        });
        return CompletionStages.voidFuture();
    }

    protected CompletionStage<GeneratedValues> doDynamicInserts(Object id, Object[] values, Object object, SharedSessionContractImplementor session, boolean forceIdentifierBinding, boolean isIdentityInsert) {
        boolean[] insertability = this.getPropertiesToInsert(values);
        MutationOperationGroup insertGroup = this.generateDynamicInsertSqlGroup(insertability, object, session, forceIdentifierBinding);
        ReactiveMutationExecutor mutationExecutor = this.getReactiveMutationExecutor(session, insertGroup, true);
        InsertCoordinatorStandard.InsertValuesAnalysis insertValuesAnalysis = new InsertCoordinatorStandard.InsertValuesAnalysis((EntityMutationTarget)this.entityPersister(), values);
        TableInclusionChecker tableInclusionChecker = ReactiveInsertCoordinatorStandard.getTableInclusionChecker(insertValuesAnalysis);
        return this.decomposeForReactiveInsert(mutationExecutor, id, values, insertGroup, insertability, tableInclusionChecker, session).thenCompose(v -> mutationExecutor.executeReactive(object, (ValuesAnalysis)insertValuesAnalysis, tableInclusionChecker, (statementDetails, affectedRowCount, batchPosition) -> {
            statementDetails.getExpectation().verifyOutcome(affectedRowCount, statementDetails.getStatement(), batchPosition, statementDetails.getSqlString());
            return true;
        }, session, isIdentityInsert, this.entityPersister().getIdentifierColumnNames()).whenComplete((o, t) -> mutationExecutor.release()));
    }

    protected CompletionStage<GeneratedValues> doStaticInserts(Object id, Object[] values, Object object, SharedSessionContractImplementor session, boolean isIdentityInsert) {
        InsertCoordinatorStandard.InsertValuesAnalysis insertValuesAnalysis = new InsertCoordinatorStandard.InsertValuesAnalysis((EntityMutationTarget)this.entityPersister(), values);
        TableInclusionChecker tableInclusionChecker = ReactiveInsertCoordinatorStandard.getTableInclusionChecker(insertValuesAnalysis);
        ReactiveMutationExecutor mutationExecutor = this.getReactiveMutationExecutor(session, this.staticInsertGroup, false);
        return this.decomposeForReactiveInsert(mutationExecutor, id, values, this.staticInsertGroup, this.entityPersister().getPropertyInsertability(), tableInclusionChecker, session).thenCompose(v -> mutationExecutor.executeReactive(object, (ValuesAnalysis)insertValuesAnalysis, tableInclusionChecker, (statementDetails, affectedRowCount, batchPosition) -> {
            statementDetails.getExpectation().verifyOutcome(affectedRowCount, statementDetails.getStatement(), batchPosition, statementDetails.getSqlString());
            return true;
        }, session, isIdentityInsert, this.entityPersister().getIdentifierColumnNames())).whenComplete((generatedValues, throwable) -> mutationExecutor.release());
    }

    protected static TableInclusionChecker getTableInclusionChecker(InsertCoordinatorStandard.InsertValuesAnalysis insertValuesAnalysis) {
        return tableMapping -> !tableMapping.isOptional() || insertValuesAnalysis.hasNonNullBindings(tableMapping);
    }

    private ReactiveMutationExecutor getReactiveMutationExecutor(SharedSessionContractImplementor session, MutationOperationGroup operationGroup, boolean dynamicUpdate) {
        return (ReactiveMutationExecutor)this.mutationExecutorService.createExecutor(this.resolveBatchKeyAccess(dynamicUpdate, session), operationGroup, session);
    }

    protected BatchKeyAccess resolveBatchKeyAccess(boolean dynamicUpdate, SharedSessionContractImplementor session) {
        if (!dynamicUpdate && !this.entityPersister().optimisticLockStyle().isAllOrDirty() && session.getTransactionCoordinator() != null) {
            return this::getBatchKey;
        }
        return NoBatchKeyAccess.INSTANCE;
    }

    public BasicBatchKey getBatchKey() {
        return this.batchKey;
    }

    @Deprecated
    public MutationOperationGroup getStaticMutationOperationGroup() {
        return this.staticInsertGroup;
    }

    protected void decomposeAttribute(Object value, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings, AttributeMapping mapping) {
        if (!(mapping instanceof PluralAttributeMapping)) {
            mapping.decompose(value, 0, (Object)jdbcValueBindings, null, (valueIndex, bindings, noop, jdbcValue, selectableMapping) -> {
                if (selectableMapping.isInsertable()) {
                    bindings.bindValue(jdbcValue, this.entityPersister().physicalTableNameForMutation(selectableMapping), selectableMapping.getSelectionExpression(), ParameterUsage.SET);
                }
            }, session);
        }
    }

    public boolean[] getPropertiesToInsert(Object[] fields) {
        boolean[] notNull = new boolean[fields.length];
        boolean[] insertable = this.entityPersister().getPropertyInsertability();
        for (int i = 0; i < fields.length; ++i) {
            notNull[i] = insertable[i] && fields[i] != null;
        }
        return notNull;
    }

    protected MutationOperationGroup generateDynamicInsertSqlGroup(boolean[] insertable, Object object, SharedSessionContractImplementor session, boolean forceIdentifierBinding) {
        MutationGroupBuilder insertGroupBuilder = new MutationGroupBuilder(MutationType.INSERT, (EntityMutationTarget)this.entityPersister());
        this.entityPersister().forEachMutableTable(tableMapping -> insertGroupBuilder.addTableDetailsBuilder(this.createTableInsertBuilder((EntityTableMapping)tableMapping, forceIdentifierBinding)));
        this.applyTableInsertDetails(insertGroupBuilder, insertable, object, session, forceIdentifierBinding);
        return this.createOperationGroup(null, insertGroupBuilder.buildMutationGroup());
    }

    public MutationOperationGroup generateStaticOperationGroup() {
        MutationGroupBuilder insertGroupBuilder = new MutationGroupBuilder(MutationType.INSERT, (EntityMutationTarget)this.entityPersister());
        this.entityPersister().forEachMutableTable(tableMapping -> insertGroupBuilder.addTableDetailsBuilder(this.createTableInsertBuilder((EntityTableMapping)tableMapping, false)));
        this.applyTableInsertDetails(insertGroupBuilder, this.entityPersister().getPropertyInsertability(), null, null, false);
        return this.createOperationGroup(null, insertGroupBuilder.buildMutationGroup());
    }

    private TableMutationBuilder<?> createTableInsertBuilder(EntityTableMapping tableMapping, boolean forceIdentifierBinding) {
        GeneratedValuesMutationDelegate delegate = this.entityPersister().getInsertDelegate();
        if (tableMapping.isIdentifierTable() && delegate != null && !forceIdentifierBinding) {
            return delegate.createTableMutationBuilder(tableMapping.getInsertExpectation(), this.factory());
        }
        return new TableInsertBuilderStandard((MutationTarget)this.entityPersister(), (TableMapping)tableMapping, this.factory());
    }

    private void applyTableInsertDetails(MutationGroupBuilder insertGroupBuilder, boolean[] attributeInclusions, Object object, SharedSessionContractImplementor session, boolean forceIdentifierBinding) {
        AttributeMappingsList attributeMappings = this.entityPersister().getAttributeMappings();
        insertGroupBuilder.forEachTableMutationBuilder(builder -> {
            EntityTableMapping tableMapping = (EntityTableMapping)builder.getMutatingTable().getTableMapping();
            assert (!tableMapping.isInverse());
            int[] attributeIndexes = tableMapping.getAttributeIndexes();
            for (int i = 0; i < attributeIndexes.length; ++i) {
                int attributeIndex = attributeIndexes[i];
                AttributeMapping attributeMapping = attributeMappings.get(attributeIndex);
                if (attributeInclusions[attributeIndex]) {
                    attributeMapping.forEachInsertable((SelectableConsumer)insertGroupBuilder);
                    continue;
                }
                Generator generator = attributeMapping.getGenerator();
                if (!ReactiveInsertCoordinatorStandard.isValueGenerated(generator)) continue;
                if (session != null && !generator.generatedOnExecution(object, session)) {
                    attributeInclusions[attributeIndex] = true;
                    attributeMapping.forEachInsertable((SelectableConsumer)insertGroupBuilder);
                    continue;
                }
                if (!ReactiveInsertCoordinatorStandard.isValueGenerationInSql(generator, this.factory().getJdbcServices().getDialect())) continue;
                this.handleValueGeneration(attributeMapping, insertGroupBuilder, (OnExecutionGenerator)generator);
            }
        });
        this.entityPersister().addDiscriminatorToInsertGroup(insertGroupBuilder);
        this.entityPersister().addSoftDeleteToInsertGroup(insertGroupBuilder);
        insertGroupBuilder.forEachTableMutationBuilder(tableMutationBuilder -> {
            TableInsertBuilder tableInsertBuilder = (TableInsertBuilder)tableMutationBuilder;
            EntityTableMapping tableMapping = (EntityTableMapping)tableInsertBuilder.getMutatingTable().getTableMapping();
            if (tableMapping.isIdentifierTable() && this.entityPersister().isIdentifierAssignedByInsert() && !forceIdentifierBinding) {
                assert (this.entityPersister().getInsertDelegate() != null);
                OnExecutionGenerator generator = (OnExecutionGenerator)this.entityPersister().getGenerator();
                if (generator.referenceColumnsInSql(this.dialect())) {
                    BasicEntityIdentifierMapping identifierMapping = (BasicEntityIdentifierMapping)this.entityPersister().getIdentifierMapping();
                    String[] columnValues = generator.getReferencedColumnValues(this.dialect);
                    tableMapping.getKeyMapping().forEachKeyColumn((i, column) -> tableInsertBuilder.addKeyColumn(column.getColumnName(), columnValues[i], identifierMapping.getJdbcMapping()));
                }
            } else {
                tableMapping.getKeyMapping().forEachKeyColumn(arg_0 -> ((TableInsertBuilder)tableInsertBuilder).addKeyColumn(arg_0));
            }
        });
    }

    protected void breakDownJdbcValue(Object id, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings, EntityTableMapping tableDetails) {
        String tableName = tableDetails.getTableName();
        tableDetails.getKeyMapping().breakDownKeyJdbcValues(id, (jdbcValue, columnMapping) -> jdbcValueBindings.bindValue(jdbcValue, tableName, columnMapping.getColumnName(), ParameterUsage.SET), session);
    }

    private static boolean isValueGenerated(Generator generator) {
        return generator != null && generator.generatesOnInsert() && generator.generatedOnExecution();
    }

    private static boolean isValueGenerationInSql(Generator generator, Dialect dialect) {
        assert (ReactiveInsertCoordinatorStandard.isValueGenerated(generator));
        return ((OnExecutionGenerator)generator).referenceColumnsInSql(dialect);
    }
}

