/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.collection.mutation;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.concurrent.CompletionStage;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.spi.BatchKeyAccess;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.persister.collection.mutation.UpdateRowsCoordinatorOneToMany;
import org.hibernate.reactive.engine.jdbc.env.internal.ReactiveMutationExecutor;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.collection.mutation.ReactiveUpdateRowsCoordinator;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.internal.MutationOperationGroupFactory;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;

public class ReactiveUpdateRowsCoordinatorOneToMany
extends UpdateRowsCoordinatorOneToMany
implements ReactiveUpdateRowsCoordinator {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final RowMutationOperations rowMutationOperations;
    private MutationOperationGroup deleteOperationGroup;
    private MutationOperationGroup insertOperationGroup;

    public ReactiveUpdateRowsCoordinatorOneToMany(CollectionMutationTarget mutationTarget, RowMutationOperations rowMutationOperations, SessionFactoryImplementor sessionFactory) {
        super(mutationTarget, rowMutationOperations, sessionFactory);
        this.rowMutationOperations = rowMutationOperations;
    }

    public void updateRows(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("reactiveUpdateRows");
    }

    protected int doUpdate(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("doReactiveUpdate");
    }

    @Override
    public CompletionStage<Void> reactiveUpdateRows(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Updating collection rows - %s#%s", (Object)this.getMutationTarget().getRolePath(), key);
        return this.doReactiveUpdate(key, collection, session).thenAccept(count -> ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Updated `%s` collection rows - %s#%s", count, (Object)this.getMutationTarget().getRolePath(), key));
    }

    private CompletionStage<Integer> doReactiveUpdate(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        if (this.rowMutationOperations.hasDeleteRow()) {
            this.deleteRows(key, collection, session);
        }
        if (this.rowMutationOperations.hasInsertRow()) {
            return this.insertRows(key, collection, session);
        }
        return CompletionStages.completedFuture(0);
    }

    private CompletionStage<Integer> insertRows(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        MutationOperationGroup operationGroup = this.resolveInsertGroup();
        PluralAttributeMapping attributeMapping = this.getMutationTarget().getTargetPart();
        CollectionPersister collectionDescriptor = attributeMapping.getCollectionDescriptor();
        ReactiveMutationExecutor mutationExecutor = this.reactiveMutationExecutor(session, operationGroup, this::getInsertBatchKey);
        int[] entryPosition = new int[]{-1};
        return CompletionStages.voidFuture().thenApply(unused -> {
            JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
            Iterator entries = collection.entries(collectionDescriptor);
            return CompletionStages.loop(entries, (entry, integer) -> {
                entryPosition[0] = entryPosition[0] + 1;
                if (!collection.needsUpdating(entry, entryPosition[0], attributeMapping)) {
                    return CompletionStages.voidFuture();
                }
                this.rowMutationOperations.getInsertRowValues().applyValues(collection, key, entry, entryPosition[0], session, jdbcValueBindings);
                return mutationExecutor.executeReactive(entry, null, null, null, session);
            });
        }).whenComplete((o, throwable) -> mutationExecutor.release()).thenApply(unused -> entryPosition[0]);
    }

    private BasicBatchKey getInsertBatchKey() {
        return new BasicBatchKey(this.getMutationTarget().getRolePath() + "#UPDATE-INSERT");
    }

    private BasicBatchKey getDeleteBatchKey() {
        return new BasicBatchKey(this.getMutationTarget().getRolePath() + "#UPDATE-DELETE");
    }

    private CompletionStage<Void> deleteRows(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        MutationOperationGroup operationGroup = this.resolveDeleteGroup();
        PluralAttributeMapping attributeMapping = this.getMutationTarget().getTargetPart();
        CollectionPersister collectionDescriptor = attributeMapping.getCollectionDescriptor();
        ReactiveMutationExecutor mutationExecutor = this.reactiveMutationExecutor(session, operationGroup, this::getDeleteBatchKey);
        int[] entryPosition = new int[]{-1};
        return CompletionStages.voidFuture().thenApply(unused -> {
            JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
            Iterator entries = collection.entries(collectionDescriptor);
            return CompletionStages.loop(entries, (entry, integer) -> {
                entryPosition[0] = entryPosition[0] + 1;
                if (!collection.needsUpdating(entry, entryPosition[0], attributeMapping)) {
                    return CompletionStages.voidFuture();
                }
                this.rowMutationOperations.getDeleteRowRestrictions().applyRestrictions(collection, key, entry, entryPosition[0], session, jdbcValueBindings);
                return mutationExecutor.executeReactive(entry, null, null, null, session);
            });
        }).whenComplete((o, throwable) -> mutationExecutor.release()).thenCompose(CompletionStages::voidFuture);
    }

    private ReactiveMutationExecutor reactiveMutationExecutor(SharedSessionContractImplementor session, MutationOperationGroup operationGroup, BatchKeyAccess batchKeySupplier) {
        MutationExecutorService mutationExecutorService = (MutationExecutorService)session.getFactory().getServiceRegistry().getService(MutationExecutorService.class);
        return (ReactiveMutationExecutor)mutationExecutorService.createExecutor(batchKeySupplier, operationGroup, session);
    }

    private MutationOperationGroup resolveDeleteGroup() {
        if (this.deleteOperationGroup == null) {
            JdbcMutationOperation operation = this.rowMutationOperations.getDeleteRowOperation();
            assert (operation != null);
            this.deleteOperationGroup = MutationOperationGroupFactory.singleOperation((MutationType)MutationType.DELETE, (MutationTarget)this.getMutationTarget(), (MutationOperation)operation);
        }
        return this.deleteOperationGroup;
    }

    private MutationOperationGroup resolveInsertGroup() {
        if (this.insertOperationGroup == null) {
            JdbcMutationOperation operation = this.rowMutationOperations.getInsertRowOperation();
            assert (operation != null);
            this.insertOperationGroup = MutationOperationGroupFactory.singleOperation((MutationType)MutationType.INSERT, (MutationTarget)this.getMutationTarget(), (MutationOperation)operation);
        }
        return this.insertOperationGroup;
    }
}

