/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.collection.mutation;

import java.util.Iterator;
import java.util.concurrent.CompletionStage;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.DeleteRowsCoordinatorStandard;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.reactive.engine.jdbc.env.internal.ReactiveMutationExecutor;
import org.hibernate.reactive.persister.collection.mutation.ReactiveDeleteRowsCoordinator;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.internal.MutationOperationGroupFactory;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;

public class ReactiveDeleteRowsCoordinatorStandard
extends DeleteRowsCoordinatorStandard
implements ReactiveDeleteRowsCoordinator {
    private final RowMutationOperations rowMutationOperations;
    private final boolean deleteByIndex;
    private MutationOperationGroup operationGroup;
    private final BasicBatchKey batchKey;

    public ReactiveDeleteRowsCoordinatorStandard(CollectionMutationTarget mutationTarget, RowMutationOperations rowMutationOperations, boolean deleteByIndex, ServiceRegistry serviceRegistry) {
        super(mutationTarget, rowMutationOperations, deleteByIndex, serviceRegistry);
        this.deleteByIndex = deleteByIndex;
        this.rowMutationOperations = rowMutationOperations;
        this.batchKey = new BasicBatchKey(mutationTarget.getRolePath() + "#DELETE");
    }

    @Override
    public CompletionStage<Void> reactiveDeleteRows(PersistentCollection<?> collection, Object key, SharedSessionContractImplementor session) {
        if (this.operationGroup == null) {
            this.operationGroup = this.createOperationGroup();
        }
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Deleting removed collection rows - %s : %s", (Object)this.getMutationTarget().getRolePath(), key);
        }
        ReactiveMutationExecutor mutationExecutor = this.reactiveMutationExecutor(session, this.operationGroup);
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        return CompletionStages.voidFuture().thenCompose(unused -> {
            PluralAttributeMapping pluralAttribute = this.getMutationTarget().getTargetPart();
            CollectionPersister collectionDescriptor = pluralAttribute.getCollectionDescriptor();
            Iterator deletes = collection.getDeletes(collectionDescriptor, !this.deleteByIndex);
            if (!deletes.hasNext()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debug((Object)"No rows to delete");
                return CompletionStages.voidFuture();
            }
            int[] deletionCount = new int[]{0};
            RowMutationOperations.Restrictions restrictions = this.rowMutationOperations.getDeleteRowRestrictions();
            return CompletionStages.loop(deletes, (removal, integer) -> {
                restrictions.applyRestrictions(collection, key, removal, deletionCount[0], session, jdbcValueBindings);
                return mutationExecutor.executeReactive(removal, null, null, null, session).thenAccept(o -> {
                    deletionCount[0] = deletionCount[0] + 1;
                });
            }).thenAccept(ignore -> ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Done deleting `%s` collection rows : %s", (Object)deletionCount, (Object)this.getMutationTarget().getRolePath()));
        }).whenComplete((o, throwable) -> mutationExecutor.release());
    }

    private ReactiveMutationExecutor reactiveMutationExecutor(SharedSessionContractImplementor session, MutationOperationGroup operationGroup) {
        MutationExecutorService mutationExecutorService = (MutationExecutorService)session.getFactory().getServiceRegistry().getService(MutationExecutorService.class);
        return (ReactiveMutationExecutor)mutationExecutorService.createExecutor(this::getBatchKey, operationGroup, session);
    }

    private MutationOperationGroup createOperationGroup() {
        assert (this.getMutationTarget().getTargetPart() != null);
        assert (this.getMutationTarget().getTargetPart().getKeyDescriptor() != null);
        JdbcMutationOperation operation = this.rowMutationOperations.getDeleteRowOperation();
        return MutationOperationGroupFactory.singleOperation((MutationType)MutationType.DELETE, (MutationTarget)this.getMutationTarget(), (MutationOperation)operation);
    }

    private BasicBatchKey getBatchKey() {
        return this.batchKey;
    }
}

