/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.mutiny;

import io.smallrye.mutiny.Uni;
import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Metamodel;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.Cache;
import org.hibernate.CacheMode;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.Incubating;
import org.hibernate.LockMode;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.collection.spi.AbstractPersistentCollection;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.LockModeConverter;
import org.hibernate.jpa.internal.util.CacheModeHelper;
import org.hibernate.jpa.internal.util.FlushModeTypeHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.query.Order;
import org.hibernate.query.Page;
import org.hibernate.reactive.common.AffectedEntities;
import org.hibernate.reactive.common.Identifier;
import org.hibernate.reactive.common.ResultSetMapping;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.impl.ReactiveQueryExecutorLookup;
import org.hibernate.stat.Statistics;

public interface Mutiny {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> Uni<T> fetch(T association) {
        SharedSessionContractImplementor session;
        if (association == null) {
            return Uni.createFrom().nullItem();
        }
        if (association instanceof HibernateProxy) {
            session = ((HibernateProxy)association).getHibernateLazyInitializer().getSession();
        } else if (association instanceof PersistentCollection) {
            session = ((AbstractPersistentCollection)association).getSession();
        } else {
            if (!ManagedTypeHelper.isPersistentAttributeInterceptable(association)) return Uni.createFrom().item(association);
            PersistentAttributeInterceptable interceptable = ManagedTypeHelper.asPersistentAttributeInterceptable(association);
            PersistentAttributeInterceptor interceptor = interceptable.$$_hibernate_getInterceptor();
            if (!(interceptor instanceof EnhancementAsProxyLazinessInterceptor)) return Uni.createFrom().item(association);
            session = ((EnhancementAsProxyLazinessInterceptor)interceptor).getLinkedSession();
        }
        if (session != null) return Uni.createFrom().completionStage(ReactiveQueryExecutorLookup.extract(session).reactiveFetch(association, false));
        throw LoggerFactory.make(Log.class, MethodHandles.lookup()).sessionClosedLazyInitializationException();
    }

    public static interface Closeable {
        public Uni<Void> close();
    }

    public static interface SessionFactory
    extends AutoCloseable {
        public Uni<Session> openSession();

        public Uni<Session> openSession(String var1);

        public Uni<StatelessSession> openStatelessSession();

        public Uni<StatelessSession> openStatelessSession(String var1);

        public <T> Uni<T> withSession(Function<Session, Uni<T>> var1);

        public <T> Uni<T> withSession(String var1, Function<Session, Uni<T>> var2);

        public <T> Uni<T> withTransaction(BiFunction<Session, Transaction, Uni<T>> var1);

        default public <T> Uni<T> withTransaction(Function<Session, Uni<T>> work) {
            return this.withTransaction((Session session, Transaction transaction) -> (Uni)work.apply((Session)session));
        }

        default public <T> Uni<T> withStatelessTransaction(Function<StatelessSession, Uni<T>> work) {
            return this.withStatelessTransaction((StatelessSession statelessSession, Transaction transaction) -> (Uni)work.apply((StatelessSession)statelessSession));
        }

        public <T> Uni<T> withStatelessTransaction(BiFunction<StatelessSession, Transaction, Uni<T>> var1);

        public <T> Uni<T> withStatelessSession(Function<StatelessSession, Uni<T>> var1);

        public <T> Uni<T> withStatelessSession(String var1, Function<StatelessSession, Uni<T>> var2);

        public <T> Uni<T> withTransaction(String var1, BiFunction<Session, Transaction, Uni<T>> var2);

        public <T> Uni<T> withStatelessTransaction(String var1, BiFunction<StatelessSession, Transaction, Uni<T>> var2);

        public CriteriaBuilder getCriteriaBuilder();

        public Metamodel getMetamodel();

        public Cache getCache();

        public Statistics getStatistics();

        @Override
        public void close();

        public boolean isOpen();
    }

    public static interface Transaction {
        public void markForRollback();

        public boolean isMarkedForRollback();
    }

    public static interface StatelessSession
    extends Closeable {
        public <T> Uni<T> get(Class<T> var1, Object var2);

        public <T> Uni<T> get(Class<T> var1, Object var2, LockMode var3);

        default public <T> Uni<T> get(Class<T> entityClass, Object id, LockModeType lockModeType) {
            return this.get(entityClass, id, LockModeConverter.convertToLockMode((LockModeType)lockModeType));
        }

        public <T> Uni<T> get(EntityGraph<T> var1, Object var2);

        @Deprecated
        public <R> Query<R> createQuery(String var1);

        public <R> SelectionQuery<R> createQuery(String var1, Class<R> var2);

        public <R> SelectionQuery<R> createSelectionQuery(String var1, Class<R> var2);

        public MutationQuery createMutationQuery(String var1);

        public <R> Query<R> createNamedQuery(String var1);

        public <R> SelectionQuery<R> createNamedQuery(String var1, Class<R> var2);

        public <R> Query<R> createNativeQuery(String var1);

        public <R> SelectionQuery<R> createNativeQuery(String var1, Class<R> var2);

        public <R> SelectionQuery<R> createNativeQuery(String var1, ResultSetMapping<R> var2);

        public <R> SelectionQuery<R> createQuery(CriteriaQuery<R> var1);

        public Uni<Void> insert(Object var1);

        public Uni<Void> insertAll(Object ... var1);

        public Uni<Void> insertAll(int var1, Object ... var2);

        public Uni<Void> delete(Object var1);

        public Uni<Void> deleteAll(Object ... var1);

        public Uni<Void> deleteAll(int var1, Object ... var2);

        public Uni<Void> update(Object var1);

        public Uni<Void> updateAll(Object ... var1);

        public Uni<Void> updateAll(int var1, Object ... var2);

        public Uni<Void> refresh(Object var1);

        @Incubating
        public Uni<Void> upsert(Object var1);

        @Incubating
        public Uni<Void> upsert(String var1, Object var2);

        public Uni<Void> refreshAll(Object ... var1);

        public Uni<Void> refreshAll(int var1, Object ... var2);

        public Uni<Void> refresh(Object var1, LockMode var2);

        default public Uni<Void> refresh(Object entity, LockModeType lockModeType) {
            return this.refresh(entity, LockModeConverter.convertToLockMode((LockModeType)lockModeType));
        }

        public <T> Uni<T> fetch(T var1);

        public <T> ResultSetMapping<T> getResultSetMapping(Class<T> var1, String var2);

        public <T> EntityGraph<T> getEntityGraph(Class<T> var1, String var2);

        public <T> EntityGraph<T> createEntityGraph(Class<T> var1);

        public <T> EntityGraph<T> createEntityGraph(Class<T> var1, String var2);

        public <T> Uni<T> withTransaction(Function<Transaction, Uni<T>> var1);

        public Transaction currentTransaction();

        public boolean isOpen();

        @Override
        public Uni<Void> close();

        public SessionFactory getFactory();
    }

    public static interface Session
    extends Closeable {
        public <T> Uni<T> find(Class<T> var1, Object var2);

        public <T> Uni<T> find(Class<T> var1, Object var2, LockMode var3);

        default public <T> Uni<T> find(Class<T> entityClass, Object id, LockModeType lockModeType) {
            return this.find(entityClass, id, LockModeConverter.convertToLockMode((LockModeType)lockModeType));
        }

        public <T> Uni<T> find(EntityGraph<T> var1, Object var2);

        public <T> Uni<List<T>> find(Class<T> var1, Object ... var2);

        @Incubating
        public <T> Uni<T> find(Class<T> var1, Identifier<T> var2);

        public <T> T getReference(Class<T> var1, Object var2);

        public <T> T getReference(T var1);

        public Uni<Void> persist(Object var1);

        public Uni<Void> persistAll(Object ... var1);

        public Uni<Void> remove(Object var1);

        public Uni<Void> removeAll(Object ... var1);

        public <T> Uni<T> merge(T var1);

        public Uni<Void> mergeAll(Object ... var1);

        public Uni<Void> refresh(Object var1);

        public Uni<Void> refresh(Object var1, LockMode var2);

        default public Uni<Void> refresh(Object entity, LockModeType lockModeType) {
            return this.refresh(entity, LockModeConverter.convertToLockMode((LockModeType)lockModeType));
        }

        public Uni<Void> refreshAll(Object ... var1);

        public Uni<Void> lock(Object var1, LockMode var2);

        default public Uni<Void> lock(Object entity, LockModeType lockModeType) {
            return this.lock(entity, LockModeConverter.convertToLockMode((LockModeType)lockModeType));
        }

        public Uni<Void> flush();

        public <T> Uni<T> fetch(T var1);

        public <E, T> Uni<T> fetch(E var1, Attribute<E, T> var2);

        public <T> Uni<T> unproxy(T var1);

        public LockMode getLockMode(Object var1);

        public boolean contains(Object var1);

        public <R> SelectionQuery<R> createSelectionQuery(String var1, Class<R> var2);

        public MutationQuery createMutationQuery(String var1);

        @Deprecated
        public <R> Query<R> createQuery(String var1);

        public <R> SelectionQuery<R> createQuery(String var1, Class<R> var2);

        public <R> SelectionQuery<R> createQuery(CriteriaQuery<R> var1);

        public <R> MutationQuery createQuery(CriteriaUpdate<R> var1);

        public <R> MutationQuery createQuery(CriteriaDelete<R> var1);

        public <R> Query<R> createNamedQuery(String var1);

        public <R> SelectionQuery<R> createNamedQuery(String var1, Class<R> var2);

        public <R> Query<R> createNativeQuery(String var1);

        public <R> Query<R> createNativeQuery(String var1, AffectedEntities var2);

        public <R> SelectionQuery<R> createNativeQuery(String var1, Class<R> var2);

        public <R> SelectionQuery<R> createNativeQuery(String var1, Class<R> var2, AffectedEntities var3);

        public <R> SelectionQuery<R> createNativeQuery(String var1, ResultSetMapping<R> var2);

        public <R> SelectionQuery<R> createNativeQuery(String var1, ResultSetMapping<R> var2, AffectedEntities var3);

        public Session setFlushMode(FlushMode var1);

        default public Session setFlushMode(FlushModeType flushModeType) {
            return this.setFlushMode(FlushModeTypeHelper.getFlushMode((FlushModeType)flushModeType));
        }

        public FlushMode getFlushMode();

        public Session detach(Object var1);

        public Session clear();

        public Session enableFetchProfile(String var1);

        public <T> ResultSetMapping<T> getResultSetMapping(Class<T> var1, String var2);

        public <T> EntityGraph<T> getEntityGraph(Class<T> var1, String var2);

        public <T> EntityGraph<T> createEntityGraph(Class<T> var1);

        public <T> EntityGraph<T> createEntityGraph(Class<T> var1, String var2);

        public Session disableFetchProfile(String var1);

        public boolean isFetchProfileEnabled(String var1);

        public Session setDefaultReadOnly(boolean var1);

        public boolean isDefaultReadOnly();

        public Session setReadOnly(Object var1, boolean var2);

        public boolean isReadOnly(Object var1);

        public Session setCacheMode(CacheMode var1);

        default public Session setCacheStoreMode(CacheStoreMode cacheStoreMode) {
            return this.setCacheMode(CacheModeHelper.interpretCacheMode((CacheStoreMode)cacheStoreMode, (CacheRetrieveMode)CacheModeHelper.interpretCacheRetrieveMode((CacheMode)this.getCacheMode())));
        }

        default public Session setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
            return this.setCacheMode(CacheModeHelper.interpretCacheMode((CacheStoreMode)CacheModeHelper.interpretCacheStoreMode((CacheMode)this.getCacheMode()), (CacheRetrieveMode)cacheRetrieveMode));
        }

        public CacheMode getCacheMode();

        public Session setBatchSize(Integer var1);

        public Integer getBatchSize();

        public Filter enableFilter(String var1);

        public void disableFilter(String var1);

        public Filter getEnabledFilter(String var1);

        public int getFetchBatchSize();

        public Session setFetchBatchSize(int var1);

        public boolean isSubselectFetchingEnabled();

        public Session setSubselectFetchingEnabled(boolean var1);

        public <T> Uni<T> withTransaction(Function<Transaction, Uni<T>> var1);

        public Transaction currentTransaction();

        public boolean isOpen();

        public SessionFactory getFactory();
    }

    public static interface Query<R>
    extends SelectionQuery<R>,
    MutationQuery {
        @Override
        public Query<R> setMaxResults(int var1);

        @Override
        public Query<R> setFirstResult(int var1);

        @Override
        public Query<R> setReadOnly(boolean var1);

        @Override
        public Query<R> setCacheable(boolean var1);

        @Override
        public Query<R> setCacheRegion(String var1);

        @Override
        public Query<R> setCacheMode(CacheMode var1);

        @Override
        default public Query<R> setCacheStoreMode(CacheStoreMode cacheStoreMode) {
            SelectionQuery.super.setCacheStoreMode(cacheStoreMode);
            return this;
        }

        @Override
        default public Query<R> setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
            SelectionQuery.super.setCacheRetrieveMode(cacheRetrieveMode);
            return this;
        }

        @Override
        public Query<R> setFlushMode(FlushMode var1);

        @Override
        default public Query<R> setFlushMode(FlushModeType flushModeType) {
            SelectionQuery.super.setFlushMode(flushModeType);
            return this;
        }

        @Override
        public Query<R> setLockMode(LockMode var1);

        @Override
        default public Query<R> setLockMode(LockModeType lockModeType) {
            SelectionQuery.super.setLockMode(lockModeType);
            return this;
        }

        @Override
        public Query<R> setLockMode(String var1, LockMode var2);

        @Override
        default public Query<R> setLockMode(String alias, LockModeType lockModeType) {
            SelectionQuery.super.setLockMode(alias, lockModeType);
            return this;
        }

        @Override
        public Query<R> setPlan(EntityGraph<R> var1);

        @Override
        public Query<R> setParameter(int var1, Object var2);

        @Override
        public Query<R> setParameter(String var1, Object var2);

        @Override
        public <T> Query<R> setParameter(Parameter<T> var1, T var2);

        @Override
        public Query<R> setComment(String var1);

        @Override
        public Query<R> enableFetchProfile(String var1);
    }

    public static interface MutationQuery
    extends AbstractQuery {
        public Uni<Integer> executeUpdate();

        @Override
        public MutationQuery setParameter(int var1, Object var2);

        @Override
        public MutationQuery setParameter(String var1, Object var2);

        @Override
        public <T> MutationQuery setParameter(Parameter<T> var1, T var2);

        @Override
        public MutationQuery setComment(String var1);
    }

    public static interface SelectionQuery<R>
    extends AbstractQuery {
        public SelectionQuery<R> setMaxResults(int var1);

        public SelectionQuery<R> setFirstResult(int var1);

        @Incubating
        public SelectionQuery<R> setPage(Page var1);

        public int getMaxResults();

        public int getFirstResult();

        public Uni<R> getSingleResult();

        public Uni<R> getSingleResultOrNull();

        public Uni<List<R>> getResultList();

        public SelectionQuery<R> setReadOnly(boolean var1);

        public boolean isReadOnly();

        public SelectionQuery<R> setCacheable(boolean var1);

        public boolean isCacheable();

        public SelectionQuery<R> setCacheRegion(String var1);

        public String getCacheRegion();

        public SelectionQuery<R> setCacheMode(CacheMode var1);

        default public SelectionQuery<R> setCacheStoreMode(CacheStoreMode cacheStoreMode) {
            return this.setCacheMode(CacheModeHelper.interpretCacheMode((CacheStoreMode)cacheStoreMode, (CacheRetrieveMode)CacheModeHelper.interpretCacheRetrieveMode((CacheMode)this.getCacheMode())));
        }

        default public SelectionQuery<R> setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
            return this.setCacheMode(CacheModeHelper.interpretCacheMode((CacheStoreMode)CacheModeHelper.interpretCacheStoreMode((CacheMode)this.getCacheMode()), (CacheRetrieveMode)cacheRetrieveMode));
        }

        public CacheStoreMode getCacheStoreMode();

        public CacheRetrieveMode getCacheRetrieveMode();

        public CacheMode getCacheMode();

        public SelectionQuery<R> setFlushMode(FlushMode var1);

        default public SelectionQuery<R> setFlushMode(FlushModeType flushModeType) {
            return this.setFlushMode(FlushModeTypeHelper.getFlushMode((FlushModeType)flushModeType));
        }

        public FlushMode getFlushMode();

        public SelectionQuery<R> setLockMode(LockMode var1);

        default public SelectionQuery<R> setLockMode(LockModeType lockModeType) {
            return this.setLockMode(LockModeConverter.convertToLockMode((LockModeType)lockModeType));
        }

        public SelectionQuery<R> setLockMode(String var1, LockMode var2);

        default public SelectionQuery<R> setLockMode(String alias, LockModeType lockModeType) {
            return this.setLockMode(alias, LockModeConverter.convertToLockMode((LockModeType)lockModeType));
        }

        public SelectionQuery<R> setOrder(List<Order<? super R>> var1);

        public SelectionQuery<R> setOrder(Order<? super R> var1);

        public SelectionQuery<R> setPlan(EntityGraph<R> var1);

        public SelectionQuery<R> enableFetchProfile(String var1);

        @Override
        public SelectionQuery<R> setParameter(int var1, Object var2);

        @Override
        public SelectionQuery<R> setParameter(String var1, Object var2);

        @Override
        public <T> SelectionQuery<R> setParameter(Parameter<T> var1, T var2);

        @Override
        public SelectionQuery<R> setComment(String var1);
    }

    public static interface AbstractQuery {
        public AbstractQuery setParameter(int var1, Object var2);

        public AbstractQuery setParameter(String var1, Object var2);

        public <T> AbstractQuery setParameter(Parameter<T> var1, T var2);

        public AbstractQuery setComment(String var1);

        public String getComment();
    }
}

