/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.spi.EntityBatchLoader;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.SqlInPredicateMultiKeyLoader;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.reactive.loader.ast.internal.ReactiveMultiKeyLoadChunker;
import org.hibernate.reactive.loader.ast.internal.ReactiveSingleIdEntityLoaderSupport;
import org.hibernate.reactive.loader.ast.internal.SingleIdExecutionContext;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;

public class ReactiveEntityBatchLoaderInPredicate<T>
extends ReactiveSingleIdEntityLoaderSupport<T>
implements EntityBatchLoader<CompletionStage<T>>,
SqlInPredicateMultiKeyLoader {
    private final int domainBatchSize;
    private final int sqlBatchSize;
    private JdbcParametersList jdbcParameters;
    private SelectStatement sqlAst;
    private JdbcOperationQuerySelect jdbcSelectOperation;

    public ReactiveEntityBatchLoaderInPredicate(int domainBatchSize, int sqlBatchSize, EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        super(entityDescriptor, sessionFactory);
        this.domainBatchSize = domainBatchSize;
        this.sqlBatchSize = sqlBatchSize;
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Batch fetching `%s` entity using padded IN-list : %s (%s)", (Object)entityDescriptor.getEntityName(), (Object)domainBatchSize, (Object)sqlBatchSize);
        }
        EntityIdentifierMapping identifierMapping = this.getLoadable().getIdentifierMapping();
        int expectedNumberOfParameters = identifierMapping.getJdbcTypeCount() * sqlBatchSize;
        JdbcParametersList.Builder jdbcParametersBuilder = JdbcParametersList.newBuilder((int)expectedNumberOfParameters);
        this.sqlAst = LoaderSelectBuilder.createSelect((Loadable)this.getLoadable(), null, (ModelPart)identifierMapping, null, (int)sqlBatchSize, (LoadQueryInfluencers)new LoadQueryInfluencers(sessionFactory), (LockOptions)LockOptions.NONE, arg_0 -> ((JdbcParametersList.Builder)jdbcParametersBuilder).add(arg_0), (SessionFactoryImplementor)sessionFactory);
        this.jdbcParameters = jdbcParametersBuilder.build();
        assert (this.jdbcParameters.size() == expectedNumberOfParameters);
        this.jdbcSelectOperation = (JdbcOperationQuerySelect)sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(sessionFactory, this.sqlAst).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
    }

    public int getDomainBatchSize() {
        return this.domainBatchSize;
    }

    public final CompletionStage<T> load(Object pkValue, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        return this.load(pkValue, null, lockOptions, readOnly, session);
    }

    public final CompletionStage<T> load(Object pkValue, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Batch loading entity `%s#%s`", (Object)this.getLoadable().getEntityName(), pkValue);
        }
        Object[] idsToInitialize = this.resolveIdsToLoad(pkValue, session);
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Ids to batch-fetch initialize (`%s#%s`) %s", (Object)this.getLoadable().getEntityName(), pkValue, (Object)Arrays.toString(idsToInitialize));
        }
        return this.initializeEntities(idsToInitialize, pkValue, entityInstance, lockOptions, readOnly, session).thenApply(v -> {
            EntityKey entityKey = session.generateEntityKey(pkValue, this.getLoadable().getEntityPersister());
            return session.getPersistenceContext().getEntity(entityKey);
        });
    }

    protected Object[] resolveIdsToLoad(Object pkValue, SharedSessionContractImplementor session) {
        return session.getPersistenceContextInternal().getBatchFetchQueue().getBatchLoadableEntityIds(this.getLoadable(), pkValue, this.domainBatchSize);
    }

    protected CompletionStage<Void> initializeEntities(Object[] idsToInitialize, Object pkValue, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        ReactiveMultiKeyLoadChunker<Object> chunker = new ReactiveMultiKeyLoadChunker<Object>(this.sqlBatchSize, this.getLoadable().getIdentifierMapping().getJdbcTypeCount(), (Bindable)this.getLoadable().getIdentifierMapping(), this.jdbcParameters, this.sqlAst, this.jdbcSelectOperation);
        BatchFetchQueue batchFetchQueue = session.getPersistenceContextInternal().getBatchFetchQueue();
        ArrayList entityKeys = CollectionHelper.arrayList((int)this.sqlBatchSize);
        return chunker.processChunks(idsToInitialize, this.sqlBatchSize, (jdbcParameterBindings, session1) -> {
            SubselectFetch.RegistrationHandler registrationHandler = SubselectFetch.createRegistrationHandler((BatchFetchQueue)batchFetchQueue, (SelectStatement)this.sqlAst, (JdbcParametersList)this.jdbcParameters, (JdbcParameterBindings)jdbcParameterBindings);
            return new SingleIdExecutionContext(pkValue, entityInstance, readOnly, lockOptions, registrationHandler, session);
        }, (key, relativePosition, absolutePosition) -> {
            if (key != null) {
                entityKeys.add(session.generateEntityKey(key, this.getLoadable().getEntityPersister()));
            }
        }, startIndex -> {
            if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
                MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Processing entity batch-fetch chunk (`%s#%s`) %s - %s", new Object[]{this.getLoadable().getEntityName(), pkValue, startIndex, startIndex + (this.sqlBatchSize - 1)});
            }
        }, (startIndex, nonNullElementCount) -> {
            entityKeys.forEach(arg_0 -> ((BatchFetchQueue)batchFetchQueue).removeBatchLoadableEntityKey(arg_0));
            entityKeys.clear();
        }, session);
    }

    public String toString() {
        return String.format(Locale.ROOT, "EntityBatchLoaderInPredicate(%s [%s (%s)])", this.getLoadable().getEntityName(), this.domainBatchSize, this.sqlBatchSize);
    }
}

