/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import java.util.ArrayList;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.sql.FromClauseIndex;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveSelectExecutor;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.sql.results.internal.RowTransformerDatabaseSnapshotImpl;
import org.hibernate.type.StandardBasicTypes;
import org.jboss.logging.Logger;

class DatabaseSnapshotExecutor {
    private static final Logger log = Logger.getLogger(DatabaseSnapshotExecutor.class);
    private final EntityMappingType entityDescriptor;
    private final JdbcOperationQuerySelect jdbcSelect;
    private final JdbcParametersList jdbcParameters;

    DatabaseSnapshotExecutor(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        JdbcParametersList.Builder jdbcParametersBuilder = JdbcParametersList.newBuilder((int)entityDescriptor.getIdentifierMapping().getJdbcTypeCount());
        QuerySpec rootQuerySpec = new QuerySpec(true);
        SqlAliasBaseManager sqlAliasBaseManager = new SqlAliasBaseManager();
        LoaderSqlAstCreationState state = new LoaderSqlAstCreationState((QueryPart)rootQuerySpec, sqlAliasBaseManager, (FromClauseAccess)new FromClauseIndex(null), LockOptions.NONE, DatabaseSnapshotExecutor::visitEmptyFetchList, true, new LoadQueryInfluencers(sessionFactory), (SqlAstCreationContext)sessionFactory);
        NavigablePath rootPath = new NavigablePath(entityDescriptor.getEntityName());
        TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(true, rootPath, null, null, () -> arg_0 -> ((QuerySpec)rootQuerySpec).applyPredicate(arg_0), (SqlAstCreationState)state);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        state.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
        ArrayList<DomainResult> domainResults = new ArrayList<DomainResult>();
        SqlExpressionResolver sqlExpressionResolver = state.getSqlExpressionResolver();
        domainResults.add(new QueryLiteral(null, (SqlExpressible)sessionFactory.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER)).createDomainResult(null, (DomainResultCreationState)state));
        NavigablePath idNavigablePath = rootPath.append(entityDescriptor.getIdentifierMapping().getNavigableRole().getNavigableName());
        entityDescriptor.getIdentifierMapping().forEachSelectable((columnIndex, selection) -> {
            TableReference tableReference = rootTableGroup.resolveTableReference(idNavigablePath, selection.getContainingTableExpression());
            JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(selection.getJdbcMapping());
            jdbcParametersBuilder.add((JdbcParameter)jdbcParameter);
            ColumnReference columnReference = (ColumnReference)sqlExpressionResolver.resolveSqlExpression(tableReference, selection);
            rootQuerySpec.applyPredicate((Predicate)new ComparisonPredicate((Expression)columnReference, ComparisonOperator.EQUAL, (Expression)jdbcParameter));
        });
        this.jdbcParameters = jdbcParametersBuilder.build();
        entityDescriptor.forEachAttributeMapping(attributeMapping -> {
            NavigablePath navigablePath = rootPath.append(attributeMapping.getAttributeName());
            domainResults.add(attributeMapping.createSnapshotDomainResult(navigablePath, rootTableGroup, null, (DomainResultCreationState)state));
        });
        SelectStatement selectStatement = new SelectStatement((QueryPart)rootQuerySpec, domainResults);
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        this.jdbcSelect = (JdbcOperationQuerySelect)sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, selectStatement).translate(null, QueryOptions.NONE);
    }

    private static ImmutableFetchList visitEmptyFetchList(FetchParent fetchParent, LoaderSqlAstCreationState creationState) {
        return ImmutableFetchList.EMPTY;
    }

    CompletionStage<Object[]> loadDatabaseSnapshot(Object id, SharedSessionContractImplementor session) {
        if (log.isTraceEnabled()) {
            log.tracef("Getting current persistent state for `%s#%s`", (Object)this.entityDescriptor.getEntityName(), id);
        }
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(this.entityDescriptor.getIdentifierMapping().getJdbcTypeCount());
        int offset = jdbcParameterBindings.registerParametersForEachJdbcValue(id, (Bindable)this.entityDescriptor.getIdentifierMapping(), this.jdbcParameters, session);
        assert (offset == this.jdbcParameters.size());
        return StandardReactiveSelectExecutor.INSTANCE.list(this.jdbcSelect, (JdbcParameterBindings)jdbcParameterBindings, (ExecutionContext)new BaseExecutionContext(session), RowTransformerDatabaseSnapshotImpl.instance(), ReactiveListResultsConsumer.UniqueSemantic.FILTER).thenApply(list -> {
            assert (list != null);
            int size = list.size();
            assert (size <= 1);
            if (size == 0) {
                return null;
            }
            Object[] entitySnapshot = (Object[])list.get(0);
            if (entitySnapshot.length == 1) {
                return ArrayHelper.EMPTY_OBJECT_ARRAY;
            }
            Object[] state = new Object[entitySnapshot.length - 1];
            System.arraycopy(entitySnapshot, 1, state, 0, state.length);
            return state;
        });
    }
}

