/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.id.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jdbc.TooManyRowsAffectedException;
import org.hibernate.reactive.id.impl.BlockingIdentifierGenerator;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.pool.impl.Parameters;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class TableReactiveIdentifierGenerator
extends BlockingIdentifierGenerator
implements IdentifierGenerator {
    private boolean storeLastUsedValue;
    protected String renderedTableName;
    protected String segmentColumnName;
    protected String valueColumnName;
    private String segmentValue;
    private long initialValue;
    private int increment;
    private String selectQuery;
    private String insertQuery;
    private String updateQuery;

    @Override
    protected int getBlockSize() {
        return this.increment;
    }

    @Override
    protected CompletionStage<Long> nextHiValue(ReactiveConnectionSupplier session) {
        ReactiveConnection connection = session.getReactiveConnection();
        return connection.selectIdentifier(this.selectQuery, this.selectParameters(), Long.class).thenCompose(result -> {
            String sql;
            Object[] params;
            long id;
            if (result == null) {
                id = this.initialValue;
                long insertedValue = this.storeLastUsedValue ? id - (long)this.increment : id;
                params = this.insertParameters(insertedValue);
                sql = this.insertQuery;
            } else {
                long currentValue = result;
                long updatedValue = currentValue + (long)this.increment;
                id = this.storeLastUsedValue ? updatedValue : currentValue;
                params = this.updateParameters(currentValue, updatedValue);
                sql = this.updateQuery;
            }
            return connection.update(sql, params).thenCompose(rowCount -> {
                switch (rowCount) {
                    case 1: {
                        return CompletionStages.completedFuture(id);
                    }
                    case 0: {
                        return this.nextHiValue(session);
                    }
                }
                throw new TooManyRowsAffectedException("multiple rows in id table", 1, rowCount.intValue());
            });
        });
    }

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) {
        JdbcEnvironment jdbcEnvironment = (JdbcEnvironment)serviceRegistry.getService(JdbcEnvironment.class);
        this.segmentColumnName = this.determineSegmentColumnName(params, jdbcEnvironment);
        this.valueColumnName = this.determineValueColumnNameForTable(params, jdbcEnvironment);
        this.segmentValue = this.determineSegmentValue(params);
        this.initialValue = this.determineInitialValue(params);
        this.increment = this.determineIncrement(params);
        this.storeLastUsedValue = this.determineStoreLastUsedValue(serviceRegistry);
        this.renderedTableName = this.determineTableName(type, params, serviceRegistry);
        Dialect dialect = jdbcEnvironment.getDialect();
        Parameters parameters = Parameters.instance(dialect);
        this.selectQuery = parameters.process(this.applyLocksToSelect(dialect, "tbl", this.buildSelectQuery()));
        this.updateQuery = parameters.process(this.buildUpdateQuery());
        this.insertQuery = parameters.process(this.buildInsertQuery());
    }

    public void registerExportables(Database database) {
    }

    public void initialize(SqlStringGenerationContext context) {
    }

    public Object generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    private String applyLocksToSelect(Dialect dialect, String alias, String query) {
        return dialect.applyLocksToSql(query, new LockOptions(LockMode.PESSIMISTIC_WRITE).setAliasSpecificLockMode(alias, LockMode.PESSIMISTIC_WRITE), Collections.singletonMap(alias, new String[]{this.valueColumnName}));
    }

    protected Boolean determineStoreLastUsedValue(ServiceRegistry serviceRegistry) {
        return (Boolean)((ConfigurationService)serviceRegistry.getService(ConfigurationService.class)).getSetting("hibernate.id.generator.stored_last_used", StandardConverters.BOOLEAN, (Object)true);
    }

    protected String determineTableName(Type type, Properties params, ServiceRegistry serviceRegistry) {
        TableGenerator ormTableGenerator = new TableGenerator();
        ormTableGenerator.configure(type, params, serviceRegistry);
        return ormTableGenerator.getTableName();
    }

    protected String determineSegmentColumnName(Properties params, JdbcEnvironment jdbcEnvironment) {
        String name = ConfigurationHelper.getString((String)"segment_column_name", (Map)params, (String)"sequence_name");
        return jdbcEnvironment.getIdentifierHelper().toIdentifier(name).render(jdbcEnvironment.getDialect());
    }

    protected String determineValueColumnNameForTable(Properties params, JdbcEnvironment jdbcEnvironment) {
        String name = ConfigurationHelper.getString((String)"value_column_name", (Map)params, (String)"next_val");
        return jdbcEnvironment.getIdentifierHelper().toIdentifier(name).render(jdbcEnvironment.getDialect());
    }

    protected String determineSegmentValue(Properties params) {
        String segmentValue = params.getProperty("segment_value");
        if (StringHelper.isEmpty((String)segmentValue)) {
            segmentValue = this.determineDefaultSegmentValue(params);
        }
        return segmentValue;
    }

    protected String determineDefaultSegmentValue(Properties params) {
        boolean preferSegmentPerEntity = ConfigurationHelper.getBoolean((String)"prefer_entity_table_as_segment_value", (Map)params, (boolean)false);
        return preferSegmentPerEntity ? params.getProperty("target_table") : "default";
    }

    protected int determineInitialValue(Properties params) {
        return ConfigurationHelper.getInt((String)"initial_value", (Map)params, (int)1);
    }

    protected int determineIncrement(Properties params) {
        return ConfigurationHelper.getInt((String)"increment_size", (Map)params, (int)50);
    }

    protected Object[] updateParameters(long currentValue, long updatedValue) {
        return new Object[]{updatedValue, currentValue, this.segmentValue};
    }

    protected Object[] insertParameters(long insertedValue) {
        return new Object[]{this.segmentValue, insertedValue};
    }

    protected Object[] selectParameters() {
        return new Object[]{this.segmentValue};
    }

    protected String buildSelectQuery() {
        return "select tbl." + this.valueColumnName + " from " + this.renderedTableName + " tbl where tbl." + this.segmentColumnName + "=?";
    }

    protected String buildUpdateQuery() {
        return "update " + this.renderedTableName + " set " + this.valueColumnName + "=? where " + this.valueColumnName + "=?  and " + this.segmentColumnName + "=?";
    }

    protected String buildInsertQuery() {
        return "insert into " + this.renderedTableName + " (" + this.segmentColumnName + ", " + this.valueColumnName + ")  values (?, ?)";
    }
}

