/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.id.impl;

import java.util.Map;
import java.util.Properties;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.reactive.id.impl.ReactiveSequenceIdentifierGenerator;
import org.hibernate.reactive.id.impl.TableReactiveIdentifierGenerator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class EmulatedSequenceReactiveIdentifierGenerator
extends TableReactiveIdentifierGenerator {
    @Override
    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) {
        super.configure(type, params, serviceRegistry);
        ReactiveSequenceIdentifierGenerator generator = new ReactiveSequenceIdentifierGenerator();
        generator.configure(type, params, serviceRegistry);
    }

    @Override
    protected Boolean determineStoreLastUsedValue(ServiceRegistry serviceRegistry) {
        return false;
    }

    @Override
    protected String determineTableName(Type type, Properties params, ServiceRegistry serviceRegistry) {
        ReactiveSequenceIdentifierGenerator generator = new ReactiveSequenceIdentifierGenerator();
        generator.configure(type, params, serviceRegistry);
        return generator.getSequenceName().render();
    }

    @Override
    protected String determineValueColumnNameForTable(Properties params, JdbcEnvironment jdbcEnvironment) {
        String name = ConfigurationHelper.getString((String)"value_column", (Map)params, (String)"next_val");
        return jdbcEnvironment.getIdentifierHelper().toIdentifier(name).render(jdbcEnvironment.getDialect());
    }

    @Override
    protected String determineSegmentColumnName(Properties params, JdbcEnvironment jdbcEnvironment) {
        return null;
    }

    @Override
    protected String determineSegmentValue(Properties params) {
        return null;
    }

    @Override
    protected int determineInitialValue(Properties params) {
        return ConfigurationHelper.getInt((String)"initial_value", (Map)params, (int)1);
    }

    @Override
    protected int determineIncrement(Properties params) {
        return ConfigurationHelper.getInt((String)"increment_size", (Map)params, (int)50);
    }

    @Override
    protected Object[] updateParameters(long currentValue, long updatedValue) {
        return new Object[]{updatedValue, currentValue};
    }

    @Override
    protected Object[] insertParameters(long insertedValue) {
        return new Object[]{insertedValue};
    }

    @Override
    protected Object[] selectParameters() {
        return new Object[0];
    }

    @Override
    protected String buildSelectQuery() {
        return "select tbl." + this.valueColumnName + " from " + this.renderedTableName + " tbl";
    }

    @Override
    protected String buildUpdateQuery() {
        return "update " + this.renderedTableName + " set " + this.valueColumnName + "=? where " + this.valueColumnName + "=?";
    }

    @Override
    protected String buildInsertQuery() {
        return "insert into " + this.renderedTableName + " (" + this.valueColumnName + ")  values (?)";
    }
}

