/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.PersistentObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.action.internal.DelayedPostInsertIdentifier;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.loader.ast.internal.CacheEntityLoaderHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.reactive.event.ReactiveLoadEventListener;
import org.hibernate.reactive.event.impl.UnexpectedAccessToTheDatabase;
import org.hibernate.reactive.loader.entity.ReactiveCacheEntityLoaderHelper;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.session.impl.ReactiveQueryExecutorLookup;
import org.hibernate.reactive.session.impl.SessionUtil;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.spi.StatisticsImplementor;

public class DefaultReactiveLoadEventListener
implements LoadEventListener,
ReactiveLoadEventListener {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public void onLoad(LoadEvent event, LoadEventListener.LoadType loadType) throws HibernateException {
        EntityPersister persister = this.getPersister(event);
        if (persister == null) {
            throw LOG.unableToLocatePersister(event.getEntityClassName());
        }
        CompletionStage<Void> checkId = this.checkId(event, loadType, persister);
        if (!checkId.toCompletableFuture().isDone()) {
            throw new UnexpectedAccessToTheDatabase();
        }
        try {
            CompletionStage<Object> loaded = this.doOnLoad(persister, event, loadType);
            if (!loaded.toCompletableFuture().isDone()) {
                throw new UnexpectedAccessToTheDatabase();
            }
            event.setResult(loaded.toCompletableFuture().getNow(null));
        }
        catch (HibernateException e) {
            LOG.unableToLoadCommand(e);
            throw e;
        }
        if (event.getResult() instanceof CompletionStage) {
            throw new AssertionFailure("Unexpected CompletionStage");
        }
    }

    @Override
    public CompletionStage<Void> reactiveOnLoad(LoadEvent event, LoadEventListener.LoadType loadType) throws HibernateException {
        ReactiveEntityPersister persister = (ReactiveEntityPersister)this.getPersister(event);
        if (persister == null) {
            throw LOG.unableToLocatePersister(event.getEntityClassName());
        }
        return this.checkId(event, loadType, persister).thenCompose(vd -> this.doOnLoad(persister, event, loadType).thenAccept(arg_0 -> ((LoadEvent)event).setResult(arg_0)).handle((v, x) -> {
            if (event.getResult() instanceof CompletionStage) {
                throw new AssertionFailure("Unexpected CompletionStage");
            }
            if (x instanceof HibernateException) {
                LOG.unableToLoadCommand((HibernateException)((Object)((Object)x)));
            }
            return CompletionStages.returnNullorRethrow(x);
        })).thenCompose(v -> {
            if (event.getLockMode() == LockMode.PESSIMISTIC_FORCE_INCREMENT) {
                return persister.reactiveLock(event.getEntityId(), persister.getVersion(event.getResult()), event.getResult(), event.getLockOptions(), (SharedSessionContractImplementor)event.getSession());
            }
            return CompletionStages.voidFuture();
        });
    }

    private CompletionStage<Void> checkId(LoadEvent event, LoadEventListener.LoadType loadType, EntityPersister persister) {
        Class idClass = persister.getIdentifierType().getReturnedClass();
        if (idClass != null && !idClass.isInstance(event.getEntityId()) && !(event.getEntityId() instanceof DelayedPostInsertIdentifier)) {
            return this.checkIdClass(persister, event, loadType, idClass);
        }
        return CompletionStages.voidFuture();
    }

    protected EntityPersister getPersister(LoadEvent event) {
        Object instanceToLoad = event.getInstanceToLoad();
        EventSource source = event.getSession();
        if (instanceToLoad != null) {
            event.setEntityClassName(instanceToLoad.getClass().getName());
            return source.getEntityPersister(null, instanceToLoad);
        }
        return source.getFactory().getMappingMetamodel().getEntityDescriptor(event.getEntityClassName());
    }

    private CompletionStage<Object> doOnLoad(EntityPersister persister, LoadEvent event, LoadEventListener.LoadType loadType) {
        EventSource session = event.getSession();
        EntityKey keyToLoad = session.generateEntityKey(event.getEntityId(), persister);
        if (loadType.isNakedEntityReturned()) {
            return this.load(event, persister, keyToLoad, loadType);
        }
        return event.getLockMode() == LockMode.NONE ? this.proxyOrLoad(event, persister, keyToLoad, loadType) : this.lockAndLoad(event, persister, keyToLoad, loadType, (SessionImplementor)session);
    }

    private CompletionStage<Void> checkIdClass(EntityPersister persister, LoadEvent event, LoadEventListener.LoadType loadType, Class<?> idClass) {
        EntityIdentifierMapping idMapping = persister.getIdentifierMapping();
        if (idMapping instanceof CompositeIdentifierMapping) {
            CompositeIdentifierMapping compositeIdMapping = (CompositeIdentifierMapping)idMapping;
            AttributeMappingsList attributeMappings = compositeIdMapping.getPartMappingType().getAttributeMappings();
            if (attributeMappings.size() == 1) {
                AttributeMapping singleIdAttribute = attributeMappings.get(0);
                if (singleIdAttribute.getMappedType() instanceof EntityMappingType) {
                    MappingType parentIdType;
                    EntityMappingType parentIdTargetMapping = (EntityMappingType)singleIdAttribute.getMappedType();
                    EntityIdentifierMapping parentIdTargetIdMapping = parentIdTargetMapping.getIdentifierMapping();
                    Object object = parentIdType = parentIdTargetIdMapping instanceof CompositeIdentifierMapping ? ((CompositeIdentifierMapping)parentIdTargetIdMapping).getMappedIdEmbeddableTypeDescriptor() : parentIdTargetIdMapping.getMappedType();
                    if (parentIdType.getMappedJavaType().getJavaTypeClass().isInstance(event.getEntityId())) {
                        return this.loadByDerivedIdentitySimplePkValue(event, loadType, persister, compositeIdMapping, (EntityPersister)parentIdTargetMapping);
                    }
                } else if (idClass.isInstance(event.getEntityId())) {
                    return CompletionStages.voidFuture();
                }
            } else if (idMapping instanceof NonAggregatedIdentifierMapping && idClass.isInstance(event.getEntityId())) {
                return CompletionStages.voidFuture();
            }
        }
        throw new TypeMismatchException("Provided id of the wrong type for class " + persister.getEntityName() + ". Expected: " + idClass + ", got " + event.getEntityId().getClass());
    }

    private CompletionStage<Void> loadByDerivedIdentitySimplePkValue(LoadEvent event, LoadEventListener.LoadType options, EntityPersister dependentPersister, CompositeIdentifierMapping dependentIdType, EntityPersister parentPersister) {
        EventSource session = event.getSession();
        EntityKey parentEntityKey = session.generateEntityKey(event.getEntityId(), parentPersister);
        return this.doLoad(event, parentPersister, parentEntityKey, options).thenApply(parent -> {
            SessionUtil.checkEntityFound((SharedSessionContractImplementor)session, parentEntityKey.getEntityName(), parentEntityKey, parent);
            Object dependent = dependentIdType.instantiate();
            dependentIdType.getPartMappingType().setValues(dependent, new Object[]{parent});
            event.setEntityId(dependent);
            return session.generateEntityKey(dependent, dependentPersister);
        }).thenCompose(dependentEntityKey -> this.doLoad(event, dependentPersister, (EntityKey)dependentEntityKey, options)).thenAccept(arg_0 -> ((LoadEvent)event).setResult(arg_0));
    }

    private CompletionStage<Object> load(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        EventSource session = event.getSession();
        if (event.getInstanceToLoad() != null) {
            if (session.getPersistenceContextInternal().getEntry(event.getInstanceToLoad()) != null) {
                throw new PersistentObjectException("attempted to load into an instance that was already associated with the session: " + MessageHelper.infoString((EntityPersister)persister, (Object)event.getEntityId(), (SessionFactoryImplementor)session.getFactory()));
            }
            persister.setIdentifier(event.getInstanceToLoad(), event.getEntityId(), (SharedSessionContractImplementor)session);
        }
        return this.doLoad(event, persister, keyToLoad, options).thenApply(optional -> {
            boolean isOptionalInstance;
            boolean bl = isOptionalInstance = event.getInstanceToLoad() != null;
            if (optional == null && (!options.isAllowNulls() || isOptionalInstance)) {
                SessionUtil.throwEntityNotFound((SharedSessionContractImplementor)session, event.getEntityClassName(), event.getEntityId());
            } else if (isOptionalInstance && optional != event.getInstanceToLoad()) {
                throw new NonUniqueObjectException(event.getEntityId(), event.getEntityClassName());
            }
            return optional;
        });
    }

    private CompletionStage<Object> proxyOrLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Loading entity: {0}", MessageHelper.infoString((EntityPersister)persister, (Object)event.getEntityId(), (SessionFactoryImplementor)persister.getFactory()));
        }
        if (DefaultReactiveLoadEventListener.hasBytecodeProxy(persister, options)) {
            return this.loadWithBytecodeProxy(event, persister, keyToLoad, options);
        }
        if (persister.hasProxy()) {
            return this.loadWithRegularProxy(event, persister, keyToLoad, options);
        }
        return this.load(event, persister, keyToLoad, options);
    }

    private static boolean wasDeleted(PersistenceContext persistenceContext, Object existing) {
        return persistenceContext.getEntry(existing).getStatus().isDeletedOrGone();
    }

    private CompletionStage<Object> loadWithBytecodeProxy(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        EventSource session = event.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        Object managed = persistenceContext.getEntity(keyToLoad);
        if (managed != null) {
            return options.isCheckDeleted() && DefaultReactiveLoadEventListener.wasDeleted(persistenceContext, managed) ? CompletionStages.nullFuture() : CompletionStages.completedFuture(managed);
        }
        if (persister.getRepresentationStrategy().getProxyFactory() != null) {
            return DefaultReactiveLoadEventListener.loadWithProxyFactory(event, persister, keyToLoad);
        }
        if (persister.hasSubclasses()) {
            return this.load(event, persister, keyToLoad, options);
        }
        return CompletionStages.completedFuture(DefaultReactiveLoadEventListener.createBatchLoadableEnhancedProxy(persister, keyToLoad, session));
    }

    private CompletionStage<Object> loadWithRegularProxy(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        Object proxy = event.getSession().getPersistenceContextInternal().getProxy(keyToLoad);
        if (proxy != null) {
            return this.narrowedProxy(event, persister, keyToLoad, options, proxy);
        }
        if (options.isAllowProxyCreation()) {
            return CompletionStages.completedFuture(DefaultReactiveLoadEventListener.proxyOrCached(event, persister, keyToLoad, options));
        }
        return this.load(event, persister, keyToLoad, options);
    }

    private static boolean hasBytecodeProxy(EntityPersister persister, LoadEventListener.LoadType options) {
        return options.isAllowProxyCreation() && persister.getEntityPersister().getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
    }

    private static CompletionStage<Object> loadWithProxyFactory(LoadEvent event, EntityPersister persister, EntityKey keyToLoad) {
        EventSource session = event.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        Object proxy = persistenceContext.getProxy(keyToLoad);
        if (proxy != null) {
            LOG.trace("Entity proxy found in session cache");
            if (LOG.isDebugEnabled() && HibernateProxy.extractLazyInitializer((Object)proxy).isUnwrap()) {
                LOG.debug("Ignoring NO_PROXY to honor laziness");
            }
            return CompletionStages.completedFuture(persistenceContext.narrowProxy(proxy, persister, keyToLoad, null));
        }
        if (persister.hasSubclasses()) {
            return CompletionStages.completedFuture(DefaultReactiveLoadEventListener.proxyOrCached(event, persister, keyToLoad));
        }
        return CompletionStages.completedFuture(DefaultReactiveLoadEventListener.createBatchLoadableEnhancedProxy(persister, keyToLoad, session));
    }

    private static PersistentAttributeInterceptable createBatchLoadableEnhancedProxy(EntityPersister persister, EntityKey keyToLoad, EventSource session) {
        if (keyToLoad.isBatchLoadable(session.getLoadQueryInfluencers())) {
            session.getPersistenceContextInternal().getBatchFetchQueue().addBatchLoadableEntityKey(keyToLoad);
        }
        return persister.getBytecodeEnhancementMetadata().createEnhancedProxy(keyToLoad, true, (SharedSessionContractImplementor)session);
    }

    private static Object proxyOrCached(LoadEvent event, EntityPersister persister, EntityKey keyToLoad) {
        Object cachedEntity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(event.getSession(), null, LockMode.NONE, persister, keyToLoad);
        if (cachedEntity != null) {
            return cachedEntity;
        }
        return DefaultReactiveLoadEventListener.createProxy(event, persister, keyToLoad);
    }

    private static Object proxyOrCached(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        Object cachedEntity;
        PersistenceContext persistenceContext = event.getSession().getPersistenceContext();
        Object existing = persistenceContext.getEntity(keyToLoad);
        if (existing != null) {
            return options.isCheckDeleted() && DefaultReactiveLoadEventListener.wasDeleted(persistenceContext, existing) ? null : existing;
        }
        if (persister.hasSubclasses() && (cachedEntity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(event.getSession(), null, LockMode.NONE, persister, keyToLoad)) != null) {
            return cachedEntity;
        }
        return DefaultReactiveLoadEventListener.createProxyIfNecessary(event, persister, keyToLoad, options);
    }

    private CompletionStage<Object> narrowedProxy(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, Object proxy) {
        LazyInitializer li;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Entity proxy found in session cache");
        }
        if ((li = ((HibernateProxy)proxy).getHibernateLazyInitializer()).isUnwrap()) {
            return CompletionStages.completedFuture(li.getImplementation());
        }
        PersistenceContext persistenceContext = event.getSession().getPersistenceContextInternal();
        if (options.isAllowProxyCreation()) {
            return CompletionStages.completedFuture(persistenceContext.narrowProxy(proxy, persister, keyToLoad, null));
        }
        return this.proxyImplementation(event, persister, keyToLoad, options).thenApply(impl -> impl == null ? null : persistenceContext.narrowProxy(proxy, persister, keyToLoad, impl));
    }

    private CompletionStage<Object> proxyImplementation(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        return this.load(event, persister, keyToLoad, options).thenApply(optional -> {
            if (optional != null) {
                return optional;
            }
            if (options != LoadEventListener.INTERNAL_LOAD_NULLABLE) {
                event.getSession().getFactory().getEntityNotFoundDelegate().handleEntityNotFound(persister.getEntityName(), keyToLoad.getIdentifier());
            }
            return null;
        });
    }

    private static Object createProxyIfNecessary(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        PersistenceContext persistenceContext = event.getSession().getPersistenceContextInternal();
        Object existing = persistenceContext.getEntity(keyToLoad);
        if (existing != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Entity found in session cache");
            }
            return options.isCheckDeleted() && DefaultReactiveLoadEventListener.wasDeleted(persistenceContext, existing) ? null : existing;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating new proxy for entity");
        }
        return DefaultReactiveLoadEventListener.createProxy(event, persister, keyToLoad);
    }

    private static Object createProxy(LoadEvent event, EntityPersister persister, EntityKey keyToLoad) {
        Object proxy = persister.createProxy(event.getEntityId(), (SharedSessionContractImplementor)event.getSession());
        PersistenceContext persistenceContext = event.getSession().getPersistenceContextInternal();
        persistenceContext.getBatchFetchQueue().addBatchLoadableEntityKey(keyToLoad);
        persistenceContext.addProxy(keyToLoad, proxy);
        return proxy;
    }

    private CompletionStage<Object> lockAndLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, SessionImplementor source) {
        SoftLock lock;
        Object cacheKey;
        boolean canWriteToCache = persister.canWriteToCache();
        if (canWriteToCache) {
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            cacheKey = cache.generateCacheKey(event.getEntityId(), persister, source.getFactory(), source.getTenantIdentifier());
            lock = cache.lockItem((SharedSessionContractImplementor)source, cacheKey, null);
        } else {
            cacheKey = null;
            lock = null;
        }
        try {
            return this.load(event, persister, keyToLoad, options).whenComplete((v, x) -> {
                if (canWriteToCache) {
                    persister.getCacheAccessStrategy().unlockItem((SharedSessionContractImplementor)source, cacheKey, lock);
                }
            }).thenApply(entity -> source.getPersistenceContextInternal().proxyFor(persister, keyToLoad, entity));
        }
        catch (HibernateException he) {
            if (canWriteToCache) {
                persister.getCacheAccessStrategy().unlockItem((SharedSessionContractImplementor)source, cacheKey, lock);
            }
            throw he;
        }
    }

    private CompletionStage<Object> doLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Attempting to resolve: {0}", MessageHelper.infoString((EntityPersister)persister, (Object)event.getEntityId(), (SessionFactoryImplementor)event.getSession().getFactory()));
        }
        if (event.getSession().getPersistenceContextInternal().containsDeletedUnloadedEntityKey(keyToLoad)) {
            return CompletionStages.nullFuture();
        }
        CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry = ReactiveCacheEntityLoaderHelper.INSTANCE.loadFromSessionCache(event, keyToLoad, options);
        Object entity = persistenceContextEntry.getEntity();
        if (entity != null) {
            return persistenceContextEntry.isManaged() ? DefaultReactiveLoadEventListener.initializeIfNecessary(entity) : CompletionStages.nullFuture();
        }
        return this.loadFromCacheOrDatasource(event, persister, keyToLoad);
    }

    private static CompletionStage<Object> initializeIfNecessary(Object entity) {
        if (ManagedTypeHelper.isPersistentAttributeInterceptable((Object)entity)) {
            PersistentAttributeInterceptable interceptable = ManagedTypeHelper.asPersistentAttributeInterceptable((Object)entity);
            PersistentAttributeInterceptor interceptor = interceptable.$$_hibernate_getInterceptor();
            if (interceptor instanceof EnhancementAsProxyLazinessInterceptor) {
                EnhancementAsProxyLazinessInterceptor lazinessInterceptor = (EnhancementAsProxyLazinessInterceptor)interceptor;
                SharedSessionContractImplementor session = lazinessInterceptor.getLinkedSession();
                if (session == null) {
                    throw LOG.sessionClosedLazyInitializationException();
                }
                return ReactiveQueryExecutorLookup.extract(session).reactiveFetch(entity, false);
            }
            return CompletionStages.completedFuture(entity);
        }
        return CompletionStages.completedFuture(entity);
    }

    private CompletionStage<Object> loadFromCacheOrDatasource(LoadEvent event, EntityPersister persister, EntityKey keyToLoad) {
        EventSource session = event.getSession();
        Object entity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(event, persister, keyToLoad);
        if (entity != null) {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Resolved object in second-level cache: {0}", MessageHelper.infoString((EntityPersister)persister, (Object)event.getEntityId(), (SessionFactoryImplementor)session.getFactory()));
            }
            this.cacheNaturalId(event, persister, session, entity);
            return CompletionStages.completedFuture(entity);
        }
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Object not resolved in any cache: {0}", MessageHelper.infoString((EntityPersister)persister, (Object)event.getEntityId(), (SessionFactoryImplementor)session.getFactory()));
        }
        return this.loadFromDatasource(event, persister).thenApply(optional -> {
            if (optional != null) {
                this.cacheNaturalId(event, persister, session, optional);
            }
            return optional;
        });
    }

    private void cacheNaturalId(LoadEvent event, EntityPersister persister, EventSource session, Object entity) {
        if (entity != null && persister.hasNaturalIdentifier()) {
            session.getPersistenceContextInternal().getNaturalIdResolutions().cacheResolutionFromLoad(event.getEntityId(), persister.getNaturalIdMapping().extractNaturalIdFromEntity(entity), (EntityMappingType)persister);
        }
    }

    protected CompletionStage<Object> loadFromDatasource(LoadEvent event, EntityPersister persister) {
        return ((ReactiveEntityPersister)persister).reactiveLoad(event.getEntityId(), event.getInstanceToLoad(), event.getLockOptions(), (SharedSessionContractImplementor)event.getSession()).thenApply(entity -> {
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer((Object)entity);
            if (lazyInitializer != null) {
                entity = lazyInitializer.getImplementation();
            }
            StatisticsImplementor statistics = event.getSession().getFactory().getStatistics();
            if (event.isAssociationFetch() && statistics.isStatisticsEnabled()) {
                statistics.fetchEntity(event.getEntityClassName());
            }
            return entity;
        });
    }
}

