/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.reactive.event.ReactiveFlushEventListener;
import org.hibernate.reactive.event.impl.AbstractReactiveFlushingEventListener;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.spi.StatisticsImplementor;

public class DefaultReactiveFlushEventListener
extends AbstractReactiveFlushingEventListener
implements ReactiveFlushEventListener,
FlushEventListener {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    @Override
    public CompletionStage<Void> reactiveOnFlush(FlushEvent event) throws HibernateException {
        EventSource source = event.getSession();
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        if (persistenceContext.getNumberOfManagedEntities() > 0 || persistenceContext.getCollectionEntriesSize() > 0) {
            source.getEventListenerManager().flushStart();
            return this.flushEverythingToExecutions(event).thenCompose(v -> this.performExecutions(source)).thenRun(() -> this.postFlush((SessionImplementor)source)).whenComplete((v, x) -> source.getEventListenerManager().flushEnd(event.getNumberOfEntitiesProcessed(), event.getNumberOfCollectionsProcessed())).thenRun(() -> {
                this.postPostFlush((SessionImplementor)source);
                StatisticsImplementor statistics = source.getFactory().getStatistics();
                if (statistics.isStatisticsEnabled()) {
                    statistics.flush();
                }
            });
        }
        if (((ReactiveSession)source).getReactiveActionQueue().hasAnyQueuedActions()) {
            return this.performExecutions(source);
        }
        return CompletionStages.voidFuture();
    }

    public void onFlush(FlushEvent event) throws HibernateException {
        throw LOG.nonReactiveMethodCall("reactiveOnFlush");
    }
}

