/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;

public class ReactivePersistenceContextAdapter
extends StatefulPersistenceContext {
    private HashMap<Serializable, Object[]> entitySnapshotsByKey;
    private static final Object[] NO_ROW = new Object[]{StatefulPersistenceContext.NO_ROW};

    public ReactivePersistenceContextAdapter(SharedSessionContractImplementor session) {
        super(session);
    }

    public CompletionStage<Void> reactiveInitializeNonLazyCollections() throws HibernateException {
        NonLazyCollectionInitializer initializer = new NonLazyCollectionInitializer();
        this.initializeNonLazyCollections(initializer);
        return initializer.stage;
    }

    @Deprecated
    public void initializeNonLazyCollections() {
    }

    @Deprecated
    public Object[] getDatabaseSnapshot(Object id, EntityPersister persister) throws HibernateException {
        throw new UnsupportedOperationException("reactive persistence context");
    }

    public CompletionStage<Object[]> reactiveGetDatabaseSnapshot(Object id, EntityPersister persister) throws HibernateException {
        Object[] cached;
        SessionImplementor session = (SessionImplementor)this.getSession();
        EntityKey key = session.generateEntityKey(id, persister);
        Object[] objectArray = cached = this.entitySnapshotsByKey == null ? null : this.entitySnapshotsByKey.get(key);
        if (cached != null) {
            return CompletionStages.completedFuture(cached == NO_ROW ? null : cached);
        }
        return ((ReactiveEntityPersister)persister).reactiveGetDatabaseSnapshot(id, (SharedSessionContractImplementor)session).thenApply(snapshot -> {
            if (this.entitySnapshotsByKey == null) {
                this.entitySnapshotsByKey = new HashMap(8);
            }
            this.entitySnapshotsByKey.put((Serializable)key, snapshot == null ? NO_ROW : snapshot);
            return snapshot;
        });
    }

    public Object[] getCachedDatabaseSnapshot(EntityKey key) {
        Object[] snapshot;
        Object[] objectArray = snapshot = this.entitySnapshotsByKey == null ? null : this.entitySnapshotsByKey.get(key);
        if (snapshot == NO_ROW) {
            throw new IllegalStateException("persistence context reported no row snapshot for " + MessageHelper.infoString((String)key.getEntityName(), (Object)key.getIdentifier()));
        }
        return snapshot;
    }

    public void clear() {
        super.clear();
        this.entitySnapshotsByKey = null;
    }

    public Object removeEntity(EntityKey key) {
        Object result = super.removeEntity(key);
        if (this.entitySnapshotsByKey != null) {
            this.entitySnapshotsByKey.remove(key);
        }
        return result;
    }

    private class NonLazyCollectionInitializer
    implements Consumer<PersistentCollection<?>> {
        CompletionStage<Void> stage = CompletionStages.voidFuture();

        private NonLazyCollectionInitializer() {
        }

        @Override
        public void accept(PersistentCollection<?> nonLazyCollection) {
            if (!nonLazyCollection.wasInitialized()) {
                this.stage = this.stage.thenCompose(v -> ((ReactiveSession)ReactivePersistenceContextAdapter.this.getSession()).reactiveInitializeCollection(nonLazyCollection, false));
            }
        }
    }
}

